package com.supcon.common.view.base.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;

import com.supcon.common.view.base.adapter.viewholder.BaseRecyclerViewHolder;
import com.supcon.common.view.listener.OnItemChildViewClickListener;

/**
 * Created by wangshizhan on 16/12/1.
 *
 * @param <T> the type parameter
 */
public abstract class BaseRecyclerViewAdapter<T> extends RecyclerView.Adapter<BaseRecyclerViewHolder<T>> {
    /**
     * The Context.
     */
    protected Context context;
    /**
     * The Parent.
     */
    protected ViewGroup parent;
    /**
     * The On item child view click listener.
     */
    protected OnItemChildViewClickListener onItemChildViewClickListener;

    /**
     * Instantiates a new Base recycler view adapter.
     *
     * @param context the context
     */
    public BaseRecyclerViewAdapter(Context context) {
        super();
        this.context = context;
    }

    /**
     * Sets on item child view click listener.
     *
     * @param onItemChildViewClickListener the on item child view click listener
     */
    public void setOnItemChildViewClickListener(OnItemChildViewClickListener onItemChildViewClickListener) {
        this.onItemChildViewClickListener = onItemChildViewClickListener;
    }

    /**
     * 返回 ViewHolder
     *
     * @param viewType ViewHolder类型
     * @return view holder
     */
    protected abstract BaseRecyclerViewHolder<T> getViewHolder(int viewType);

    /**
     * 返回数据
     *
     * @param position 行索引
     * @return item
     */
    public abstract T getItem(int position);

    @Override
    public BaseRecyclerViewHolder<T> onCreateViewHolder(ViewGroup parent, int viewType) {
        this.parent = parent;//解决inflate时，parent=null布局显示不正常问题
        BaseRecyclerViewHolder<T> viewHolder = getViewHolder(viewType);
        //监听
        viewHolder.setOnItemChildViewClickListener(onItemChildViewClickListener);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(BaseRecyclerViewHolder<T> holder, int position) {
        holder.notifyChanged(getItem(position));
    }
}
