/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.view.loader.base;

import android.content.Context;
import android.view.View;
import com.supcon.common.view.base.controller.BaseController;
import com.supcon.common.view.util.LogUtil;
import com.supcon.common.view.view.loader.base.DefautLoader;
import com.supcon.common.view.view.loader.base.ILoader;
import com.supcon.common.view.view.loader.base.ILoaderController;
import com.supcon.common.view.view.loader.base.OnLoaderFinishListener;
import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class LoaderController
extends BaseController
implements ILoaderController {
    private ILoader customLoader;
    private ILoader defautLoader;
    private Disposable lock;
    private static long DEFAULT_LOCK_GAP_TIME = 500L;
    private long intervalTime = DEFAULT_LOCK_GAP_TIME;
    public static final int MSG_TYPE_LOADING = 0;
    public static final int MSG_TYPE_LOAD_SUCCESS = 1;
    public static final int MSG_TYPE_LOAD_FAILED = 2;
    public static final int MSG_TYPE_LOAD_CLOSE = 3;
    private List<Msg> mMsgList = new ArrayList<Msg>();
    private OnLoaderFinishListener mOnLoaderFinishListener;

    public LoaderController(Context context, View rootView) {
        this.defautLoader = new DefautLoader(context, rootView);
    }

    public void setIntervalTime(long intervalTime) {
        this.intervalTime = intervalTime;
    }

    private void resetLock() {
        this.lock = Flowable.timer((long)this.intervalTime, (TimeUnit)TimeUnit.MILLISECONDS).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) throws Exception {
                if (LoaderController.this.mMsgList.size() != 0) {
                    LoaderController.this.handleMsg((Msg)LoaderController.this.mMsgList.get(0));
                }
            }
        });
    }

    private synchronized boolean isLocked() {
        if (this.lock == null) {
            this.resetLock();
            return false;
        }
        if (this.lock.isDisposed()) {
            this.resetLock();
            return false;
        }
        return true;
    }

    private void submit(Msg msg) {
        Flowable.just((Object)msg).delay(this.intervalTime, TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Msg>(){

            public void accept(Msg m) throws Exception {
                if (LoaderController.this.mMsgList.size() != 0) {
                    LoaderController.this.handleMsg(m);
                }
            }
        });
    }

    private void handleMsg(Msg m) {
        LogUtil.d("handleMsg msg:" + m.mMsg);
        if (m.mMsgType == 0) {
            if (this.customLoader != null) {
                this.customLoader.showLoader(m.mMsg);
            } else {
                this.defautLoader.showLoader(m.mMsg);
            }
        } else if (m.mMsgType == 3) {
            this.closeLoader();
        } else if (m.mMsgType == 1) {
            if (this.customLoader != null) {
                this.customLoader.showResultMsg(m.mMsg, true);
            } else {
                this.defautLoader.showResultMsg(m.mMsg, true);
            }
            this.delayToFinish(m.timeDelayToFinish, m.mOnLoaderFinishListener);
        } else if (m.mMsgType == 2) {
            if (this.customLoader != null) {
                this.customLoader.showResultMsg(m.mMsg, false);
            } else {
                this.defautLoader.showResultMsg(m.mMsg, false);
            }
            this.delayToFinish(m.timeDelayToFinish, m.mOnLoaderFinishListener);
        }
        if (this.mMsgList.size() != 0) {
            this.mMsgList.remove(0);
        }
        if (this.mMsgList.size() != 0) {
            this.submit(this.mMsgList.get(0));
        }
    }

    private void delayToFinish(long delayTime, final OnLoaderFinishListener loaderFinishListener) {
        Flowable.timer((long)delayTime, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) throws Exception {
                LoaderController.this.closeLoader();
                if (loaderFinishListener != null) {
                    loaderFinishListener.onLoaderFinished();
                }
            }
        });
    }

    public void setCustomLoader(ILoader customLoader) {
        this.customLoader = customLoader;
    }

    public void showLoader() {
        this.showLoader("");
    }

    @Override
    public void showLoader(String msg) {
        if (!this.isLocked()) {
            if (this.customLoader != null) {
                this.customLoader.showLoader(msg);
            } else {
                this.defautLoader.showLoader(msg);
            }
        } else {
            this.mMsgList.add(new Msg(msg, 0));
        }
    }

    @Override
    public void closeLoader() {
        if (!this.isLocked()) {
            if (this.customLoader != null) {
                this.customLoader.closeLoader();
            } else {
                this.defautLoader.closeLoader();
            }
            this.mMsgList.clear();
        } else {
            this.mMsgList.add(new Msg("", 3));
        }
    }

    @Override
    public void showMsg(String msg, long timeDelayToFinish) {
        if (!this.isLocked()) {
            if (this.customLoader != null) {
                this.customLoader.showMsg(msg);
            } else {
                this.defautLoader.showMsg(msg);
            }
            if (timeDelayToFinish != 0L) {
                this.delayToFinish(timeDelayToFinish, null);
            }
        } else {
            this.mMsgList.add(new Msg(msg, 0));
        }
    }

    @Override
    public void showMsgAndclose(String msg, boolean isSuccess, long timeDelayToFinish) {
        this.showMsgAndclose(msg, isSuccess, timeDelayToFinish, null);
    }

    @Override
    public void showMsgAndclose(String msg, boolean isSuccess, long timeDelayToFinish, OnLoaderFinishListener listener) {
        if (!this.isLocked()) {
            if (this.customLoader != null) {
                this.customLoader.showResultMsg(msg, isSuccess);
            } else {
                this.defautLoader.showResultMsg(msg, isSuccess);
            }
            if (timeDelayToFinish != 0L) {
                this.delayToFinish(timeDelayToFinish, listener);
            }
        } else {
            this.mMsgList.add(new Msg(msg, isSuccess ? 1 : 2, timeDelayToFinish, listener));
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.lock != null && !this.lock.isDisposed()) {
            this.lock.dispose();
        }
        this.closeLoader();
    }

    class Msg {
        private int mMsgType;
        private String mMsg;
        private OnLoaderFinishListener mOnLoaderFinishListener;
        private long timeDelayToFinish;

        public Msg(String msg, int type) {
            this.mMsg = msg;
            this.mMsgType = type;
        }

        public Msg(String msg, int type, long timeDelayToFinish) {
            this(msg, type);
            this.timeDelayToFinish = timeDelayToFinish;
        }

        public Msg(String msg, int type, long timeDelayToFinish, OnLoaderFinishListener listener) {
            this(msg, type, timeDelayToFinish);
            this.mOnLoaderFinishListener = listener;
        }
    }
}

