/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetWorkUtil {
    public static boolean isNetConnected(Context context) {
        NetworkInfo[] infos;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm != null && (infos = cm.getAllNetworkInfo()) != null) {
            for (NetworkInfo ni : infos) {
                if (!ni.isConnected()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWifiConnected(Context context) {
        NetworkInfo networkInfo;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return cm != null && (networkInfo = cm.getActiveNetworkInfo()) != null && networkInfo.getType() == 1;
    }

    public static boolean is3gConnected(Context context) {
        NetworkInfo networkInfo;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return cm != null && (networkInfo = cm.getActiveNetworkInfo()) != null && networkInfo.getType() == 0;
    }

    public static boolean isLinkAvailable(String link) {
        Pattern pattern = Pattern.compile("^(http://|https://)?((?:[A-Za-z0-9]+-[A-Za-z0-9]+|[A-Za-z0-9]+)\\.)+([A-Za-z]+)[/\\?\\:]?.*$", 2);
        Matcher matcher = pattern.matcher(link);
        return matcher.matches();
    }
}

