/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.adapter.viewholder;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import com.supcon.common.view.util.ViewBinder;

public abstract class BaseBaseViewHolder<T> {
    protected View rootView;
    protected int position;
    protected Context context;

    public BaseBaseViewHolder(Context context) {
        this.context = context;
        this.rootView = LayoutInflater.from((Context)context).inflate(this.layoutId(), null);
        if (this.rootView != null) {
            this.initBind();
            this.initView();
            this.initListener();
            this.rootView.setTag((Object)this);
        }
    }

    public int getPosition() {
        return this.position;
    }

    public View getRootView() {
        return this.rootView;
    }

    protected abstract int layoutId();

    protected abstract void update(T var1);

    protected void initBind() {
        ViewBinder.bindTag(this, this.rootView);
    }

    protected void initView() {
    }

    protected void initListener() {
        ViewBinder.bindCustomView(this, this.rootView);
        ViewBinder.bindCustomView(this, this.rootView);
    }

    protected abstract void onItemChildViewClick(View var1, int var2, Object var3);

    protected void onItemChildViewClick(View childView, int action) {
        this.onItemChildViewClick(childView, action, null);
    }
}

