package com.supcon.common.view.base.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewStub;
import android.widget.LinearLayout;

import com.app.annotation.Presenter;
import com.supcon.common.com_router.router.PresenterRouter;
import com.supcon.common.com_router.widget.IWidget;
import com.supcon.common.view.base.presenter.BasePresenter;
import com.supcon.common.view.contract.IBaseView;
import com.supcon.common.view.listener.OnChildViewClickListener;
import com.supcon.common.view.util.InstanceUtil;
import com.supcon.common.view.util.LogUtil;
import com.supcon.common.view.util.ViewBinder;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;

/**
 * Created by wangshizhan on 16/12/1.
 */
public abstract class BaseWidgetLayout extends LinearLayout implements IWidget {
    protected OnChildViewClickListener onChildViewClickListener;
    protected View rootView;
    protected ViewStub tempView;
    protected Context context;
    protected Disposable timer;
    private long interval;

    protected PresenterRouter presenterRouter;
    private List<BasePresenter> mPresenters = new ArrayList<>();
    public void initPresenter(){

        presenterRouter = new PresenterRouter();
        Annotation[] annotations = getClass().getAnnotations();
        for (Annotation annotation:annotations){

            if(annotation instanceof Presenter){
                Class[] presenters = ((Presenter) annotation).value();

                for(Class presenter : presenters){

                    if(this instanceof IBaseView){
                        BasePresenter basePresenter = (BasePresenter) InstanceUtil.getInstance(presenter);
                        presenterRouter.register(basePresenter);
                        addPresenter(basePresenter);
                        LogUtil.d("Widget presenter " + presenter.getName() + " added!");
                    }

                }

            }
        }

    }

    private void addPresenter(BasePresenter basePresenter) {
        basePresenter.attachView(this);
        mPresenters.add(basePresenter);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        for(BasePresenter presenter: mPresenters){

            if(presenter!=null){
                presenter.detachView();
            }

        }
    }


    public void setOnChildViewClickListener(OnChildViewClickListener onChildViewClickListener) {
        this.onChildViewClickListener = onChildViewClickListener;
    }

    protected void onChildViewClick(View childView, int action, Object obj) {
        if (onChildViewClickListener != null)
            onChildViewClickListener.onChildViewClick(childView, action, obj);
    }

    protected void onChildViewClick(View childView, int action) {
        onChildViewClick(childView, action, null);
    }


    public BaseWidgetLayout(Context context) {
        super(context);
        initPresenter();
    }

    public BaseWidgetLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        initPresenter();
    }



    protected abstract int layoutId();

    @Override
    public void bind(ViewStub view) {
        bindViewStup(view);
    }

    @Override
    public void doRefresh(long intervel) {
        this.interval = intervel;
        if(intervel == 0){
            refresh();
        }
        else {
            startTimer();
        }
    }

    protected void bindViewStup(ViewStub viewStub){
        tempView = viewStub;
        tempView.setLayoutResource(layoutId());
        init(context, null);
    }

    protected void init(Context context, AttributeSet attrs) {
        this.context = context;
        if (layoutId() != 0) {

            if(tempView!=null){
                rootView = tempView.inflate();
            }
            else {
                rootView = LayoutInflater.from(context).inflate(layoutId(), this, true);
            }
            if (rootView != null) {

            }
            if (attrs != null)
                initAttributeSet(attrs);
        }
        else{
            throw new IllegalArgumentException("layoutId cannot return 0!");
        }
        bindView();
        initView();
        initListener();
        initData();
    }


    protected void initAttributeSet(AttributeSet attrs) {

    }

    private void bindView() {
        ViewBinder.bindTag(this, rootView);
    }


    protected void initView() {

    }

    protected void initListener() {

    }

    protected void initData() {

    }

    protected void refresh(){

    }


    protected void startTimer(){
        timer = Flowable.timer(interval, TimeUnit.SECONDS)
                .subscribe(aLong ->{
                    refresh();
                    startTimer();
                });
    }


    public void stopRefresh() {
        if(timer!=null){
            timer.dispose();
            timer = null;
        }

    }
}
