/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.view.loader.cycler;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;

public class CircularAnimatedDrawable
extends Drawable
implements Animatable {
    private ValueAnimator mValueAnimatorAngle;
    private ValueAnimator mValueAnimatorSweep;
    private AnimatorSet mAnimatorSet;
    private static final Interpolator ANGLE_INTERPOLATOR = new LinearInterpolator();
    private static final Interpolator SWEEP_INTERPOLATOR = new AccelerateDecelerateInterpolator();
    private static final int ANGLE_ANIMATOR_DURATION = 2000;
    private static final int SWEEP_ANIMATOR_DURATION = 700;
    private static final Float MIN_SWEEP_ANGLE = Float.valueOf(50.0f);
    private final RectF fBounds = new RectF();
    private Paint mPaint;
    private View mAnimatedView;
    private float mBorderWidth;
    private float mCurrentGlobalAngle;
    private float mCurrentSweepAngle;
    private float mCurrentGlobalAngleOffset;
    private boolean mModeAppearing;
    private boolean mRunning;
    private boolean shouldDraw;

    public CircularAnimatedDrawable(View view, float borderWidth, int arcColor) {
        this.mAnimatedView = view;
        this.mBorderWidth = borderWidth;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(borderWidth);
        this.mPaint.setColor(arcColor);
        this.setupAnimations();
        this.shouldDraw = true;
        this.mAnimatorSet = new AnimatorSet();
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.fBounds.left = (float)bounds.left + this.mBorderWidth / 2.0f + 0.5f;
        this.fBounds.right = (float)bounds.right - this.mBorderWidth / 2.0f - 0.5f;
        this.fBounds.top = (float)bounds.top + this.mBorderWidth / 2.0f + 0.5f;
        this.fBounds.bottom = (float)bounds.bottom - this.mBorderWidth / 2.0f - 0.5f;
    }

    public void setLoadingBarColor(int color2) {
        this.mPaint.setColor(color2);
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.mRunning = true;
        this.mAnimatorSet.playTogether(new Animator[]{this.mValueAnimatorAngle, this.mValueAnimatorSweep});
        this.mAnimatorSet.start();
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.mRunning = false;
        this.mAnimatorSet.cancel();
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void draw(Canvas canvas) {
        float startAngle = this.mCurrentGlobalAngle - this.mCurrentGlobalAngleOffset;
        float sweepAngle = this.mCurrentSweepAngle;
        if (!this.mModeAppearing) {
            startAngle += sweepAngle;
            sweepAngle = 360.0f - sweepAngle - MIN_SWEEP_ANGLE.floatValue();
        } else {
            sweepAngle += MIN_SWEEP_ANGLE.floatValue();
        }
        canvas.drawArc(this.fBounds, startAngle, sweepAngle, false, this.mPaint);
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -2;
    }

    private void setupAnimations() {
        this.mValueAnimatorAngle = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f});
        this.mValueAnimatorAngle.setInterpolator((TimeInterpolator)ANGLE_INTERPOLATOR);
        this.mValueAnimatorAngle.setDuration(2000L);
        this.mValueAnimatorAngle.setRepeatCount(-1);
        this.mValueAnimatorAngle.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CircularAnimatedDrawable.this.mCurrentGlobalAngle = ((Float)animation.getAnimatedValue()).floatValue();
            }
        });
        this.mValueAnimatorSweep = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f - 2.0f * MIN_SWEEP_ANGLE.floatValue()});
        this.mValueAnimatorSweep.setInterpolator((TimeInterpolator)SWEEP_INTERPOLATOR);
        this.mValueAnimatorSweep.setDuration(700L);
        this.mValueAnimatorSweep.setRepeatCount(-1);
        this.mValueAnimatorSweep.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationRepeat(Animator animation) {
                CircularAnimatedDrawable.this.toggleAppearingMode();
                CircularAnimatedDrawable.this.shouldDraw = false;
            }
        });
        this.mValueAnimatorSweep.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CircularAnimatedDrawable.this.mCurrentSweepAngle = ((Float)animation.getAnimatedValue()).floatValue();
                if (CircularAnimatedDrawable.this.mCurrentSweepAngle < 5.0f) {
                    CircularAnimatedDrawable.this.shouldDraw = true;
                }
                if (CircularAnimatedDrawable.this.shouldDraw) {
                    CircularAnimatedDrawable.this.mAnimatedView.invalidate();
                }
            }
        });
    }

    private void toggleAppearingMode() {
        boolean bl = this.mModeAppearing = !this.mModeAppearing;
        if (this.mModeAppearing) {
            this.mCurrentGlobalAngleOffset = (this.mCurrentGlobalAngleOffset + MIN_SWEEP_ANGLE.floatValue() * 2.0f) % 360.0f;
        }
    }

    public void dispose() {
        if (this.mValueAnimatorAngle != null) {
            this.mValueAnimatorAngle.end();
            this.mValueAnimatorAngle.removeAllUpdateListeners();
            this.mValueAnimatorAngle.cancel();
        }
        this.mValueAnimatorAngle = null;
        if (this.mValueAnimatorSweep != null) {
            this.mValueAnimatorSweep.end();
            this.mValueAnimatorSweep.removeAllUpdateListeners();
            this.mValueAnimatorSweep.cancel();
        }
        this.mValueAnimatorSweep = null;
        if (this.mAnimatorSet != null) {
            this.mAnimatorSet.end();
            this.mAnimatorSet.cancel();
        }
    }
}

