/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.util;

import android.content.Context;
import android.os.Handler;
import android.view.View;
import android.widget.Toast;

public class ToastUtils {
    private Context mContext = null;
    private Toast mToast = null;
    private Handler mHandler = null;
    private int duration = 0;
    private int currDuration = 0;
    private final int DEFAULT = 2000;
    private Runnable mToastThread = new Runnable(){

        @Override
        public void run() {
            ToastUtils.this.mToast.show();
            ToastUtils.this.mHandler.postDelayed(ToastUtils.this.mToastThread, 2000L);
            if (ToastUtils.this.duration != 0) {
                if (ToastUtils.this.currDuration <= ToastUtils.this.duration) {
                    ToastUtils.this.currDuration = ToastUtils.this.currDuration + 2000;
                } else {
                    ToastUtils.this.cancel();
                }
            }
        }
    };

    public ToastUtils(Context context) {
        this.mContext = context;
        this.currDuration = 2000;
        if (this.mContext != null) {
            this.mHandler = new Handler(this.mContext.getMainLooper());
            this.mToast = Toast.makeText((Context)this.mContext, (CharSequence)"", (int)1);
        }
    }

    public static void show(Context context, String text, int duration) {
        ToastUtils toastUtils = new ToastUtils(context);
        toastUtils.setText(text);
        toastUtils.show(duration);
    }

    public static void show(Context context, String text) {
        ToastUtils toastUtils = new ToastUtils(context);
        toastUtils.setText(text);
        toastUtils.show(2000);
    }

    public static void show(Context context, int resId) {
        ToastUtils toastUtils = new ToastUtils(context);
        toastUtils.setText(context.getString(resId));
        toastUtils.show(2000);
    }

    public void setText(String text) {
        if (this.mToast != null) {
            this.mToast.setText((CharSequence)text);
        }
    }

    public void show(int duration) {
        this.duration = duration;
        if (this.mToast != null) {
            this.mHandler.post(this.mToastThread);
        }
    }

    public void setGravity(int gravity, int xOffset, int yOffset) {
        this.mToast.setGravity(gravity, xOffset, yOffset);
    }

    public void setDuration(int duration) {
        this.mToast.setDuration(duration);
    }

    public void setView(View view) {
        this.mToast.setView(view);
    }

    public void cancel() {
        this.mHandler.removeCallbacks(this.mToastThread);
        this.mToast.cancel();
        this.currDuration = 2000;
    }
}

