/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.util;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;

public class StatusBarUtils {
    public static void setWindowStatusBarColor(Activity activity, int colorResId) {
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                Window window = activity.getWindow();
                window.addFlags(Integer.MIN_VALUE);
                window.setStatusBarColor(activity.getResources().getColor(colorResId));
            } else if (Build.VERSION.SDK_INT >= 19) {
                Window window = activity.getWindow();
                window.addFlags(0x4000000);
                ViewGroup decorViewGroup = (ViewGroup)window.getDecorView();
                View statusBarView = new View(window.getContext());
                int statusBarHeight = StatusBarUtils.getStatusBarHeight(window.getContext());
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, statusBarHeight);
                params.gravity = 48;
                statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
                statusBarView.setBackgroundColor(activity.getResources().getColor(colorResId));
                decorViewGroup.addView(statusBarView);
                ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
                View mChildView = mContentView.getChildAt(0);
                if (mChildView != null) {
                    mChildView.setFitsSystemWindows(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setWindowStatusBarColor(Dialog dialog, int colorResId) {
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                Window window = dialog.getWindow();
                window.addFlags(Integer.MIN_VALUE);
                window.setStatusBarColor(dialog.getContext().getResources().getColor(colorResId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int getStatusBarHeight(Context context) {
        int statusBarHeight = 0;
        Resources res = context.getResources();
        int resourceId = res.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = res.getDimensionPixelSize(resourceId);
        }
        return statusBarHeight;
    }

    public static void hideStatusBar(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            View decorView = activity.getWindow().getDecorView();
            int option = 1280;
            decorView.setSystemUiVisibility(option);
            activity.getWindow().setStatusBarColor(0);
        }
    }
}

