/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;

public class SharedPreferencesUtils {
    private static final String DEFAULT_FILE_NAME = "common";
    private static final String CACHE_FILE_NAME = "common-cache";
    private static final int MODE7 = 0;
    private static final int MODE = 7;

    public static void setParam(Context context, String key, Object object) {
        SharedPreferencesUtils.setValue(context, DEFAULT_FILE_NAME, key, object, true);
    }

    public static void setParamByCommit(Context context, String key, Object object) {
        SharedPreferencesUtils.setValue(context, DEFAULT_FILE_NAME, key, object, false);
    }

    private static void setValue(Context context, String fileName, String key, Object object, boolean async) {
        if (context == null || TextUtils.isEmpty((CharSequence)key) || object == null) {
            return;
        }
        String type = object.getClass().getSimpleName();
        SharedPreferences sp = SharedPreferencesUtils.getSharedPreferences(context, fileName);
        SharedPreferences.Editor editor = sp.edit();
        if ("String".equals(type)) {
            editor.putString(key, (String)object);
        } else if ("Integer".equals(type)) {
            editor.putInt(key, ((Integer)object).intValue());
        } else if ("Boolean".equals(type)) {
            editor.putBoolean(key, ((Boolean)object).booleanValue());
        } else if ("Float".equals(type)) {
            editor.putFloat(key, ((Float)object).floatValue());
        } else if ("Long".equals(type)) {
            editor.putLong(key, ((Long)object).longValue());
        } else if ("Double".equals(type)) {
            editor.putFloat(key, ((Double)object).floatValue());
        }
        if (async) {
            editor.apply();
        } else {
            editor.commit();
        }
    }

    public static void setCacheParam(Context context, String key, Object object) {
        SharedPreferencesUtils.setValue(context, CACHE_FILE_NAME, key, object, true);
    }

    private static Object getValue(Context context, String fileName, String key, Object defaultObject) {
        if (context == null || TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        String type = defaultObject.getClass().getSimpleName();
        SharedPreferences sp = SharedPreferencesUtils.getSharedPreferences(context, fileName);
        if ("String".equals(type)) {
            return sp.getString(key, (String)defaultObject);
        }
        if ("Integer".equals(type)) {
            return sp.getInt(key, ((Integer)defaultObject).intValue());
        }
        if ("Boolean".equals(type)) {
            return sp.getBoolean(key, ((Boolean)defaultObject).booleanValue());
        }
        if ("Float".equals(type)) {
            return Float.valueOf(sp.getFloat(key, ((Float)defaultObject).floatValue()));
        }
        if ("Long".equals(type)) {
            return sp.getLong(key, ((Long)defaultObject).longValue());
        }
        if ("Double".equals(type)) {
            return (double)sp.getFloat(key, ((Double)defaultObject).floatValue());
        }
        return null;
    }

    private static SharedPreferences getSharedPreferences(Context context, String fileName) {
        SharedPreferences sp = null;
        sp = Build.VERSION.SDK_INT >= 24 ? context.getSharedPreferences(fileName, 0) : context.getSharedPreferences(fileName, 7);
        return sp;
    }

    public static <T> T getParam(Context context, String key, T defaultObject) {
        return (T)SharedPreferencesUtils.getValue(context, DEFAULT_FILE_NAME, key, defaultObject);
    }

    public static <T> T getCacheParam(Context context, String key, Object defaultObject) {
        return (T)SharedPreferencesUtils.getValue(context, CACHE_FILE_NAME, key, defaultObject);
    }

    public static boolean toggleBooleanValue(Context context, String key, Boolean defaultValue) {
        boolean original = SharedPreferencesUtils.getParam(context, key, defaultValue);
        boolean newconfig = !original;
        SharedPreferencesUtils.setParam(context, key, newconfig);
        return newconfig;
    }
}

