/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.util;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

public class KeyboardUtil {
    public static void closeKeyboard(Activity activity) {
        View view = activity.getWindow().peekDecorView();
        if (view != null) {
            InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public static void closeKeyboard(Dialog dialog) {
        View view = dialog.getWindow().peekDecorView();
        if (view != null) {
            InputMethodManager inputMethodManager = (InputMethodManager)dialog.getContext().getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public static void toggleKeyboard(Context context, View editText) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.toggleSoftInputFromWindow(editText.getWindowToken(), 0, 0);
    }

    public static void openKeyboard(Context context, View editText) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.showSoftInputFromInputMethod(editText.getWindowToken(), 1);
    }

    public static void hideKeyboard(Context context, View editText) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.hideSoftInputFromWindow(editText.getWindowToken(), 0);
    }

    public static void restartInput(Context context, View editText) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.restartInput(editText);
    }

    public static boolean showSearchInputMethod(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (imm != null) {
            return imm.showSoftInput(view, 0);
        }
        return false;
    }

    public static boolean hideSearchInputMethod(View view, HideKeyboardCallback hideKeyboardCallback) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (imm != null) {
            if (hideKeyboardCallback != null) {
                hideKeyboardCallback.executingHideKeyboard();
            }
            return imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        return false;
    }

    public static void editTextRequestFocus(View view) {
        view.requestFocus();
        KeyboardUtil.showSearchInputMethod(view);
    }

    public static void editTextClearFocus(View view) {
        view.clearFocus();
        KeyboardUtil.hideSearchInputMethod(view);
    }

    public static boolean hideSearchInputMethod(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (imm != null) {
            return imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        return false;
    }

    public static interface HideKeyboardCallback {
        public void executingHideKeyboard();
    }
}

