/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.fragment;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;
import com.app.annotation.Controller;
import com.supcon.common.view.Lifecycle;
import com.supcon.common.view.LifecycleManage;
import com.supcon.common.view.base.controller.BaseController;
import com.supcon.common.view.base.fragment.BasePresenterFragment;
import com.supcon.common.view.util.LogUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BaseControllerFragment
extends BasePresenterFragment {
    protected LifecycleManage controllers = new LifecycleManage();
    protected List<BaseController> dataControllers = new ArrayList<BaseController>();

    protected void initControllers() {
        Annotation[] annotations;
        for (Annotation annotation : annotations = this.getClass().getAnnotations()) {
            Class[] controllerClasses;
            if (!(annotation instanceof Controller)) continue;
            for (Class controller : controllerClasses = ((Controller)annotation).value()) {
                try {
                    Constructor constructor = null;
                    BaseController baseController = null;
                    if (controller.getSuperclass().getSimpleName().equals("BasePresenterController")) {
                        constructor = controller.getConstructor(new Class[0]);
                        baseController = (BaseController)constructor.newInstance(new Object[0]);
                    } else if (controller.getSuperclass().getSimpleName().equals("BaseDataController")) {
                        constructor = controller.getConstructor(Context.class);
                        baseController = (BaseController)constructor.newInstance(this.context);
                    } else if (controller.getSuperclass().getSimpleName().equals("BaseViewController")) {
                        constructor = controller.getConstructor(View.class);
                        baseController = (BaseController)constructor.newInstance(this.rootView);
                    } else {
                        constructor = controller.getConstructor(View.class);
                        baseController = (BaseController)constructor.newInstance(this.rootView);
                    }
                    if (baseController == null) continue;
                    LogUtil.d("controller " + controller.getName() + " added!");
                    this.registerController(controller.getSimpleName(), baseController);
                    this.addDataController(baseController);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void addDataController(BaseController baseController) {
        this.dataControllers.add(baseController);
    }

    protected void registerController(String key, Lifecycle controller) {
        if (!TextUtils.isEmpty((CharSequence)key) && controller != null) {
            this.controllers.register(key, controller);
        }
    }

    protected void registerController(Lifecycle controller) {
        if (controller != null) {
            this.registerController(controller.getClass().getSimpleName(), controller);
        }
    }

    public Lifecycle getController(String key) {
        return this.controllers.get(key);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.initControllers();
        this.onRegisterController();
        this.controllers.onInit();
    }

    public <T extends Lifecycle> T getController(Class<T> clazz) {
        return (T)this.controllers.get(clazz.getSimpleName());
    }

    protected void onRegisterController() {
    }

    @Override
    protected void initView() {
        super.initView();
        this.controllers.initView();
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.controllers.initListener();
    }

    @Override
    protected void initData() {
        super.initData();
        this.controllers.initData();
    }

    public void onPause() {
        super.onPause();
        this.controllers.onPause();
    }

    @Override
    public void onStart() {
        super.onStart();
        this.controllers.onStart();
    }

    public void onStop() {
        super.onStop();
        this.controllers.onStop();
    }

    public void onResume() {
        super.onResume();
        this.controllers.onResume();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.controllers.onDestroy();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.controllers.onActivityResult(requestCode, resultCode, data);
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void onRetry() {
        this.controllers.onRetry();
    }

    @Override
    public void refresh() {
        super.refresh();
        for (BaseController baseController : this.dataControllers) {
            baseController.refresh();
        }
    }

    @Override
    public boolean checkBeforeSubmit(Map<String, Object> map) {
        for (BaseController baseController : this.dataControllers) {
            if (baseController.checkBeforeSubmit(map)) continue;
            return false;
        }
        return super.checkBeforeSubmit(map);
    }

    @Override
    public boolean doSave(Map<String, Object> map) {
        for (BaseController baseController : this.dataControllers) {
            if (baseController.doSave(map)) continue;
            return false;
        }
        return super.doSave(map);
    }

    @Override
    public boolean isModified() {
        for (BaseController baseController : this.dataControllers) {
            boolean isModified = baseController.isModified();
            if (!isModified) continue;
            return true;
        }
        return super.isModified();
    }
}

