/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.adapter.viewholder;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.supcon.common.view.listener.OnItemChildViewClickListener;
import com.supcon.common.view.util.ViewBinder;
import java.lang.reflect.Field;

public abstract class BaseRecyclerViewHolder<T>
extends RecyclerView.ViewHolder {
    protected OnItemChildViewClickListener onItemChildViewClickListener;

    public BaseRecyclerViewHolder(Context context) {
        this(context, null);
    }

    public BaseRecyclerViewHolder(Context context, ViewGroup parent) {
        super(new View(context));
        View view = LayoutInflater.from((Context)context).inflate(this.layoutId(), parent, false);
        try {
            Field field = ((Object)((Object)this)).getClass().getField("itemView");
            field.setAccessible(true);
            field.set((Object)this, view);
            field.setAccessible(false);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.init();
    }

    public BaseRecyclerViewHolder(View itemView) {
        super(itemView);
        this.init();
    }

    private void init() {
        if (this.itemView != null) {
            this.initBind();
            this.initView();
            this.initListener();
        }
    }

    public void setOnItemChildViewClickListener(OnItemChildViewClickListener onItemChildViewClickListener) {
        this.onItemChildViewClickListener = onItemChildViewClickListener;
    }

    public void notifyChanged(T data) {
        this.update(data);
    }

    protected abstract int layoutId();

    protected abstract void update(T var1);

    protected void initBind() {
        ViewBinder.bindTag((Object)this, this.itemView);
    }

    protected void initView() {
    }

    protected void initListener() {
        ViewBinder.bindCustomView((Object)this, this.itemView);
        ViewBinder.bindListener((Object)this, this.itemView);
    }

    protected void onItemChildViewClick(View childView, int action, Object obj) {
        if (this.onItemChildViewClickListener != null) {
            this.onItemChildViewClickListener.onItemChildViewClick(childView, this.getAdapterPosition(), action, obj);
        }
    }

    protected void onItemChildViewClick(View childView, int action) {
        this.onItemChildViewClick(childView, action, null);
    }
}

