/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.activity;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.os.Message;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.supcon.common.view.App;
import com.supcon.common.view.R;
import com.supcon.common.view.base.activity.BaseActivity;
import com.supcon.common.view.util.LogUtil;
import com.supcon.common.view.util.StatusBarUtils;
import com.supcon.common.view.util.ToastUtils;
import com.supcon.common.view.util.UrlUtil;
import com.supcon.common.view.view.js.BridgeHandler;
import com.supcon.common.view.view.js.BridgeWebView;
import com.supcon.common.view.view.js.CallBackFunction;
import com.supcon.common.view.view.js.DefaultHandler;
import io.reactivex.Flowable;
import io.reactivex.functions.Consumer;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseWebViewActivity
extends BaseActivity {
    public static final int QUERY_TYPE_QUERY = 0;
    public static final int QUERY_TYPE_PENDING = 1;
    protected BridgeWebView webView;
    protected ProgressBar pbProgress;
    protected TextView titleText;
    protected ImageButton leftBtn;
    protected ImageButton rightBtn;
    private String url;
    private String cookie;
    private String authorization;
    private boolean isDialog = false;
    private boolean hasRefresh = false;
    protected boolean isList = false;
    protected int queryType = 1;
    protected long pendingId;
    private boolean isPendingRefresh = false;
    protected boolean needTitle = false;
    private static final int RESULT_CODE = 0;
    private ValueCallback<Uri> uploadMessage;
    private ValueCallback<Uri[]> uploadMessageAboveL;
    private CallBackFunction mFileCallBackFunction;
    private static final int FILE_CHOOSER_RESULT_CODE = 128;
    private static final int FILE_CAMERA_RESULT_CODE = 129;
    private String cameraFielPath;

    @Override
    protected void onInit() {
        super.onInit();
        this.url = this.getIntent().getStringExtra("WEB_URL");
        this.cookie = this.getIntent().getStringExtra("WEB_COOKIE");
        this.authorization = this.getIntent().getStringExtra("WEB_AUTHORIZATION");
        this.hasRefresh = this.getIntent().getBooleanExtra("WEB_HAS_REFRESH", false);
        this.isList = this.getIntent().getBooleanExtra("WEB_IS_LIST", false);
        if (TextUtils.isEmpty((CharSequence)this.url)) {
            throw new IllegalArgumentException("\u4f20\u53c2\u9519\u8bef\uff01");
        }
        LogUtil.i("Url:" + this.url + "\nCookie:" + this.cookie + "\nAuthorization\uff1a" + this.authorization);
        this.pendingId = UrlUtil.parseIdFormUrl(this.url, "pendingId");
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    protected void initView() {
        super.initView();
        this.webView = (BridgeWebView)this.rootView.findViewWithTag((Object)"webview");
        this.pbProgress = (ProgressBar)this.rootView.findViewWithTag((Object)"pb_progress");
        this.titleText = (TextView)this.rootView.findViewWithTag((Object)"titleText");
        this.leftBtn = (ImageButton)this.rootView.findViewWithTag((Object)"leftBtn");
        this.rightBtn = (ImageButton)this.rootView.findViewWithTag((Object)"rightBtn");
        if (this.rightBtn != null && this.hasRefresh) {
            this.rightBtn.setImageResource(R.drawable.sl_top_refresh);
            this.rightBtn.setVisibility(0);
        }
        StatusBarUtils.setWindowStatusBarColor((Activity)this, R.color.webThemeColor);
        if (this.leftBtn != null) {
            ((ViewGroup)this.leftBtn.getParent()).setBackgroundResource(R.color.webThemeColor);
        }
        this.toggleTitle(false);
        this.needTitle = false;
        this.initWebView();
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.webView.registerHandler("close", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("close" + data);
                BaseWebViewActivity.this.back();
            }
        });
        this.webView.registerHandler("webGoBack", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("webGoBack" + data);
                if (BaseWebViewActivity.this.webView.canGoBack()) {
                    BaseWebViewActivity.this.webView.goBack();
                } else {
                    BaseWebViewActivity.this.back();
                }
            }
        });
        this.webView.registerHandler("showSubmit", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("showSubmit" + data);
            }
        });
        this.webView.registerHandler("setTitle", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("setTitle" + data);
                if (!TextUtils.isEmpty((CharSequence)data)) {
                    try {
                        JSONObject jsonObject = new JSONObject(data);
                        BaseWebViewActivity.this.setTitle(jsonObject.getString("param"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.webView.registerHandler("onloadStart", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("onloadStart" + data);
            }
        });
        this.webView.registerHandler("onloadEnd", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("onloadEnd" + data);
            }
        });
        this.webView.registerHandler("pendingRefresh", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("pendingRefresh" + data);
            }
        });
        this.webView.registerHandler("supmobileReload", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("supmobileReload" + data);
                ToastUtils.show(BaseWebViewActivity.this.context, "\u767b\u9646\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\uff01");
            }
        });
        this.webView.registerHandler("openDialog", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("openDialog" + data);
                BaseWebViewActivity.this.setIsDialog(true);
            }
        });
        this.webView.registerHandler("closeDialog", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("closeDialog" + data);
                BaseWebViewActivity.this.setIsDialog(false);
            }
        });
        this.webView.registerHandler("showTitle", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("showTitle" + data);
                BaseWebViewActivity.this.toggleTitle(true);
            }
        });
        this.webView.registerHandler("hideTitle", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("hideTitle" + data);
                BaseWebViewActivity.this.toggleTitle(false);
            }
        });
        this.webView.registerHandler("supconUpload", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("supconUpload" + data);
                BaseWebViewActivity.this.pickFile();
                BaseWebViewActivity.this.mFileCallBackFunction = function;
            }
        });
        this.webView.registerHandler("mobileReload", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("mobileReload" + data);
                BaseWebViewActivity.this.onReload();
            }
        });
        if (this.leftBtn != null) {
            this.leftBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BaseWebViewActivity.this.onBackPressed();
                }
            });
        }
        if (this.rightBtn != null) {
            this.rightBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BaseWebViewActivity.this.onReload();
                }
            });
        }
    }

    public void onPageStart(WebView view, String url, Bitmap favicon) {
    }

    public void onPageCommitVisible(WebView view, String url) {
    }

    public void onPageFinished(WebView view, String url) {
    }

    protected void onReload() {
        this.webView.reload();
    }

    public void setPendingRefresh(boolean pendingRefresh) {
        this.isPendingRefresh = pendingRefresh;
    }

    @Override
    protected void initData() {
        super.initData();
        this.loadUrl();
    }

    private void loadUrl() {
        HashMap<String, String> header = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)this.cookie)) {
            header.put("Cookie", this.cookie);
        }
        if (!TextUtils.isEmpty((CharSequence)this.authorization)) {
            header.put("Authorization", this.authorization);
        }
        this.webView.loadUrl(this.url, header);
    }

    private void initWebView() {
        if (this.webView == null) {
            throw new IllegalArgumentException("BridgeWebView is null!");
        }
        this.webView.setDefaultHandler(new DefaultHandler());
        WebSettings settings = this.webView.getSettings();
        settings.setAllowFileAccess(true);
        settings.setDatabaseEnabled(true);
        String dir = this.getApplicationContext().getDir("database", 0).getPath();
        settings.setDatabasePath(dir);
        settings.setDomStorageEnabled(true);
        settings.setGeolocationEnabled(true);
        this.setWebChromeClient(new DefaultWebChromeClient());
    }

    protected void setWebChromeClient(WebChromeClient webChromeClient) {
        this.webView.setWebChromeClient(webChromeClient);
    }

    protected void callJSFunction(final String jsFunctionName, String data) {
        this.webView.callHandler(jsFunctionName, data, new CallBackFunction(){

            @Override
            public void onCallBack(String data) {
                LogUtil.i("function:" + jsFunctionName + " onCallBack data = " + data);
            }
        });
    }

    protected void registerHandler(String name, BridgeHandler handler) {
        this.webView.registerHandler(name, handler);
    }

    protected void sendMessageToJs(String message) {
        this.webView.send(message, new CallBackFunction(){

            @Override
            public void onCallBack(String data) {
                LogUtil.i("sendMessageToJs onCallBack data = " + data);
            }
        });
    }

    @Override
    public void refresh() {
        super.refresh();
    }

    public void setQueryType(int queryType) {
        this.queryType = queryType;
    }

    @Override
    public void onBackPressed() {
        if (this.isDialog) {
            return;
        }
        if (this.webView.canGoBack()) {
            this.webView.goBack();
        } else {
            super.onBackPressed();
        }
    }

    public void setTitle(String title) {
        if (this.titleText != null) {
            this.titleText.setText((CharSequence)title);
        }
    }

    public void setIsDialog(boolean isDialog) {
        this.isDialog = isDialog;
        if (this.titleText == null || !this.needTitle) {
            return;
        }
        if (isDialog) {
            ((ViewGroup)this.titleText.getParent()).setVisibility(8);
        } else {
            ((ViewGroup)this.titleText.getParent()).setVisibility(0);
        }
    }

    public void toggleTitle(boolean open) {
        if (this.titleText == null && !this.needTitle) {
            return;
        }
        if (!open) {
            ((ViewGroup)this.titleText.getParent()).setVisibility(8);
        } else {
            ((ViewGroup)this.titleText.getParent()).setVisibility(0);
        }
    }

    @SuppressLint(value={"CheckResult"})
    public void loginValid() {
        if (this.isList) {
            this.loadUrl();
        } else {
            ToastUtils.show(this.context, "\u9875\u9762\u5df2\u5931\u6548");
            Flowable.timer((long)500L, (TimeUnit)TimeUnit.MILLISECONDS).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    BaseWebViewActivity.this.back();
                }
            });
        }
    }

    @SuppressLint(value={"CheckResult"})
    public void unauthorized() {
        ToastUtils.show(this.context, "\u9875\u9762\u5df2\u5931\u6548");
        Flowable.timer((long)500L, (TimeUnit)TimeUnit.MILLISECONDS).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) throws Exception {
                BaseWebViewActivity.this.back();
            }
        });
    }

    public void serverError() {
        LogUtil.e("\u670d\u52a1\u5668\u9519\u8bef");
    }

    public void sendRefreshEvent() {
        LogUtil.d("sendRefreshEvent");
        this.onReload();
    }

    public void next(String url) {
        if (this.url != null && this.url.equals(url)) {
            this.onReload();
        } else {
            this.goNext(url);
        }
    }

    public boolean checkUrl(String inUrl) {
        long newPendingId = UrlUtil.parseIdFormUrl(inUrl, "pendingId");
        long deploymentId = UrlUtil.parseIdFormUrl(inUrl, "deploymentId");
        return this.pendingId != 0L && newPendingId != 0L && this.pendingId == newPendingId || deploymentId != 0L && newPendingId == 0L && this.isPendingRefresh;
    }

    public boolean isSave(String inUrl) {
        long newPendingId = UrlUtil.parseIdFormUrl(inUrl, "pendingId");
        long deploymentId = UrlUtil.parseIdFormUrl(inUrl, "deploymentId");
        return this.pendingId != 0L && newPendingId != 0L && this.pendingId == newPendingId || deploymentId == 0L && newPendingId != 0L;
    }

    protected void goNext(String url) {
    }

    public void pickPicture() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("image/*");
        this.startActivityForResult(intent, 0);
    }

    public void pickFile() {
        Intent chooserIntent = new Intent("android.intent.action.GET_CONTENT");
        chooserIntent.setType("*/*");
        this.startActivityForResult(chooserIntent, 0);
    }

    private void openImageChooserActivity() {
        new MaterialDialog.Builder((Context)this).items(R.array.photo).positiveText((CharSequence)"\u53d6\u6d88").onPositive(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                if (BaseWebViewActivity.this.uploadMessageAboveL != null) {
                    BaseWebViewActivity.this.uploadMessageAboveL.onReceiveValue(null);
                    BaseWebViewActivity.this.uploadMessageAboveL = null;
                }
                if (BaseWebViewActivity.this.uploadMessage != null) {
                    BaseWebViewActivity.this.uploadMessage.onReceiveValue(null);
                    BaseWebViewActivity.this.uploadMessage = null;
                }
                dialog.dismiss();
            }
        }).cancelable(false).canceledOnTouchOutside(false).itemsCallback(new MaterialDialog.ListCallback(){

            public void onSelection(MaterialDialog dialog, View itemView, int position, CharSequence text) {
                if (position == 0) {
                    BaseWebViewActivity.this.takeCamera();
                } else if (position == 1) {
                    BaseWebViewActivity.this.takePhoto();
                }
            }
        }).show();
    }

    private void takePhoto() {
        Intent i = new Intent("android.intent.action.GET_CONTENT");
        i.addCategory("android.intent.category.OPENABLE");
        i.setType("image/*");
        this.startActivityForResult(Intent.createChooser((Intent)i, (CharSequence)"Image Chooser"), 128);
    }

    private void takeCamera() {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        File file = new File(Environment.getExternalStorageDirectory() + "/supcon/");
        if (!file.exists()) {
            file.mkdirs();
        }
        this.cameraFielPath = Environment.getExternalStorageDirectory() + "/supcon/upload.jpg";
        File outputImage = new File(this.cameraFielPath);
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)outputImage));
        this.startActivityForResult(intent, 129);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (null == this.uploadMessage && null == this.uploadMessageAboveL) {
            return;
        }
        if (resultCode != -1) {
            if (this.uploadMessageAboveL != null) {
                this.uploadMessageAboveL.onReceiveValue(null);
                this.uploadMessageAboveL = null;
            }
            if (this.uploadMessage != null) {
                this.uploadMessage.onReceiveValue(null);
                this.uploadMessage = null;
            }
            return;
        }
        Uri result = null;
        if (requestCode == 129) {
            if (null != data && null != data.getData()) {
                result = data.getData();
            }
            if (result == null && BaseWebViewActivity.hasFile(this.cameraFielPath)) {
                result = Uri.fromFile((File)new File(this.cameraFielPath));
            }
            if (this.uploadMessageAboveL != null) {
                this.uploadMessageAboveL.onReceiveValue((Object)new Uri[]{result});
                this.uploadMessageAboveL = null;
            } else if (this.uploadMessage != null) {
                this.uploadMessage.onReceiveValue((Object)result);
                this.uploadMessage = null;
            }
        } else if (requestCode == 128) {
            if (data != null) {
                result = data.getData();
            }
            if (this.uploadMessageAboveL != null) {
                this.onActivityResultAboveL(data);
            } else if (this.uploadMessage != null) {
                this.uploadMessage.onReceiveValue((Object)result);
                this.uploadMessage = null;
            }
        }
    }

    public static boolean hasFile(String path) {
        try {
            File f = new File(path);
            if (!f.exists()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @TargetApi(value=21)
    private void onActivityResultAboveL(Intent intent) {
        Uri[] results = null;
        if (intent != null) {
            String dataString = intent.getDataString();
            ClipData clipData = intent.getClipData();
            if (clipData != null) {
                results = new Uri[clipData.getItemCount()];
                for (int i = 0; i < clipData.getItemCount(); ++i) {
                    ClipData.Item item = clipData.getItemAt(i);
                    results[i] = item.getUri();
                }
            }
            if (dataString != null) {
                results = new Uri[]{Uri.parse((String)dataString)};
            }
        }
        this.uploadMessageAboveL.onReceiveValue(results);
        this.uploadMessageAboveL = null;
    }

    protected void uploadFile(File file, CallBackFunction callBackFunction) {
    }

    protected void showDialog(String message, JsResult result) {
    }

    @Override
    public Resources getResources() {
        Resources res = super.getResources();
        Configuration config = res.getConfiguration();
        config.fontScale = (double)App.fontSizeScale > 0.5 ? App.fontSizeScale : 1.0f;
        res.updateConfiguration(config, res.getDisplayMetrics());
        return res;
    }

    public class DefaultWebChromeClient
    extends WebChromeClient {
        public void openFileChooser(ValueCallback<Uri> uploadMsg, String AcceptType, String capture) {
            this.openFileChooser(uploadMsg);
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg, String AcceptType) {
            this.openFileChooser(uploadMsg);
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg) {
            BaseWebViewActivity.this.uploadMessage = uploadMsg;
            BaseWebViewActivity.this.openImageChooserActivity();
        }

        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            BaseWebViewActivity.this.uploadMessageAboveL = filePathCallback;
            BaseWebViewActivity.this.openImageChooserActivity();
            return true;
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            return super.onConsoleMessage(consoleMessage);
        }

        public boolean onJsBeforeUnload(WebView view, String url, String message, JsResult result) {
            LogUtil.d("onJsBeforeUnload");
            return super.onJsBeforeUnload(view, url, message, result);
        }

        public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
            LogUtil.d("onJsPrompt");
            return super.onJsPrompt(view, url, message, defaultValue, result);
        }

        public void onReceivedIcon(WebView view, Bitmap icon) {
            super.onReceivedIcon(view, icon);
        }

        public void onGeolocationPermissionsHidePrompt() {
            LogUtil.d("onGeolocationPermissionsHidePrompt");
            super.onGeolocationPermissionsHidePrompt();
        }

        public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
            LogUtil.d("onGeolocationPermissionsShowPrompt");
            super.onGeolocationPermissionsShowPrompt(origin, callback);
        }

        public void onPermissionRequest(PermissionRequest request) {
            LogUtil.d("onPermissionRequest");
            super.onPermissionRequest(request);
        }

        public void onPermissionRequestCanceled(PermissionRequest request) {
            LogUtil.d("onPermissionRequestCanceled");
            super.onPermissionRequestCanceled(request);
        }

        public void onReceivedTouchIconUrl(WebView view, String url, boolean precomposed) {
            LogUtil.d("onReceivedTouchIconUrl");
            super.onReceivedTouchIconUrl(view, url, precomposed);
        }

        public void onProgressChanged(WebView view, int newProgress) {
            super.onProgressChanged(view, newProgress);
            if (newProgress == 100) {
                if (BaseWebViewActivity.this.pbProgress != null) {
                    BaseWebViewActivity.this.pbProgress.setVisibility(8);
                }
            } else if (BaseWebViewActivity.this.pbProgress != null) {
                BaseWebViewActivity.this.pbProgress.setVisibility(0);
                BaseWebViewActivity.this.pbProgress.setProgress(newProgress);
            }
            super.onProgressChanged(view, newProgress);
        }

        public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
            LogUtil.d("onCreateWindow");
            return super.onCreateWindow(view, isDialog, isUserGesture, resultMsg);
        }

        public void onHideCustomView() {
            super.onHideCustomView();
            LogUtil.d("onHideCustomView");
        }

        public void onCloseWindow(WebView window) {
            super.onCloseWindow(window);
            LogUtil.d("onCloseWindow");
            BaseWebViewActivity.this.back();
        }

        public void onReceivedTitle(WebView view, String title) {
            super.onReceivedTitle(view, title);
            if (!TextUtils.isEmpty((CharSequence)title) && title.length() > 10) {
                return;
            }
            LogUtil.d("onReceivedTitle:" + title);
            BaseWebViewActivity.this.setTitle(title);
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            super.onShowCustomView(view, callback);
            LogUtil.d("onShowCustomView");
        }

        public void onRequestFocus(WebView view) {
            super.onRequestFocus(view);
            LogUtil.d("onRequestFocus");
        }

        public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
            BaseWebViewActivity.this.showDialog(message, result);
            return true;
        }

        public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
            BaseWebViewActivity.this.showDialog(message, result);
            return true;
        }
    }
}

