/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.SurfaceView;
import android.view.View;
import android.webkit.WebView;
import com.supcon.common.view.util.SharedPreferencesUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class App
extends Application {
    public static final String TEXT_SIZE_SETTING = "TEXT_SIZE_SETTING";
    private static App mApp;
    public Stack<Activity> store;
    private Set<Class<? extends View>> mProblemViewClassSet = new HashSet<Class<? extends View>>();
    public static float fontSizeScale;

    public void onCreate() {
        super.onCreate();
        mApp = this;
        this.store = new Stack();
        this.registerActivityLifecycleCallbacks(new SwitchBackgroundCallbacks());
        this.initTvSize();
    }

    public static App getAppContext() {
        return mApp;
    }

    public Activity getCurActivity() {
        return (Activity)this.store.lastElement();
    }

    @Nullable
    public Activity getPenultimateActivity(Activity currentActivity) {
        Activity activity = null;
        try {
            if (this.store.size() > 1 && currentActivity.equals(activity = (Activity)this.store.get(this.store.size() - 2))) {
                int index = this.store.indexOf(currentActivity);
                if (index > 0) {
                    activity = (Activity)this.store.get(index - 1);
                } else if (this.store.size() == 2) {
                    activity = (Activity)this.store.lastElement();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return activity;
    }

    public void setProblemViewClassList(List<Class<? extends View>> problemViewClassList) {
        this.mProblemViewClassSet.add(WebView.class);
        this.mProblemViewClassSet.add(SurfaceView.class);
        if (problemViewClassList != null) {
            this.mProblemViewClassSet.addAll(problemViewClassList);
        }
    }

    public boolean isProblemView(View view) {
        return this.mProblemViewClassSet.contains(view.getClass());
    }

    public boolean isSwipeBackEnable() {
        return this.store.size() > 1;
    }

    private void initTvSize() {
        fontSizeScale = SharedPreferencesUtils.getParam((Context)this, TEXT_SIZE_SETTING, Float.valueOf(0.0f)).floatValue();
    }

    public Resources getResources() {
        Resources res = super.getResources();
        Configuration config = res.getConfiguration();
        config.fontScale = (double)fontSizeScale > 0.5 ? fontSizeScale : 1.0f;
        res.updateConfiguration(config, res.getDisplayMetrics());
        return res;
    }

    private class SwitchBackgroundCallbacks
    implements Application.ActivityLifecycleCallbacks {
        private SwitchBackgroundCallbacks() {
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
            App.this.store.add(activity);
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
            App.this.store.remove(activity);
        }
    }
}

