/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.view.picker;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.supcon.common.view.util.ConvertUtils;
import com.supcon.common.view.view.picker.WheelPicker;
import com.supcon.common.view.view.picker.widget.WheelView;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SinglePicker<T>
extends WheelPicker {
    private static final int ITEM_WIDTH_UNKNOWN = -99;
    private List<T> items = new ArrayList<T>();
    private List<String> itemStrings = new ArrayList<String>();
    private WheelView wheelView;
    private OnWheelListener<T> onWheelListener;
    private OnItemPickListener<T> onItemPickListener;
    private int selectedItemIndex = 0;
    private String label = "";
    private int itemWidth = -99;

    public SinglePicker(Activity activity, T[] items) {
        this(activity, Arrays.asList(items));
    }

    public SinglePicker(Activity activity, List<T> items) {
        super(activity);
        this.setItems(items);
    }

    public void addItem(T item) {
        this.items.add(item);
        this.itemStrings.add(this.formatToString(item));
    }

    public void removeItem(T item) {
        this.items.remove(item);
        this.itemStrings.remove(this.formatToString(item));
    }

    public void setItems(T[] items) {
        this.setItems(Arrays.asList(items));
    }

    public void setItems(List<T> items) {
        if (null == items || items.size() == 0) {
            return;
        }
        this.items = items;
        this.itemStrings.clear();
        for (T item : items) {
            this.itemStrings.add(this.formatToString(item));
        }
        if (null != this.wheelView) {
            this.wheelView.setItems(this.itemStrings, this.selectedItemIndex);
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.items.size()) {
            this.selectedItemIndex = index;
        }
    }

    public void setSelectedItem(@NonNull T item) {
        this.setSelectedIndex(this.itemStrings.indexOf(this.formatToString(item)));
    }

    public void setItemWidth(int itemWidth) {
        if (null != this.wheelView) {
            ViewGroup.LayoutParams params = this.wheelView.getLayoutParams();
            params.width = ConvertUtils.toPx(this.activity, itemWidth);
            this.wheelView.setLayoutParams(params);
        } else {
            this.itemWidth = itemWidth;
        }
    }

    public void setOnWheelListener(OnWheelListener<T> onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public void setOnItemPickListener(OnItemPickListener<T> listener) {
        this.onItemPickListener = listener;
    }

    @Override
    @NonNull
    protected View makeCenterView() {
        if (this.items.size() == 0) {
            throw new IllegalArgumentException("Items can't be empty");
        }
        LinearLayout layout2 = new LinearLayout(this.activity);
        layout2.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        layout2.setOrientation(0);
        layout2.setGravity(17);
        this.wheelView = this.createWheelView();
        layout2.addView((View)this.wheelView);
        if (TextUtils.isEmpty((CharSequence)this.label)) {
            this.wheelView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.screenWidthPixels, -2));
        } else {
            this.wheelView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            TextView labelView = this.createLabelView();
            labelView.setText((CharSequence)this.label);
            layout2.addView((View)labelView);
        }
        this.wheelView.setItems(this.itemStrings, this.selectedItemIndex);
        this.wheelView.setOnItemSelectListener(new WheelView.OnItemSelectListener(){

            @Override
            public void onSelected(int index) {
                SinglePicker.this.selectedItemIndex = index;
                if (SinglePicker.this.onWheelListener != null) {
                    SinglePicker.this.onWheelListener.onWheeled(SinglePicker.this.selectedItemIndex, SinglePicker.this.items.get(index));
                }
            }
        });
        if (this.itemWidth != -99) {
            ViewGroup.LayoutParams params = this.wheelView.getLayoutParams();
            params.width = ConvertUtils.toPx(this.activity, this.itemWidth);
            this.wheelView.setLayoutParams(params);
        }
        return layout2;
    }

    private String formatToString(T item) {
        if (item instanceof Float || item instanceof Double) {
            return new DecimalFormat("0.00").format(item);
        }
        return item.toString();
    }

    @Override
    public void onSubmit() {
        if (this.onItemPickListener != null) {
            this.onItemPickListener.onItemPicked(this.selectedItemIndex, this.getSelectedItem());
        }
    }

    public T getSelectedItem() {
        return this.items.get(this.selectedItemIndex);
    }

    public int getSelectedIndex() {
        return this.selectedItemIndex;
    }

    public WheelView getWheelView() {
        return this.wheelView;
    }

    public static interface OnWheelListener<T> {
        public void onWheeled(int var1, T var2);
    }

    public static interface OnItemPickListener<T> {
        public void onItemPicked(int var1, T var2);
    }
}

