/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.view.loader.cycler;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.animation.DecelerateInterpolator;

public class CircularRevealAnimatedDrawable
extends Drawable
implements Animatable {
    private boolean mIsFilled;
    private Paint mPaint;
    private Paint mPaintImageReady;
    private View mAnimatedView;
    private float mRadius;
    private float mFinalRadius;
    private ValueAnimator mRevealInAnimation;
    private boolean isRunning;
    private float mCenterWidth;
    private float mCenterHeith;
    private Bitmap mReadyImage;
    private int mImageReadyAlpha;
    private float bitMapXOffset;
    private float bitMapYOffset;

    public CircularRevealAnimatedDrawable(View view, int fillColor, Bitmap bitmap) {
        this.mAnimatedView = view;
        this.isRunning = false;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(fillColor);
        this.mPaintImageReady = new Paint();
        this.mPaintImageReady.setAntiAlias(true);
        this.mPaintImageReady.setStyle(Paint.Style.FILL);
        this.mPaintImageReady.setColor(0);
        this.mReadyImage = bitmap;
        this.mImageReadyAlpha = 0;
        this.mRadius = 0.0f;
    }

    public boolean isFilled() {
        return this.mIsFilled;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        int bitMapWidth = (int)((double)(bounds.right - bounds.left) * 0.6);
        int bitMapHeight = (int)((double)(bounds.bottom - bounds.top) * 0.6);
        this.bitMapXOffset = (bounds.right - bounds.left - bitMapWidth) / 2;
        this.bitMapYOffset = (bounds.bottom - bounds.top - bitMapHeight) / 2;
        this.mReadyImage = Bitmap.createScaledBitmap((Bitmap)this.mReadyImage, (int)bitMapWidth, (int)bitMapHeight, (boolean)false);
        this.mFinalRadius = (bounds.right - bounds.left) / 2;
        this.mCenterWidth = (bounds.right + bounds.left) / 2;
        this.mCenterHeith = (bounds.bottom + bounds.top) / 2;
    }

    private void setupAnimations() {
        final ValueAnimator alphaAnimator = ValueAnimator.ofInt((int[])new int[]{0, 255});
        alphaAnimator.setDuration(80L);
        alphaAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CircularRevealAnimatedDrawable.this.mImageReadyAlpha = (Integer)animation.getAnimatedValue();
                CircularRevealAnimatedDrawable.this.invalidateSelf();
                CircularRevealAnimatedDrawable.this.mAnimatedView.invalidate();
            }
        });
        this.mRevealInAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.mFinalRadius});
        this.mRevealInAnimation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.mRevealInAnimation.setDuration(120L);
        this.mRevealInAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CircularRevealAnimatedDrawable.this.mRadius = ((Float)animation.getAnimatedValue()).floatValue();
                CircularRevealAnimatedDrawable.this.invalidateSelf();
                CircularRevealAnimatedDrawable.this.mAnimatedView.invalidate();
            }
        });
        this.mRevealInAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                CircularRevealAnimatedDrawable.this.mIsFilled = true;
                alphaAnimator.start();
            }
        });
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.setupAnimations();
        this.isRunning = true;
        this.mRevealInAnimation.start();
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.isRunning = false;
        this.mRevealInAnimation.cancel();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void draw(Canvas canvas) {
        canvas.drawCircle(this.mCenterWidth, this.mCenterHeith, this.mRadius, this.mPaint);
        if (this.mIsFilled) {
            this.mPaintImageReady.setAlpha(this.mImageReadyAlpha);
            canvas.drawBitmap(this.mReadyImage, this.bitMapXOffset, this.bitMapYOffset, this.mPaintImageReady);
        }
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -1;
    }

    public void dispose() {
        if (this.mRevealInAnimation != null) {
            this.mRevealInAnimation.end();
            this.mRevealInAnimation.removeAllUpdateListeners();
            this.mRevealInAnimation.cancel();
        }
        this.mRevealInAnimation = null;
    }
}

