/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.util;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import com.app.annotation.Bind;
import com.app.annotation.BindByTag;
import com.app.annotation.custom.OnChild;
import com.app.annotation.custom.OnDateChange;
import com.app.annotation.custom.OnItemChild;
import com.app.annotation.custom.OnItemSelect;
import com.app.annotation.custom.OnTextChange;
import com.supcon.common.view.base.adapter.IListAdapter;
import com.supcon.common.view.base.controller.RefreshListController;
import com.supcon.common.view.listener.OnChildViewClickListener;
import com.supcon.common.view.listener.OnItemChildViewClickListener;
import com.supcon.common.view.util.DateUtils;
import com.supcon.common.view.util.ViewUtils;
import com.supcon.common.view.view.custom.CustomViewController;
import com.supcon.common.view.view.custom.ICustomView;
import com.supcon.common.view.view.custom.OnContentCallback;
import com.supcon.common.view.view.custom.OnResultListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ViewBinder {
    public static void bindTag(Activity activity) {
        ViewBinder.bindTag(activity, activity.getWindow().getDecorView());
    }

    public static void bindTag(Object target, View source) {
        List<Field> fields = ViewBinder.getAllContextFields(target);
        if (fields != null && fields.size() > 0) {
            for (Field field : fields) {
                try {
                    field.setAccessible(true);
                    if (field.get(target) != null) continue;
                    Bind bind = field.getAnnotation(Bind.class);
                    if (bind != null) {
                        int viewId = bind.value();
                        field.set(target, source.findViewById(viewId));
                        continue;
                    }
                    BindByTag bindByTag = field.getAnnotation(BindByTag.class);
                    if (bindByTag != null) {
                        String tag = bindByTag.value();
                        field.set(target, source.findViewWithTag((Object)tag));
                        continue;
                    }
                    String fieldName = field.getName();
                    field.set(target, source.findViewWithTag((Object)fieldName));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void bindCustomView(Object target, View source) {
        List<Field> fields = ViewBinder.getAllContextFields(target);
        if (fields != null && fields.size() > 0) {
            for (Field field : fields) {
                try {
                    field.setAccessible(true);
                    if (field.get(target) == null) continue;
                    ViewBinder.bindCustomView(target, field, source);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void bindCustomView(final Object target, Field field, View source) {
        try {
            Object view;
            OnTextChange onTextChange;
            Object view2;
            OnItemSelect onItemSelect;
            HashMap<String, Object> params;
            Object view3;
            field.setAccessible(true);
            if (field.get(target) == null) {
                return;
            }
            CustomViewController customViewController = new CustomViewController(ViewUtils.getActivityFromView(source));
            final OnDateChange onDateChange = field.getAnnotation(OnDateChange.class);
            if (onDateChange != null && (view3 = field.get(target)) != null && view3 instanceof ICustomView) {
                final ICustomView customView = (ICustomView)view3;
                final Object current = ViewBinder.getParam(target, onDateChange.param());
                boolean isDividerVisible = onDateChange.dividerVisble();
                boolean isCancelOutsideEnable = onDateChange.cancelOutsideEnable();
                boolean isCycleEnable = onDateChange.cycleEnable();
                boolean isSecondVisible = onDateChange.secondVisible();
                int textSize = onDateChange.textSize();
                final String format = onDateChange.format();
                params = new HashMap<String, Object>();
                params.put("isCanceledOutsideEnable", isCancelOutsideEnable);
                params.put("isCycleEnable", isCycleEnable);
                params.put("isDividerVisible", isDividerVisible);
                params.put("isSecondVisible", isSecondVisible);
                params.put("format", format);
                params.put("textSize", textSize);
                customViewController.addDate(customView, params, new OnContentCallback<Object>(){

                    @Override
                    public Object getContent() {
                        return ViewBinder.getParam(target, onDateChange.param());
                    }
                }, new OnResultListener<String>(){

                    @Override
                    public void onResult(String result) {
                        customView.setContent(result);
                        String param = onDateChange.param();
                        if (current instanceof String) {
                            ViewBinder.setParam(target, result, param);
                        } else {
                            ViewBinder.setParam(target, DateUtils.dateFormat(result, format), param);
                        }
                    }
                });
            }
            if ((onItemSelect = field.getAnnotation(OnItemSelect.class)) != null && (view2 = field.get(target)) != null && view2 instanceof ICustomView) {
                final ICustomView customView = (ICustomView)view2;
                String valuesStr = onItemSelect.values();
                String[] values = (String[])ViewBinder.getFieldValue(target, valuesStr);
                boolean isDividerVisible = onItemSelect.dividerVisble();
                boolean isCancelOutsideEnable = onItemSelect.cancelOutsideEnable();
                boolean isCycleEnable = onItemSelect.cycleEnable();
                int textSize = onItemSelect.textSize();
                params = new HashMap();
                params.put("isCanceledOutsideEnable", isCancelOutsideEnable);
                params.put("isCycleEnable", isCycleEnable);
                params.put("isDividerVisible", isDividerVisible);
                params.put("values", values);
                params.put("textSize", textSize);
                customViewController.addSpinner(customView, params, new OnContentCallback<String>(){

                    @Override
                    public String getContent() {
                        return (String)ViewBinder.getParam(target, onItemSelect.param());
                    }
                }, new OnResultListener<String>(){

                    @Override
                    public void onResult(String result) {
                        customView.setContent(result);
                        String param = onItemSelect.param();
                        ViewBinder.setParam(target, result, param);
                    }
                });
            }
            if ((onTextChange = field.getAnnotation(OnTextChange.class)) != null && (view = field.get(target)) != null && view instanceof ICustomView) {
                ICustomView customView = (ICustomView)view;
                customViewController.addEditView(customView.editText(), onTextChange.debouce(), new OnResultListener<String>(){

                    @Override
                    public void onResult(String result) {
                        String param = onTextChange.param();
                        ViewBinder.setParam(target, result, param);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static <T> void setParam(Object target, T result, String param) {
        try {
            Field paramField = null;
            if (param.contains(".")) {
                Field entityField = ViewBinder.getOneField(target, param.split("\\.")[0]);
                if (entityField == null) {
                    return;
                }
                entityField.setAccessible(true);
                Object entity = entityField.get(target);
                if (entity != null && (paramField = ViewBinder.getOneField(entity, param.split("\\.")[1])) != null) {
                    paramField.setAccessible(true);
                    paramField.set(entity, result);
                }
            } else {
                paramField = ViewBinder.getOneField(target, param);
                if (paramField != null) {
                    paramField.setAccessible(true);
                    paramField.set(target, result);
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static Object getParam(Object target, String param) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            return null;
        }
        try {
            Field paramField = null;
            if (param.contains(".")) {
                Field entityField = ViewBinder.getOneField(target, param.split("\\.")[0]);
                if (entityField == null) {
                    return null;
                }
                entityField.setAccessible(true);
                Object entity = entityField.get(target);
                if (entity != null && (paramField = ViewBinder.getOneField(entity, param.split("\\.")[1])) != null) {
                    paramField.setAccessible(true);
                    Object current = paramField.get(entity);
                    if (current != null) {
                        return current;
                    }
                }
            } else {
                paramField = ViewBinder.getOneField(target, param);
                if (paramField != null) {
                    paramField.setAccessible(true);
                    Object current = paramField.get(target);
                    if (current != null) {
                        return current;
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void bindListener(Object target, View source) {
        List<Method> methods = ViewBinder.getAllContextMethods(target);
        if (methods != null && methods.size() > 0) {
            for (Method method : methods) {
                try {
                    OnItemChild onItemChild;
                    method.setAccessible(true);
                    OnChild onChild = method.getAnnotation(OnChild.class);
                    if (onChild != null) {
                        String[] views;
                        for (String viewTag : views = onChild.views()) {
                            View custom = source.findViewWithTag((Object)viewTag);
                            Method m = custom.getClass().getMethod("setOnChildViewClickListener", OnChildViewClickListener.class);
                            if (m == null) continue;
                            m.invoke((Object)custom, new DeclaredOnChildViewClickListener(method, target));
                        }
                    }
                    if ((onItemChild = method.getAnnotation(OnItemChild.class)) == null) continue;
                    Field refreshListControllerField = ViewBinder.getOneField(target, "refreshListController");
                    refreshListControllerField.setAccessible(true);
                    RefreshListController refreshListController = (RefreshListController)refreshListControllerField.get(target);
                    IListAdapter adapter = refreshListController.getListAdapter();
                    Method m = adapter.getClass().getMethod("setOnItemChildViewClickListener", OnItemChildViewClickListener.class);
                    if (m == null) continue;
                    m.invoke(adapter, new DeclaredOnItemChildViewClickListener(method, target));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static List<Field> getAllContextFields(Object target) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Class<?> tempClass = target.getClass();
        while (tempClass != null) {
            if (tempClass.getName().contains("com.supcon.common.view")) {
                tempClass = null;
                continue;
            }
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
            tempClass = tempClass.getSuperclass();
        }
        return fieldList;
    }

    private static List<Method> getAllContextMethods(Object target) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        Class<?> tempClass = target.getClass();
        while (tempClass != null) {
            if (tempClass.getName().contains("com.supcon.common.view")) {
                tempClass = null;
                continue;
            }
            methodList.addAll(Arrays.asList(tempClass.getDeclaredMethods()));
            tempClass = tempClass.getSuperclass();
        }
        return methodList;
    }

    private static List<Field> getAllFields(Object target) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = target.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        return fieldList;
    }

    private static Field getOneField(Object target, String name) {
        Field field = null;
        for (Class<?> tempClass = target.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
            try {
                field = tempClass.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (field == null) continue;
            return field;
        }
        return field;
    }

    private static Object getFieldValue(Object target, String name) {
        Field field = ViewBinder.getOneField(target, name);
        if (field != null) {
            try {
                field.setAccessible(true);
                return field.get(target);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static class DeclaredOnItemChildViewClickListener
    implements OnItemChildViewClickListener {
        private Method mMethod;
        private Object mObject;

        public DeclaredOnItemChildViewClickListener(Method method, Object object) {
            this.mMethod = method;
            this.mObject = object;
        }

        @Override
        public void onItemChildViewClick(View childView, int position, int action, Object obj) {
            this.mMethod.setAccessible(true);
            try {
                this.mMethod.invoke(this.mObject, childView, position, action, obj);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.mMethod.invoke(this.mObject, new Object[0]);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private static class DeclaredOnChildViewClickListener
    implements OnChildViewClickListener {
        private Method mMethod;
        private Object mObject;

        public DeclaredOnChildViewClickListener(Method method, Object object) {
            this.mMethod = method;
            this.mObject = object;
        }

        @Override
        public void onChildViewClick(View childView, int action, Object obj) {
            this.mMethod.setAccessible(true);
            try {
                this.mMethod.invoke(this.mObject, childView, action, obj);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.mMethod.invoke(this.mObject, new Object[0]);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

