/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.supcon.common.view.base.adapter.BaseListViewAdapter;
import com.supcon.common.view.base.adapter.viewholder.BaseViewHolder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class MicroUpdateListViewAdapter<T>
extends BaseListViewAdapter<T> {
    protected Map<BaseViewHolder<T>, T> viewHolders = Collections.synchronizedMap(new WeakHashMap());

    public MicroUpdateListViewAdapter(Context context) {
        super(context);
    }

    public MicroUpdateListViewAdapter(Context context, List<T> list) {
        super(context, list);
    }

    @Override
    public View getView(int position, View view, ViewGroup viewGroup) {
        View view1 = super.getView(position, view, viewGroup);
        this.viewHolders.put((BaseViewHolder)view1.getTag(), this.getItem(position));
        return view1;
    }

    public void notifyDataSetChanged(T t) {
        BaseViewHolder<T> viewHolder = this.findViewHolder(t);
        if (viewHolder != null) {
            viewHolder.update(viewHolder.getPosition(), t);
        }
    }

    public BaseViewHolder<T> findViewHolder(T t) {
        for (Map.Entry<BaseViewHolder<T>, T> entry : this.viewHolders.entrySet()) {
            if (!this.compareEqual(entry.getValue(), t)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.viewHolders.clear();
    }

    public void notifyDataSetInvalidated() {
        this.viewHolders.clear();
        super.notifyDataSetInvalidated();
    }

    @Override
    public void notifyDataSetChanged() {
        this.viewHolders.clear();
        super.notifyDataSetChanged();
    }
}

