/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.model.java;

import com.sun.tools.ws.processor.model.Parameter;
import com.sun.tools.ws.processor.model.java.JavaParameter;
import com.sun.tools.ws.processor.model.java.JavaType;
import com.sun.tools.ws.resources.ModelMessages;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.WsimportOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JavaMethod {
    private final ErrorReceiver errorReceiver;
    private final String name;
    private final List<JavaParameter> parameters = new ArrayList<JavaParameter>();
    private final List<String> exceptions = new ArrayList<String>();
    private final WsimportOptions options;
    private JavaType returnType;

    public JavaMethod(String name, WsimportOptions options, ErrorReceiver receiver) {
        this.name = name;
        this.returnType = null;
        this.errorReceiver = receiver;
        this.options = options;
    }

    public String getName() {
        return this.name;
    }

    public JavaType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(JavaType returnType) {
        this.returnType = returnType;
    }

    private boolean hasParameter(String paramName) {
        for (JavaParameter parameter : this.parameters) {
            if (!paramName.equals(parameter.getName())) continue;
            return true;
        }
        return false;
    }

    private Parameter getParameter(String paramName) {
        for (JavaParameter parameter : this.parameters) {
            if (!paramName.equals(parameter.getName())) continue;
            return parameter.getParameter();
        }
        return null;
    }

    public void addParameter(JavaParameter param) {
        if (this.hasParameter(param.getName())) {
            if (this.options.isExtensionMode()) {
                param.setName(this.getUniqueName(param.getName()));
            } else {
                Parameter duplicParam = this.getParameter(param.getName());
                if (param.getParameter().isEmbedded()) {
                    this.errorReceiver.error(param.getParameter().getLocator(), ModelMessages.MODEL_PARAMETER_NOTUNIQUE_WRAPPER(param.getName(), param.getParameter().getEntityName()));
                    this.errorReceiver.error(duplicParam.getLocator(), ModelMessages.MODEL_PARAMETER_NOTUNIQUE_WRAPPER(param.getName(), duplicParam.getEntityName()));
                } else {
                    this.errorReceiver.error(param.getParameter().getLocator(), ModelMessages.MODEL_PARAMETER_NOTUNIQUE(param.getName(), param.getParameter().getEntityName()));
                    this.errorReceiver.error(duplicParam.getLocator(), ModelMessages.MODEL_PARAMETER_NOTUNIQUE(param.getName(), duplicParam.getEntityName()));
                }
                return;
            }
        }
        this.parameters.add(param);
    }

    public List<JavaParameter> getParametersList() {
        return this.parameters;
    }

    public void addException(String exception) {
        if (!this.exceptions.contains(exception)) {
            this.exceptions.add(exception);
        }
    }

    public Iterator<String> getExceptions() {
        return this.exceptions.iterator();
    }

    private String getUniqueName(String param) {
        int parmNum = 0;
        while (this.hasParameter(param)) {
            param = param + Integer.toString(parmNum++);
        }
        return param;
    }
}

