/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.istack.NotNull;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.wscompile.AuthInfo;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class DefaultAuthenticator
extends Authenticator {
    private final List<AuthInfo> authInfo = new ArrayList<AuthInfo>();
    private final ErrorReceiver errReceiver;
    private final String proxyUser;
    private final String proxyPasswd;
    public static final String defaultAuthfile = System.getProperty("user.home") + System.getProperty("file.separator") + ".metro" + System.getProperty("file.separator") + "auth";
    private File authFile = new File(defaultAuthfile);
    private boolean giveError;

    public DefaultAuthenticator(@NotNull ErrorReceiver receiver, @NotNull File authfile) throws BadCommandLineException {
        this.errReceiver = receiver;
        this.proxyUser = System.getProperty("http.proxyUser");
        this.proxyPasswd = System.getProperty("http.proxyPassword");
        if (authfile != null) {
            this.authFile = authfile;
            this.giveError = true;
        }
        if (!this.authFile.exists()) {
            try {
                this.error(new SAXParseException(WscompileMessages.WSIMPORT_AUTH_FILE_NOT_FOUND(this.authFile.getCanonicalPath(), defaultAuthfile), null));
            }
            catch (IOException e) {
                this.error(new SAXParseException(WscompileMessages.WSIMPORT_FAILED_TO_PARSE(this.authFile, e.getMessage()), null));
            }
            return;
        }
        if (!this.authFile.canRead()) {
            this.error(new SAXParseException("Authorization file: " + this.authFile + " does not have read permission!", null));
            return;
        }
        this.parseAuth();
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.proxyUser != null && this.proxyPasswd != null) {
            return new PasswordAuthentication(this.proxyUser, this.proxyPasswd.toCharArray());
        }
        for (AuthInfo auth : this.authInfo) {
            if (!auth.matchingHost(this.getRequestingURL())) continue;
            return new PasswordAuthentication(auth.getUser(), auth.getPassword().toCharArray());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Authenticator getCurrentAuthenticator() {
        Authenticator authenticator;
        block6: {
            final Field f = DefaultAuthenticator.getTheAuthenticator();
            if (f == null) {
                return null;
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        f.setAccessible(true);
                        return null;
                    }
                });
                authenticator = (Authenticator)f.get(null);
                if (f == null) break block6;
            }
            catch (Exception ex) {
                Authenticator authenticator2;
                block7: {
                    try {
                        authenticator2 = null;
                        if (f == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (f != null) {
                            AccessController.doPrivileged(new PrivilegedAction<Void>(f){
                                final /* synthetic */ Field val$f;
                                {
                                    this.val$f = field;
                                }

                                @Override
                                public Void run() {
                                    this.val$f.setAccessible(false);
                                    return null;
                                }
                            });
                        }
                        throw throwable;
                    }
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
                return authenticator2;
            }
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }
        return authenticator;
    }

    private static Field getTheAuthenticator() {
        try {
            return Authenticator.class.getDeclaredField("theAuthenticator");
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void parseAuth() {
        block35: {
            this.errReceiver.info(new SAXParseException(WscompileMessages.WSIMPORT_READING_AUTH_FILE(this.authFile), null));
            BufferedReader in = null;
            FileInputStream fi = null;
            InputStreamReader is = null;
            try {
                try {
                    fi = new FileInputStream(this.authFile);
                    is = new InputStreamReader((InputStream)fi, "UTF-8");
                    in = new BufferedReader(is);
                }
                catch (UnsupportedEncodingException e) {
                    this.error(new SAXParseException(e.getMessage(), null));
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (fi != null) {
                            fi.close();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(DefaultAuthenticator.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    return;
                }
                catch (FileNotFoundException e) {
                    this.error(new SAXParseException(WscompileMessages.WSIMPORT_AUTH_FILE_NOT_FOUND(this.authFile, defaultAuthfile), null, e));
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (fi != null) {
                            fi.close();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(DefaultAuthenticator.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    return;
                }
                String text = "";
                LocatorImpl locator = new LocatorImpl();
                try {
                    int lineno = 1;
                    locator.setSystemId(this.authFile.getCanonicalPath());
                    while ((text = in.readLine()) != null) {
                        locator.setLineNumber(lineno++);
                        if ("".equals(text.trim()) || text.startsWith("#")) continue;
                        try {
                            int i;
                            URL url;
                            try {
                                url = new URL(text);
                            }
                            catch (MalformedURLException mue) {
                                i = text.indexOf(58, text.indexOf(58) + 1) + 1;
                                int j = text.lastIndexOf(64);
                                String encodedUrl = text.substring(0, i) + URLEncoder.encode(text.substring(i, j), "UTF-8") + text.substring(j);
                                url = new URL(encodedUrl);
                                text = encodedUrl;
                            }
                            String authinfo = url.getUserInfo();
                            if (authinfo != null) {
                                i = authinfo.indexOf(58);
                                if (i >= 0) {
                                    String user = authinfo.substring(0, i);
                                    String password = authinfo.substring(i + 1);
                                    this.authInfo.add(new AuthInfo(new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile()), user, URLDecoder.decode(password, "UTF-8")));
                                    continue;
                                }
                                this.error(new SAXParseException(WscompileMessages.WSIMPORT_ILLEGAL_AUTH_INFO(url), locator));
                                continue;
                            }
                            this.error(new SAXParseException(WscompileMessages.WSIMPORT_ILLEGAL_AUTH_INFO(url), locator));
                        }
                        catch (MalformedURLException e) {
                            this.error(new SAXParseException(WscompileMessages.WSIMPORT_ILLEGAL_AUTH_INFO(text), locator));
                        }
                    }
                    break block35;
                }
                catch (IOException e) {
                    this.error(new SAXParseException(WscompileMessages.WSIMPORT_FAILED_TO_PARSE(this.authFile, e.getMessage()), locator));
                    break block35;
                }
                catch (Throwable t) {
                    Logger.getLogger(DefaultAuthenticator.class.getName()).log(Level.SEVERE, t.getMessage(), t);
                    this.error(new SAXParseException(WscompileMessages.WSIMPORT_ILLEGAL_AUTH_INFO(text), locator));
                    break block35;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                    if (fi != null) {
                        fi.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(DefaultAuthenticator.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void error(SAXParseException e) {
        if (this.giveError) {
            this.errReceiver.error(e);
        } else {
            this.errReceiver.debug(e);
        }
    }
}

