/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.parser;

import com.sun.istack.NotNull;
import com.sun.tools.ws.util.xml.XmlUtil;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.parser.DOMBuilder;
import com.sun.tools.ws.wsdl.parser.InternalizationLogic;
import com.sun.tools.ws.wsdl.parser.VersionChecker;
import com.sun.tools.ws.wsdl.parser.WhitespaceStripper;
import com.sun.tools.xjc.reader.internalizer.LocatorTable;
import com.sun.xml.bind.marshaller.DataWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class DOMForest {
    protected final Set<String> rootDocuments = new HashSet<String>();
    protected final Set<String> externalReferences = new HashSet<String>();
    protected final Map<String, Document> core = new HashMap<String, Document>();
    protected final ErrorReceiver errorReceiver;
    private final DocumentBuilder documentBuilder;
    private final SAXParserFactory parserFactory;
    protected final List<Element> inlinedSchemaElements = new ArrayList<Element>();
    public final LocatorTable locatorTable = new LocatorTable();
    protected final EntityResolver entityResolver;
    public final Set<Element> outerMostBindings = new HashSet<Element>();
    protected final InternalizationLogic logic;
    protected final WsimportOptions options;
    protected Map<String, String> resolvedCache = new HashMap<String, String>();

    public DOMForest(InternalizationLogic logic, @NotNull EntityResolver entityResolver, WsimportOptions options, ErrorReceiver errReceiver) {
        this.options = options;
        this.entityResolver = entityResolver;
        this.errorReceiver = errReceiver;
        this.logic = logic;
        try {
            boolean secureProcessingEnabled = options == null || !options.disableXmlSecurity;
            DocumentBuilderFactory dbf = XmlUtil.newDocumentBuilderFactory((boolean)secureProcessingEnabled);
            dbf.setNamespaceAware(true);
            this.documentBuilder = dbf.newDocumentBuilder();
            this.parserFactory = XmlUtil.newSAXParserFactory((boolean)secureProcessingEnabled);
            this.parserFactory.setNamespaceAware(true);
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public List<Element> getInlinedSchemaElement() {
        return this.inlinedSchemaElements;
    }

    @NotNull
    public Document parse(InputSource source, boolean root) throws SAXException, IOException {
        if (source.getSystemId() == null) {
            throw new IllegalArgumentException();
        }
        return this.parse(source.getSystemId(), source, root);
    }

    public Document parse(String systemId, boolean root) throws SAXException, IOException {
        systemId = this.normalizeSystemId(systemId);
        InputSource is = null;
        is = this.entityResolver.resolveEntity(null, systemId);
        if (is == null) {
            is = new InputSource(systemId);
        } else {
            this.resolvedCache.put(systemId, is.getSystemId());
            systemId = is.getSystemId();
        }
        if (this.core.containsKey(systemId)) {
            return this.core.get(systemId);
        }
        if (!root) {
            this.addExternalReferences(systemId);
        }
        return this.parse(systemId, is, root);
    }

    public Map<String, String> getReferencedEntityMap() {
        return this.resolvedCache;
    }

    @NotNull
    private Document parse(String systemId, InputSource inputSource, boolean root) throws SAXException, IOException {
        Document dom = this.documentBuilder.newDocument();
        systemId = this.normalizeSystemId(systemId);
        this.core.put(systemId, dom);
        dom.setDocumentURI(systemId);
        if (root) {
            this.rootDocuments.add(systemId);
        }
        try {
            XMLReader reader = this.createReader(dom);
            Object is = null;
            if (inputSource.getByteStream() == null) {
                inputSource = this.entityResolver.resolveEntity(null, systemId);
            }
            reader.parse(inputSource);
            Element doc = dom.getDocumentElement();
            if (doc == null) {
                return null;
            }
            NodeList schemas = doc.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
            for (int i = 0; i < schemas.getLength(); ++i) {
                this.inlinedSchemaElements.add((Element)schemas.item(i));
            }
        }
        catch (ParserConfigurationException e) {
            this.errorReceiver.error(e);
            throw new SAXException(e.getMessage());
        }
        this.resolvedCache.put(systemId, dom.getDocumentURI());
        return dom;
    }

    public void addExternalReferences(String ref) {
        if (!this.externalReferences.contains(ref)) {
            this.externalReferences.add(ref);
        }
    }

    public Set<String> getExternalReferences() {
        return this.externalReferences;
    }

    private XMLReader createReader(Document dom) throws SAXException, ParserConfigurationException {
        XMLReader reader = this.parserFactory.newSAXParser().getXMLReader();
        DOMBuilder dombuilder = new DOMBuilder(dom, this.locatorTable, this.outerMostBindings);
        try {
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", dombuilder);
        }
        catch (SAXException e) {
            this.errorReceiver.debug(e.getMessage());
        }
        XMLFilterImpl handler = new WhitespaceStripper((ContentHandler)((Object)dombuilder), this.errorReceiver, this.entityResolver);
        handler = new VersionChecker(handler, this.errorReceiver, this.entityResolver);
        XMLFilterImpl f = this.logic.createExternalReferenceFinder(this);
        f.setContentHandler(handler);
        if (this.errorReceiver != null) {
            f.setErrorHandler(this.errorReceiver);
        }
        f.setEntityResolver(this.entityResolver);
        reader.setContentHandler(f);
        if (this.errorReceiver != null) {
            reader.setErrorHandler(this.errorReceiver);
        }
        reader.setEntityResolver(this.entityResolver);
        return reader;
    }

    private String normalizeSystemId(String systemId) {
        try {
            systemId = new URI(systemId).normalize().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return systemId;
    }

    boolean isExtensionMode() {
        return this.options.isExtensionMode();
    }

    public Document get(String systemId) {
        Document doc = this.core.get(systemId);
        if (doc == null && systemId.startsWith("file:/") && !systemId.startsWith("file://")) {
            doc = this.core.get("file://" + systemId.substring(5));
        }
        if (doc == null && systemId.startsWith("file:")) {
            String systemPath = this.getPath(systemId);
            for (String key : this.core.keySet()) {
                if (!key.startsWith("file:") || !this.getPath(key).equalsIgnoreCase(systemPath)) continue;
                doc = this.core.get(key);
                break;
            }
        }
        return doc;
    }

    private String getPath(String key) {
        key = key.substring(5);
        while (key.length() > 0 && key.charAt(0) == '/') {
            key = key.substring(1);
        }
        return key;
    }

    public String[] listSystemIDs() {
        return this.core.keySet().toArray(new String[this.core.keySet().size()]);
    }

    public String getSystemId(Document dom) {
        for (Map.Entry<String, Document> e : this.core.entrySet()) {
            if (e.getValue() != dom) continue;
            return e.getKey();
        }
        return null;
    }

    public String getFirstRootDocument() {
        if (this.rootDocuments.isEmpty()) {
            return null;
        }
        return this.rootDocuments.iterator().next();
    }

    public Set<String> getRootDocuments() {
        return this.rootDocuments;
    }

    public void dump(OutputStream out) throws IOException {
        try {
            boolean secureProcessingEnabled = this.options == null || !this.options.disableXmlSecurity;
            TransformerFactory tf = XmlUtil.newTransformerFactory((boolean)secureProcessingEnabled);
            Transformer it = tf.newTransformer();
            for (Map.Entry<String, Document> e : this.core.entrySet()) {
                out.write(("---<< " + e.getKey() + '\n').getBytes());
                DataWriter dw = new DataWriter((Writer)new OutputStreamWriter(out), null);
                dw.setIndentStep("  ");
                it.transform(new DOMSource(e.getValue()), new SAXResult((ContentHandler)dw));
                out.write("\n\n\n".getBytes());
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static interface Handler
    extends ContentHandler {
        public Document getDocument();
    }
}

