/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.addressing.policy.Address;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.LogStringsMessages;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.UsernameToken;
import com.sun.xml.ws.security.impl.policyconv.PolicyID;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyUtil;
import com.sun.xml.ws.security.policy.AsymmetricBinding;
import com.sun.xml.ws.security.policy.Binding;
import com.sun.xml.ws.security.policy.IssuedToken;
import com.sun.xml.ws.security.policy.KerberosToken;
import com.sun.xml.ws.security.policy.KeyValueToken;
import com.sun.xml.ws.security.policy.RsaToken;
import com.sun.xml.ws.security.policy.SamlToken;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.ws.security.policy.UserNameToken;
import com.sun.xml.ws.security.policy.X509Token;
import com.sun.xml.wss.impl.policy.PolicyGenerationException;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.KeyBindingBase;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.util.Set;
import java.util.logging.Level;

public class TokenProcessor {
    protected boolean isServer = false;
    protected boolean isIncoming = false;
    private PolicyID pid = null;
    SymmetricKeyBinding skb = new SymmetricKeyBinding();

    public TokenProcessor(boolean isServer, boolean isIncoming, PolicyID pid) {
        this.isServer = isServer;
        this.isIncoming = isIncoming;
        this.pid = pid;
    }

    protected void setX509TokenRefType(AuthenticationTokenPolicy.X509CertificateBinding x509CB, X509Token token) {
        Set tokenRefTypes = token.getTokenRefernceType();
        if (!tokenRefTypes.isEmpty()) {
            if (tokenRefTypes.contains("RequireThumbprintReference")) {
                if (Constants.logger.isLoggable(Level.FINEST)) {
                    Constants.logger.log(Level.FINEST, " ReferenceType set to KeyBinding" + x509CB + " is Thumbprint");
                }
                x509CB.setReferenceType(SecurityPolicyUtil.convertToXWSSConstants("RequireThumbprintReference"));
            } else if (tokenRefTypes.contains("RequireKeyIdentifierReference")) {
                if (Constants.logger.isLoggable(Level.FINEST)) {
                    Constants.logger.log(Level.FINEST, " ReferenceType set to KeyBinding" + x509CB + " is KeyIdentifier");
                }
                x509CB.setReferenceType(SecurityPolicyUtil.convertToXWSSConstants("RequireKeyIdentifierReference"));
            } else if (tokenRefTypes.contains("RequireIssuerSerialReference")) {
                if (Constants.logger.isLoggable(Level.FINEST)) {
                    Constants.logger.log(Level.FINEST, " ReferenceType set to KeyBinding " + x509CB + " is IssuerSerial");
                }
                x509CB.setReferenceType(SecurityPolicyUtil.convertToXWSSConstants("RequireIssuerSerialReference"));
            } else {
                if (Constants.logger.isLoggable(Level.FINEST)) {
                    Constants.logger.log(Level.FINEST, " ReferenceType " + x509CB + " set is DirectReference");
                }
                x509CB.setReferenceType("Direct");
            }
        } else {
            if (Constants.logger.isLoggable(Level.FINEST)) {
                Constants.logger.log(Level.FINEST, " ReferenceType set is REQUIRE_THUMBPRINT_REFERENCE");
            }
            x509CB.setReferenceType("Direct");
        }
    }

    protected void setKerberosTokenRefType(AuthenticationTokenPolicy.KerberosTokenBinding kerberosBinding, KerberosToken token) {
        Set tokenRefTypes = token.getTokenRefernceType();
        if (!tokenRefTypes.isEmpty()) {
            if (tokenRefTypes.contains("RequireKeyIdentifierReference")) {
                if (Constants.logger.isLoggable(Level.FINEST)) {
                    Constants.logger.log(Level.FINEST, " ReferenceType set to KeyBinding" + kerberosBinding + " is KeyIdentifier");
                }
                kerberosBinding.setReferenceType(SecurityPolicyUtil.convertToXWSSConstants("RequireKeyIdentifierReference"));
            } else {
                if (Constants.logger.isLoggable(Level.FINEST)) {
                    Constants.logger.log(Level.FINEST, " ReferenceType " + kerberosBinding + " set is DirectReference");
                }
                kerberosBinding.setReferenceType("Direct");
            }
        } else {
            if (Constants.logger.isLoggable(Level.FINEST)) {
                Constants.logger.log(Level.FINEST, " ReferenceType set is DirectReference");
            }
            kerberosBinding.setReferenceType("Direct");
        }
    }

    protected void setUsernameTokenRefType(AuthenticationTokenPolicy.UsernameTokenBinding untBinding, UsernameToken unToken) {
        untBinding.setReferenceType("Direct");
    }

    public void addKeyBinding(Binding binding, WSSPolicy policy, Token token, boolean ignoreDK) throws PolicyException {
        PolicyAssertion tokenAssertion = (PolicyAssertion)((Object)token);
        SecurityPolicyVersion spVersion = SecurityPolicyUtil.getSPVersion(tokenAssertion);
        if (PolicyUtil.isUsernameToken(tokenAssertion, spVersion)) {
            AuthenticationTokenPolicy.UsernameTokenBinding untBinding = new AuthenticationTokenPolicy.UsernameTokenBinding();
            UsernameToken unToken = (UsernameToken)tokenAssertion;
            untBinding.setUUID(token.getTokenId());
            this.setUsernameTokenRefType(untBinding, unToken);
            this.setTokenInclusion(untBinding, (Token)((Object)tokenAssertion));
            this.setTokenValueType(untBinding, tokenAssertion);
            if (unToken.getIssuer() != null) {
                Address addr = unToken.getIssuer().getAddress();
                if (addr != null) {
                    untBinding.setIssuer(addr.getURI().toString());
                }
            } else if (unToken.getIssuerName() != null) {
                untBinding.setIssuer(unToken.getIssuerName().getIssuerName());
            }
            if (unToken.getClaims() != null) {
                untBinding.setClaims(unToken.getClaims().getClaimsAsBytes());
            }
            if (!ignoreDK && unToken.isRequireDerivedKeys()) {
                DerivedTokenKeyBinding dtKB = new DerivedTokenKeyBinding();
                if (binding instanceof AsymmetricBinding && ((AsymmetricBinding)binding).getInitiatorToken() != null) {
                    this.skb.setKeyBinding(untBinding);
                    dtKB.setOriginalKeyBinding(this.skb);
                    policy.setKeyBinding(dtKB);
                } else {
                    dtKB.setOriginalKeyBinding(untBinding);
                    policy.setKeyBinding(dtKB);
                }
                dtKB.setUUID(this.pid.generateID());
            } else if (binding instanceof AsymmetricBinding && ((AsymmetricBinding)binding).getInitiatorToken() != null) {
                this.skb.setKeyBinding(untBinding);
                policy.setKeyBinding(this.skb);
            } else {
                policy.setKeyBinding(untBinding);
            }
        } else if (PolicyUtil.isX509Token(tokenAssertion, spVersion)) {
            AuthenticationTokenPolicy.X509CertificateBinding x509CB = new AuthenticationTokenPolicy.X509CertificateBinding();
            X509Token x509Token = (X509Token)((Object)tokenAssertion);
            x509CB.setUUID(token.getTokenId());
            this.setX509TokenRefType(x509CB, x509Token);
            this.setTokenInclusion(x509CB, (Token)((Object)tokenAssertion));
            this.setTokenValueType(x509CB, tokenAssertion);
            if (x509Token.getIssuer() != null) {
                Address addr = x509Token.getIssuer().getAddress();
                if (addr != null) {
                    x509CB.setIssuer(addr.getURI().toString());
                }
            } else if (x509Token.getIssuerName() != null) {
                x509CB.setIssuer(x509Token.getIssuerName().getIssuerName());
            }
            if (x509Token.getClaims() != null) {
                x509CB.setClaims(x509Token.getClaims().getClaimsAsBytes());
            }
            if (!ignoreDK && x509Token.isRequireDerivedKeys()) {
                DerivedTokenKeyBinding dtKB = new DerivedTokenKeyBinding();
                dtKB.setOriginalKeyBinding(x509CB);
                policy.setKeyBinding(dtKB);
                dtKB.setUUID(this.pid.generateID());
            } else {
                policy.setKeyBinding(x509CB);
            }
        } else if (PolicyUtil.isSamlToken(tokenAssertion, spVersion)) {
            AuthenticationTokenPolicy.SAMLAssertionBinding sab = new AuthenticationTokenPolicy.SAMLAssertionBinding();
            SamlToken samlToken = (SamlToken)((Object)tokenAssertion);
            sab.setUUID(token.getTokenId());
            sab.setSTRID(token.getTokenId());
            sab.setReferenceType("Direct");
            this.setTokenInclusion(sab, (Token)((Object)tokenAssertion));
            if (samlToken.getIssuer() != null) {
                Address addr = samlToken.getIssuer().getAddress();
                if (addr != null) {
                    sab.setIssuer(addr.getURI().toString());
                }
            } else if (samlToken.getIssuerName() != null) {
                sab.setIssuer(samlToken.getIssuerName().getIssuerName());
            }
            if (samlToken.getClaims() != null) {
                sab.setClaims(samlToken.getClaims().getClaimsAsBytes());
            }
            if (samlToken.isRequireDerivedKeys()) {
                DerivedTokenKeyBinding dtKB = new DerivedTokenKeyBinding();
                dtKB.setOriginalKeyBinding(sab);
                policy.setKeyBinding(dtKB);
                dtKB.setUUID(this.pid.generateID());
            } else {
                policy.setKeyBinding(sab);
            }
        } else if (PolicyUtil.isIssuedToken(tokenAssertion, spVersion)) {
            IssuedTokenKeyBinding itkb = new IssuedTokenKeyBinding();
            this.setTokenInclusion(itkb, (Token)((Object)tokenAssertion));
            itkb.setUUID(((Token)((Object)tokenAssertion)).getTokenId());
            itkb.setSTRID(token.getTokenId());
            IssuedToken it = (IssuedToken)((Object)tokenAssertion);
            if (it.getIssuer() != null) {
                Address addr = it.getIssuer().getAddress();
                if (addr != null) {
                    itkb.setIssuer(addr.getURI().toString());
                }
            } else if (it.getIssuerName() != null) {
                itkb.setIssuer(it.getIssuerName().getIssuerName());
            }
            if (it.getClaims() != null) {
                itkb.setClaims(it.getClaims().getClaimsAsBytes());
            }
            if (it.isRequireDerivedKeys()) {
                DerivedTokenKeyBinding dtKB = new DerivedTokenKeyBinding();
                dtKB.setOriginalKeyBinding(itkb);
                policy.setKeyBinding(dtKB);
                dtKB.setUUID(this.pid.generateID());
            } else {
                policy.setKeyBinding(itkb);
            }
        } else if (PolicyUtil.isSecureConversationToken(tokenAssertion, spVersion)) {
            SecureConversationTokenKeyBinding sct = new SecureConversationTokenKeyBinding();
            SecureConversationToken sctPolicy = (SecureConversationToken)((Object)tokenAssertion);
            if (sctPolicy.getIssuer() != null) {
                Address addr = sctPolicy.getIssuer().getAddress();
                if (addr != null) {
                    sct.setIssuer(addr.getURI().toString());
                }
            } else if (sctPolicy.getIssuerName() != null) {
                sct.setIssuer(sctPolicy.getIssuerName().getIssuerName());
            }
            if (sctPolicy.getClaims() != null) {
                sct.setClaims(sctPolicy.getClaims().getClaimsAsBytes());
            }
            if (sctPolicy.isRequireDerivedKeys()) {
                DerivedTokenKeyBinding dtKB = new DerivedTokenKeyBinding();
                dtKB.setOriginalKeyBinding(sct);
                policy.setKeyBinding(dtKB);
                dtKB.setUUID(this.pid.generateID());
            } else {
                policy.setKeyBinding(sct);
            }
            this.setTokenInclusion(sct, (Token)((Object)tokenAssertion));
            sct.setUUID(((Token)((Object)tokenAssertion)).getTokenId());
        } else if (PolicyUtil.isRsaToken((PolicyAssertion)((Object)token), spVersion)) {
            AuthenticationTokenPolicy.KeyValueTokenBinding rsaTB = new AuthenticationTokenPolicy.KeyValueTokenBinding();
            RsaToken rsaToken = (RsaToken)((Object)tokenAssertion);
            rsaTB.isOptional(tokenAssertion.isOptional());
            rsaTB.setUUID(token.getTokenId());
            this.setTokenInclusion(rsaTB, (Token)((Object)tokenAssertion));
            policy.setKeyBinding(rsaTB);
        } else if (PolicyUtil.isKeyValueToken((PolicyAssertion)((Object)token), spVersion)) {
            AuthenticationTokenPolicy.KeyValueTokenBinding rsaTB = new AuthenticationTokenPolicy.KeyValueTokenBinding();
            KeyValueToken rsaToken = (KeyValueToken)((Object)tokenAssertion);
            rsaTB.setUUID(token.getTokenId());
            rsaTB.isOptional(tokenAssertion.isOptional());
            this.setTokenInclusion(rsaTB, (Token)((Object)tokenAssertion));
            policy.setKeyBinding(rsaTB);
        } else {
            throw new UnsupportedOperationException("addKeyBinding for " + token + "is not supported");
        }
        if (Constants.logger.isLoggable(Level.FINEST)) {
            Constants.logger.log(Level.FINEST, "KeyBinding type " + policy.getKeyBinding() + "has been added to policy" + policy);
        }
    }

    protected void setTokenInclusion(KeyBindingBase xwssToken, Token token) throws PolicyException {
        boolean change = false;
        SecurityPolicyVersion spVersion = token.getSecurityPolicyVersion();
        if (this.isServer && !this.isIncoming) {
            if (!spVersion.includeTokenAlways.equals(token.getIncludeToken())) {
                xwssToken.setIncludeToken(SecurityPolicyVersion.SECURITYPOLICY200507.includeTokenNever);
                if (Constants.logger.isLoggable(Level.FINEST)) {
                    Constants.logger.log(Level.FINEST, "Token Inclusion value of INCLUDE NEVER has been set to Token" + xwssToken);
                }
                return;
            }
        } else if (!this.isServer && this.isIncoming && (spVersion.includeTokenAlwaysToRecipient.equals(token.getIncludeToken()) || spVersion.includeTokenOnce.equals(token.getIncludeToken()))) {
            xwssToken.setIncludeToken(SecurityPolicyVersion.SECURITYPOLICY200507.includeTokenNever);
            if (Constants.logger.isLoggable(Level.FINEST)) {
                Constants.logger.log(Level.FINEST, "Token Inclusion value of INCLUDE NEVER has been set to Token" + xwssToken);
            }
            return;
        }
        if (Constants.logger.isLoggable(Level.FINEST)) {
            Constants.logger.log(Level.FINEST, "Token Inclusion value of" + token.getIncludeToken() + " has been set to Token" + xwssToken);
        }
        if (spVersion == SecurityPolicyVersion.SECURITYPOLICY200507) {
            xwssToken.setIncludeToken(token.getIncludeToken());
        } else if (spVersion.includeTokenAlways.equals(token.getIncludeToken())) {
            xwssToken.setIncludeToken(SecurityPolicyVersion.SECURITYPOLICY200507.includeTokenAlways);
        } else if (spVersion.includeTokenAlwaysToRecipient.equals(token.getIncludeToken())) {
            xwssToken.setIncludeToken(SecurityPolicyVersion.SECURITYPOLICY200507.includeTokenAlwaysToRecipient);
        } else if (spVersion.includeTokenNever.equals(token.getIncludeToken())) {
            xwssToken.setIncludeToken(SecurityPolicyVersion.SECURITYPOLICY200507.includeTokenNever);
        } else if (spVersion.includeTokenOnce.equals(token.getIncludeToken())) {
            xwssToken.setIncludeToken(SecurityPolicyVersion.SECURITYPOLICY200507.includeTokenOnce);
        }
    }

    public WSSPolicy getWSSToken(Token token) throws PolicyException {
        SecurityPolicyVersion spVersion = SecurityPolicyUtil.getSPVersion((PolicyAssertion)((Object)token));
        if (PolicyUtil.isUsernameToken((PolicyAssertion)((Object)token), spVersion)) {
            AuthenticationTokenPolicy.UsernameTokenBinding key = null;
            key = new AuthenticationTokenPolicy.UsernameTokenBinding();
            try {
                key.newTimestampFeatureBinding();
            }
            catch (PolicyGenerationException ex) {
                throw new PolicyException(ex);
            }
            key.setUUID(token.getTokenId());
            this.setTokenInclusion(key, token);
            UserNameToken ut = (UserNameToken)token;
            if (!ut.hasPassword()) {
                key.setNoPassword(true);
            } else if (ut.useHashPassword()) {
                key.setDigestOn(true);
                key.setUseNonce(true);
            }
            if (ut.getIssuer() != null) {
                Address addr = ut.getIssuer().getAddress();
                if (addr != null) {
                    key.setIssuer(addr.getURI().toString());
                }
            } else if (ut.getIssuerName() != null) {
                key.setIssuer(ut.getIssuerName().getIssuerName());
            }
            if (ut.getClaims() != null) {
                key.setClaims(ut.getClaims().getClaimsAsBytes());
            }
            return key;
        }
        if (PolicyUtil.isSamlToken((PolicyAssertion)((Object)token), spVersion)) {
            AuthenticationTokenPolicy.SAMLAssertionBinding key = null;
            key = new AuthenticationTokenPolicy.SAMLAssertionBinding();
            this.setTokenInclusion(key, token);
            key.setAssertionType("SV");
            key.setUUID(token.getTokenId());
            key.setSTRID(token.getTokenId());
            SamlToken samlToken = (SamlToken)token;
            if (samlToken.getIssuer() != null) {
                Address addr = samlToken.getIssuer().getAddress();
                if (addr != null) {
                    key.setIssuer(addr.getURI().toString());
                }
            } else if (samlToken.getIssuerName() != null) {
                key.setIssuer(samlToken.getIssuerName().getIssuerName());
            }
            if (samlToken.getClaims() != null) {
                key.setClaims(samlToken.getClaims().getClaimsAsBytes());
            }
            return key;
        }
        if (PolicyUtil.isIssuedToken((PolicyAssertion)((Object)token), spVersion)) {
            IssuedTokenKeyBinding key = new IssuedTokenKeyBinding();
            this.setTokenInclusion(key, token);
            key.setUUID(token.getTokenId());
            key.setSTRID(token.getTokenId());
            IssuedToken it = (IssuedToken)token;
            if (it.getIssuer() != null) {
                Address addr = it.getIssuer().getAddress();
                if (addr != null) {
                    key.setIssuer(addr.getURI().toString());
                }
            } else if (it.getIssuerName() != null) {
                key.setIssuer(it.getIssuerName().getIssuerName());
            }
            if (it.getClaims() != null) {
                key.setClaims(it.getClaims().getClaimsAsBytes());
            }
            return key;
        }
        if (PolicyUtil.isSecureConversationToken((PolicyAssertion)((Object)token), spVersion)) {
            SecureConversationTokenKeyBinding key = new SecureConversationTokenKeyBinding();
            this.setTokenInclusion(key, token);
            key.setUUID(token.getTokenId());
            SecureConversationToken sct = (SecureConversationToken)token;
            if (sct.getIssuer() != null) {
                Address addr = sct.getIssuer().getAddress();
                if (addr != null) {
                    key.setIssuer(addr.getURI().toString());
                }
            } else if (sct.getIssuerName() != null) {
                key.setIssuer(sct.getIssuerName().getIssuerName());
            }
            if (sct.getClaims() != null) {
                key.setClaims(sct.getClaims().getClaimsAsBytes());
            }
            return key;
        }
        if (PolicyUtil.isX509Token((PolicyAssertion)((Object)token), spVersion)) {
            AuthenticationTokenPolicy.X509CertificateBinding xt = new AuthenticationTokenPolicy.X509CertificateBinding();
            xt.setUUID(token.getTokenId());
            this.setTokenInclusion(xt, token);
            this.setX509TokenRefType(xt, (X509Token)token);
            X509Token x509Token = (X509Token)token;
            if (x509Token.getIssuer() != null) {
                Address addr = x509Token.getIssuer().getAddress();
                if (addr != null) {
                    xt.setIssuer(addr.getURI().toString());
                }
            } else if (x509Token.getIssuerName() != null) {
                xt.setIssuer(x509Token.getIssuerName().getIssuerName());
            }
            if (x509Token.getClaims() != null) {
                xt.setClaims(x509Token.getClaims().getClaimsAsBytes());
            }
            return xt;
        }
        if (PolicyUtil.isRsaToken((PolicyAssertion)((Object)token), spVersion) || PolicyUtil.isKeyValueToken((PolicyAssertion)((Object)token), spVersion)) {
            AuthenticationTokenPolicy.KeyValueTokenBinding rsaToken = new AuthenticationTokenPolicy.KeyValueTokenBinding();
            rsaToken.setUUID(token.getTokenId());
            this.setTokenInclusion(rsaToken, token);
            return rsaToken;
        }
        if (Constants.logger.isLoggable(Level.SEVERE)) {
            Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0107_UNKNOWN_TOKEN_TYPE(token));
        }
        throw new UnsupportedOperationException("Unsupported  " + token + "format");
    }

    public void setTokenValueType(AuthenticationTokenPolicy.X509CertificateBinding x509CB, PolicyAssertion tokenAssertion) {
        NestedPolicy policy = tokenAssertion.getNestedPolicy();
        if (policy == null) {
            return;
        }
        AssertionSet as = policy.getAssertionSet();
        for (PolicyAssertion policyAssertion : as) {
            if (policyAssertion.getName().getLocalPart().equals("WssX509V1Token11") || policyAssertion.getName().getLocalPart().equals("WssX509V1Token10")) {
                x509CB.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1");
                continue;
            }
            if (!policyAssertion.getName().getLocalPart().equals("WssX509V3Token10") && !policyAssertion.getName().getLocalPart().equals("WssX509V3Token11")) continue;
            x509CB.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        }
    }

    public void setTokenValueType(AuthenticationTokenPolicy.KerberosTokenBinding kerberosBinding, PolicyAssertion tokenAssertion) {
        NestedPolicy policy = tokenAssertion.getNestedPolicy();
        if (policy == null) {
            return;
        }
        AssertionSet as = policy.getAssertionSet();
        for (PolicyAssertion policyAssertion : as) {
            if (policyAssertion.getName().getLocalPart().equals("WssKerberosV5ApReqToken11")) {
                kerberosBinding.setValueType("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ");
                continue;
            }
            if (!policyAssertion.getName().getLocalPart().equals("WssGssKerberosV5ApReqToken11")) continue;
            kerberosBinding.setValueType("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ1510");
        }
    }

    void setTokenValueType(AuthenticationTokenPolicy.UsernameTokenBinding utb, PolicyAssertion tokenAssertion) {
        NestedPolicy policy = tokenAssertion.getNestedPolicy();
        if (policy == null) {
            return;
        }
        AssertionSet as = policy.getAssertionSet();
        for (PolicyAssertion policyAssertion : as) {
            if (policyAssertion.getName().getLocalPart().equals("WssUsernameToken10") || policyAssertion.getName().getLocalPart().equals("WssUsernameToken11")) {
                utb.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0");
                continue;
            }
            if (!policyAssertion.getName().getLocalPart().equals("WssUsernameToken10") && !policyAssertion.getName().getLocalPart().equals("WssUsernameToken11")) continue;
            utb.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0");
        }
    }
}

