/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.org.apache.xml.internal.security.utils.RFC2253Parser;
import com.sun.xml.wss.AliasSelector;
import com.sun.xml.wss.RealmAuthenticationAdapter;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.callback.CertStoreCallback;
import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import com.sun.xml.wss.impl.callback.DecryptionKeyCallback;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.callback.EncryptionKeyCallback;
import com.sun.xml.wss.impl.callback.KeyStoreCallback;
import com.sun.xml.wss.impl.callback.PasswordValidationCallback;
import com.sun.xml.wss.impl.callback.PrivateKeyCallback;
import com.sun.xml.wss.impl.callback.SAMLAssertionValidator;
import com.sun.xml.wss.impl.callback.SAMLCallback;
import com.sun.xml.wss.impl.callback.SAMLValidator;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureVerificationKeyCallback;
import com.sun.xml.wss.impl.callback.TimestampValidationCallback;
import com.sun.xml.wss.impl.callback.UsernameCallback;
import com.sun.xml.wss.impl.callback.ValidatorExtension;
import com.sun.xml.wss.impl.callback.XWSSCallback;
import com.sun.xml.wss.impl.misc.DigestCertSelector;
import com.sun.xml.wss.impl.misc.IssuerNameAndSerialCertSelector;
import com.sun.xml.wss.impl.misc.KeyIdentifierCertSelector;
import com.sun.xml.wss.impl.misc.PublicKeyCertSelector;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.PrivateKeyBinding;
import com.sun.xml.wss.util.XWSSUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.w3c.dom.Element;

public class DefaultCallbackHandler
implements CallbackHandler {
    public static final String KEYSTORE_URL = "keystore.url";
    public static final String KEYSTORE_TYPE = "keystore.type";
    public static final String KEYSTORE_PASSWORD = "keystore.password";
    public static final String KEY_PASSWORD = "key.password";
    public static final String MY_ALIAS = "my.alias";
    public static final String MY_USERNAME = "my.username";
    public static final String MY_PASSWORD = "my.password";
    public static final String MY_ITERATIONS = "my.iterations";
    public static final String TRUSTSTORE_URL = "truststore.url";
    public static final String TRUSTSTORE_TYPE = "truststore.type";
    public static final String TRUSTSTORE_PASSWORD = "truststore.password";
    public static final String PEER_ENTITY_ALIAS = "peerentity.alias";
    public static final String STS_ALIAS = "sts.alias";
    public static final String SERVICE_ALIAS = "service.alias";
    public static final String USERNAME_CBH = "username.callback.handler";
    public static final String PASSWORD_CBH = "password.callback.handler";
    public static final String SAML_CBH = "saml.callback.handler";
    public static final String KEYSTORE_CBH = "keystore.callback.handler";
    public static final String TRUSTSTORE_CBH = "truststore.callback.handler";
    public static final String USERNAME_VALIDATOR = "username.validator";
    public static final String SAML_VALIDATOR = "saml.validator";
    public static final String TIMESTAMP_VALIDATOR = "timestamp.validator";
    public static final String CERTIFICATE_VALIDATOR = "certificate.validator";
    public static final String MAX_CLOCK_SKEW_PROPERTY = "max.clock.skew";
    public static final String MAX_NONCE_AGE_PROPERTY = "max.nonce.age";
    public static final String TIMESTAMP_FRESHNESS_LIMIT_PROPERTY = "timestamp.freshness.limit";
    public static final String REVOCATION_ENABLED = "revocation.enabled";
    public static final String CERTSTORE_CBH = "certstore.cbh";
    public static final String CERTSTORE_CERTSELECTOR = "certstore.certselector";
    public static final String CERTSTORE_CRLSELECTOR = "certstore.crlselector";
    public static final String KEYSTORE_CERTSELECTOR = "keystore.certselector";
    public static final String TRUSTSTORE_CERTSELECTOR = "truststore.certselector";
    public static final String JMAC_CALLBACK_HANDLER = "jmac.callbackhandler";
    public static final String KRB5_LOGIN_MODULE = "krb5.login.module";
    public static final String KRB5_SERVICE_PRINCIPAL = "krb5.service.principal";
    public static final String KRB5_CREDENTIAL_DELEGATION = "krb5.credential.delegation";
    public static final String USE_XWSS_CALLBACKS = "user.xwss.callbacks";
    public static final String JAAS_KEYSTORE_LOGIN_MODULE = "jaas.loginmodule.for.keystore";
    private String keyStoreURL;
    private String keyStorePassword;
    private String keyStoreType;
    private String myAlias;
    private String keyPwd;
    private char[] keyPassword = null;
    private String trustStoreURL;
    private String trustStorePassword;
    private String trustStoreType;
    private String peerEntityAlias;
    private String certStoreCBHClassName;
    private String certSelectorClassName;
    private String crlSelectorClassName;
    private String keystoreCertSelectorClassName;
    private String truststoreCertSelectorClassName;
    private String myUsername;
    private String myPassword;
    private KeyStore keyStore;
    private KeyStore trustStore;
    private Class usernameCbHandler;
    private Class passwordCbHandler;
    private Class samlCbHandler;
    private Class keystoreCbHandler;
    private Class truststoreCbHandler;
    private Class certstoreCbHandler;
    private Class certSelectorClass;
    private Class crlSelectorClass;
    private Class usernameValidator;
    private Class timestampValidator;
    private Class samlValidator;
    private Class certificateValidator;
    protected long maxClockSkewG;
    protected long timestampFreshnessLimitG;
    protected long maxNonceAge;
    protected String revocationEnabledAttr;
    protected boolean revocationEnabled = false;
    protected String mcs = null;
    protected String tfl = null;
    protected String mna = null;
    private static Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl.misc", "com.sun.xml.wss.logging.impl.misc.LogStrings");
    private static final String fileSeparator = System.getProperty("file.separator");
    private static final UnsupportedCallbackException unsupported = new UnsupportedCallbackException(null, "Unsupported Callback Type Encountered");
    private static final URI ISSUE_REQUEST_URI = URI.create("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue");
    private CallbackHandler usernameHandler;
    private CallbackHandler passwordHandler;
    private CallbackHandler samlHandler;
    private CallbackHandler certstoreHandler;
    private CallbackHandler keystoreHandler;
    private CallbackHandler truststoreHandler;
    private PasswordValidationCallback.PasswordValidator pwValidator;
    private TimestampValidationCallback.TimestampValidator tsValidator;
    private CertificateValidationCallback.CertificateValidator certValidator;
    private SAMLAssertionValidator sValidator;
    private CertificateValidationCallback.CertificateValidator defaultCertValidator;
    private TimestampValidationCallback.TimestampValidator defaultTSValidator;
    private RealmAuthenticationAdapter usernameAuthenticator = null;
    private RealmAuthenticationAdapter defRealmAuthenticator = null;
    private CertStore certStore = null;
    private Class keystoreCertSelectorClass;
    private Class truststoreCertSelectorClass;
    private String useXWSSCallbacksStr;
    private boolean useXWSSCallbacks;

    public DefaultCallbackHandler(String clientOrServer, Properties assertions) throws XWSSecurityException {
        Properties properties = null;
        if (assertions != null && !assertions.isEmpty()) {
            properties = assertions;
        } else {
            properties = new Properties();
            String resource = clientOrServer + "-security-env.properties";
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            if (in != null) {
                try {
                    properties.load(in);
                }
                catch (IOException ex) {
                    throw new XWSSecurityException(ex);
                }
            }
        }
        this.keyStoreURL = properties.getProperty(KEYSTORE_URL);
        this.keyStoreURL = this.resolveHome(this.keyStoreURL);
        this.keyStoreType = properties.getProperty(KEYSTORE_TYPE);
        this.keyStorePassword = properties.getProperty(KEYSTORE_PASSWORD);
        this.keyPwd = properties.getProperty(KEY_PASSWORD);
        this.myAlias = properties.getProperty(MY_ALIAS);
        this.myUsername = properties.getProperty(MY_USERNAME);
        this.myPassword = properties.getProperty(MY_PASSWORD);
        this.trustStoreURL = properties.getProperty(TRUSTSTORE_URL);
        this.trustStoreURL = this.resolveHome(this.trustStoreURL);
        this.keyStoreType = properties.getProperty(KEYSTORE_TYPE);
        this.trustStoreType = properties.getProperty(TRUSTSTORE_TYPE);
        this.trustStorePassword = properties.getProperty(TRUSTSTORE_PASSWORD);
        this.peerEntityAlias = properties.getProperty(PEER_ENTITY_ALIAS);
        this.certStoreCBHClassName = properties.getProperty(CERTSTORE_CBH);
        this.certSelectorClassName = properties.getProperty(CERTSTORE_CERTSELECTOR);
        this.crlSelectorClassName = properties.getProperty(CERTSTORE_CRLSELECTOR);
        this.keystoreCertSelectorClassName = properties.getProperty(KEYSTORE_CERTSELECTOR);
        this.truststoreCertSelectorClassName = properties.getProperty(TRUSTSTORE_CERTSELECTOR);
        String uCBH = properties.getProperty(USERNAME_CBH);
        String pCBH = properties.getProperty(PASSWORD_CBH);
        String sCBH = properties.getProperty(SAML_CBH);
        String keystoreCBH = properties.getProperty(KEYSTORE_CBH);
        String truststoreCBH = properties.getProperty(TRUSTSTORE_CBH);
        String uV = properties.getProperty(USERNAME_VALIDATOR);
        String sV = properties.getProperty(SAML_VALIDATOR);
        String tV = properties.getProperty(TIMESTAMP_VALIDATOR);
        String cV = properties.getProperty(CERTIFICATE_VALIDATOR);
        this.usernameCbHandler = this.loadClass(uCBH);
        this.passwordCbHandler = this.loadClass(pCBH);
        this.samlCbHandler = this.loadClass(sCBH);
        this.keystoreCbHandler = this.loadClass(keystoreCBH);
        this.truststoreCbHandler = this.loadClass(truststoreCBH);
        this.usernameValidator = this.loadClass(uV);
        this.samlValidator = this.loadClass(sV);
        this.timestampValidator = this.loadClass(tV);
        this.certificateValidator = this.loadClass(cV);
        this.keystoreCertSelectorClass = this.loadClass(this.keystoreCertSelectorClassName);
        this.truststoreCertSelectorClass = this.loadClass(this.truststoreCertSelectorClassName);
        this.certstoreCbHandler = this.loadClass(this.certStoreCBHClassName);
        this.certSelectorClass = this.loadClass(this.certSelectorClassName);
        this.crlSelectorClass = this.loadClass(this.crlSelectorClassName);
        this.mcs = properties.getProperty(MAX_CLOCK_SKEW_PROPERTY);
        this.tfl = properties.getProperty(TIMESTAMP_FRESHNESS_LIMIT_PROPERTY);
        this.mna = properties.getProperty(MAX_NONCE_AGE_PROPERTY);
        this.revocationEnabledAttr = properties.getProperty(REVOCATION_ENABLED);
        if (this.revocationEnabledAttr != null) {
            this.revocationEnabled = Boolean.parseBoolean(this.revocationEnabledAttr);
        }
        this.useXWSSCallbacksStr = properties.getProperty(USE_XWSS_CALLBACKS);
        if (this.useXWSSCallbacksStr != null) {
            this.useXWSSCallbacks = Boolean.parseBoolean(this.useXWSSCallbacksStr);
        }
        this.maxClockSkewG = this.toLong(this.mcs);
        this.timestampFreshnessLimitG = this.toLong(this.tfl);
        this.maxNonceAge = this.toLong(this.mna);
        this.initTrustStore();
        this.initKeyStore();
        this.initNewInstances();
        this.defaultCertValidator = new X509CertificateValidatorImpl();
        this.defaultTSValidator = new DefaultTimestampValidator();
    }

    public DefaultCallbackHandler(String clientOrServer, Properties assertions, RealmAuthenticationAdapter adapter) throws Exception {
        this(clientOrServer, assertions);
        this.usernameAuthenticator = adapter;
        if (adapter == null) {
            this.defRealmAuthenticator = RealmAuthenticationAdapter.newInstance(null);
        }
    }

    private void handleUsernameCallback(UsernameCallback cb) throws IOException, UnsupportedCallbackException {
        if (this.myUsername != null) {
            cb.setUsername(this.myUsername);
        } else {
            String username = (String)cb.getRuntimeProperties().get("username");
            if (username == null) {
                username = (String)cb.getRuntimeProperties().get("javax.xml.ws.security.auth.username");
            }
            if (username != null) {
                cb.setUsername(username);
            } else if (this.usernameHandler != null) {
                Callback[] cbs = null;
                if (this.useXWSSCallbacks) {
                    cbs = new Callback[]{cb};
                    this.usernameHandler.handle(cbs);
                } else {
                    NameCallback nc = new NameCallback("Username=");
                    cbs = new Callback[]{nc};
                    this.usernameHandler.handle(cbs);
                    cb.setUsername(((NameCallback)cbs[0]).getName());
                }
            } else {
                log.log(Level.SEVERE, "WSS1500.invalid.usernameHandler");
                throw new UnsupportedCallbackException(null, "Username Handler Not Configured");
            }
        }
    }

    private void handlePasswordCallback(com.sun.xml.wss.impl.callback.PasswordCallback cb) throws IOException, UnsupportedCallbackException {
        if (this.myPassword != null) {
            cb.setPassword(this.myPassword);
        } else {
            String password = (String)cb.getRuntimeProperties().get("password");
            if (password == null) {
                password = (String)cb.getRuntimeProperties().get("javax.xml.ws.security.auth.password");
            }
            if (password != null) {
                cb.setPassword(password);
            } else if (this.passwordHandler != null) {
                Callback[] cbs = null;
                if (this.useXWSSCallbacks) {
                    cbs = new Callback[]{cb};
                    this.passwordHandler.handle(cbs);
                } else {
                    PasswordCallback pc = new PasswordCallback("Password=", false);
                    cbs = new Callback[]{pc};
                    this.passwordHandler.handle(cbs);
                    char[] pass = ((PasswordCallback)cbs[0]).getPassword();
                    cb.setPassword(new String(pass));
                }
            } else {
                log.log(Level.SEVERE, "WSS1525.invalid.passwordHandler");
                throw new UnsupportedCallbackException(null, "Password Handler Not Configured");
            }
        }
    }

    private void handlePasswordValidation(PasswordValidationCallback cb) throws IOException, UnsupportedCallbackException {
        if (cb.getRequest() instanceof PasswordValidationCallback.PlainTextPasswordRequest) {
            if (this.pwValidator != null) {
                cb.setValidator(this.pwValidator);
            } else if (this.usernameAuthenticator != null) {
                cb.setRealmAuthentcationAdapter(this.usernameAuthenticator);
            } else {
                cb.setRealmAuthentcationAdapter(this.defRealmAuthenticator);
            }
        } else if (cb.getRequest() instanceof PasswordValidationCallback.DigestPasswordRequest) {
            PasswordValidationCallback.DigestPasswordRequest request = (PasswordValidationCallback.DigestPasswordRequest)cb.getRequest();
            if (this.pwValidator != null && this.pwValidator instanceof PasswordValidationCallback.WsitDigestPasswordValidator) {
                ((PasswordValidationCallback.WsitDigestPasswordValidator)this.pwValidator).setPassword(request);
                cb.setValidator(this.pwValidator);
            }
        } else if (cb.getRequest() instanceof PasswordValidationCallback.DerivedKeyPasswordRequest) {
            PasswordValidationCallback.DerivedKeyPasswordRequest request = (PasswordValidationCallback.DerivedKeyPasswordRequest)cb.getRequest();
            if (this.pwValidator != null && this.pwValidator instanceof PasswordValidationCallback.DerivedKeyPasswordValidator) {
                ((PasswordValidationCallback.DerivedKeyPasswordValidator)this.pwValidator).setPassword(request);
                cb.setValidator(this.pwValidator);
            }
        } else {
            log.log(Level.SEVERE, "WSS1503.unsupported.requesttype");
            throw new UnsupportedCallbackException(null, "Unsupported Request Type for Password Validation");
        }
    }

    private void handleTimestampValidation(TimestampValidationCallback cb) throws IOException, UnsupportedCallbackException {
        if (this.tsValidator != null) {
            cb.setValidator(this.tsValidator);
        } else {
            cb.setValidator(this.defaultTSValidator);
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            PrivateKey privKey;
            String alias;
            X509Certificate cert;
            Object request;
            XWSSCallback cb;
            if (callbacks[i] instanceof UsernameCallback) {
                cb = (UsernameCallback)callbacks[i];
                this.handleUsernameCallback((UsernameCallback)cb);
                continue;
            }
            if (callbacks[i] instanceof com.sun.xml.wss.impl.callback.PasswordCallback) {
                cb = (com.sun.xml.wss.impl.callback.PasswordCallback)callbacks[i];
                this.handlePasswordCallback((com.sun.xml.wss.impl.callback.PasswordCallback)cb);
                continue;
            }
            if (callbacks[i] instanceof PasswordValidationCallback) {
                cb = (PasswordValidationCallback)callbacks[i];
                this.handlePasswordValidation((PasswordValidationCallback)cb);
                continue;
            }
            if (callbacks[i] instanceof TimestampValidationCallback) {
                cb = (TimestampValidationCallback)callbacks[i];
                this.handleTimestampValidation((TimestampValidationCallback)cb);
                continue;
            }
            if (callbacks[i] instanceof SignatureVerificationKeyCallback) {
                cb = (SignatureVerificationKeyCallback)callbacks[i];
                if (((SignatureVerificationKeyCallback)cb).getRequest() instanceof SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest) {
                    request = (SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest)((SignatureVerificationKeyCallback)cb).getRequest();
                    cert = this.getCertificateFromTrustStore(((SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest)request).getSubjectKeyIdentifier(), cb.getRuntimeProperties());
                    ((SignatureVerificationKeyCallback.X509CertificateRequest)request).setX509Certificate(cert);
                    continue;
                }
                if (((SignatureVerificationKeyCallback)cb).getRequest() instanceof SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest) {
                    request = (SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest)((SignatureVerificationKeyCallback)cb).getRequest();
                    cert = this.getCertificateFromTrustStore(((SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest)request).getIssuerName(), ((SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest)request).getSerialNumber(), cb.getRuntimeProperties());
                    ((SignatureVerificationKeyCallback.X509CertificateRequest)request).setX509Certificate(cert);
                    continue;
                }
                if (((SignatureVerificationKeyCallback)cb).getRequest() instanceof SignatureVerificationKeyCallback.ThumbprintBasedRequest) {
                    request = (SignatureVerificationKeyCallback.ThumbprintBasedRequest)((SignatureVerificationKeyCallback)cb).getRequest();
                    cert = this.getCertificateFromTrustStoreForThumbprint(((SignatureVerificationKeyCallback.ThumbprintBasedRequest)request).getThumbprintIdentifier(), cb.getRuntimeProperties());
                    ((SignatureVerificationKeyCallback.X509CertificateRequest)request).setX509Certificate(cert);
                    continue;
                }
                if (((SignatureVerificationKeyCallback)cb).getRequest() instanceof SignatureVerificationKeyCallback.PublicKeyBasedRequest) {
                    request = (SignatureVerificationKeyCallback.PublicKeyBasedRequest)((SignatureVerificationKeyCallback)cb).getRequest();
                    cert = this.getCertificateFromTrustStoreForSAML(((SignatureVerificationKeyCallback.PublicKeyBasedRequest)request).getPublicKey(), cb.getRuntimeProperties());
                    ((SignatureVerificationKeyCallback.X509CertificateRequest)request).setX509Certificate(cert);
                    continue;
                }
                log.log(Level.SEVERE, "WSS1504.unsupported.callbackType");
                throw unsupported;
            }
            if (callbacks[i] instanceof SignatureKeyCallback) {
                cb = (SignatureKeyCallback)callbacks[i];
                if (((SignatureKeyCallback)cb).getRequest() instanceof SignatureKeyCallback.DefaultPrivKeyCertRequest) {
                    request = (SignatureKeyCallback.DefaultPrivKeyCertRequest)((SignatureKeyCallback)cb).getRequest();
                    this.getDefaultPrivKeyCert((SignatureKeyCallback.DefaultPrivKeyCertRequest)request, cb.getRuntimeProperties());
                    continue;
                }
                if (((SignatureKeyCallback)cb).getRequest() instanceof SignatureKeyCallback.AliasPrivKeyCertRequest) {
                    request = (SignatureKeyCallback.AliasPrivKeyCertRequest)((SignatureKeyCallback)cb).getRequest();
                    alias = ((SignatureKeyCallback.AliasPrivKeyCertRequest)request).getAlias();
                    try {
                        X509Certificate cert2 = (X509Certificate)this.keyStore.getCertificate(alias);
                        ((SignatureKeyCallback.PrivKeyCertRequest)request).setX509Certificate(cert2);
                        privKey = this.getPrivateKey(cb.getRuntimeProperties(), alias);
                        ((SignatureKeyCallback.PrivKeyCertRequest)request).setPrivateKey(privKey);
                        continue;
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "WSS1505.failedto.getkey", e);
                        throw new RuntimeException(e);
                    }
                }
                log.log(Level.SEVERE, "WSS1504.unsupported.callbackType");
                throw unsupported;
            }
            if (callbacks[i] instanceof DecryptionKeyCallback) {
                PrivateKey privKey2;
                byte[] ski;
                cb = (DecryptionKeyCallback)callbacks[i];
                if (((DecryptionKeyCallback)cb).getRequest() instanceof DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest) {
                    request = (DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest)((DecryptionKeyCallback)cb).getRequest();
                    ski = ((DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest)request).getSubjectKeyIdentifier();
                    privKey2 = this.getPrivateKey(ski, (Map)cb.getRuntimeProperties());
                    ((DecryptionKeyCallback.PrivateKeyRequest)request).setPrivateKey(privKey2);
                    continue;
                }
                if (((DecryptionKeyCallback)cb).getRequest() instanceof DecryptionKeyCallback.X509IssuerSerialBasedRequest) {
                    request = (DecryptionKeyCallback.X509IssuerSerialBasedRequest)((DecryptionKeyCallback)cb).getRequest();
                    String issuerName = ((DecryptionKeyCallback.X509IssuerSerialBasedRequest)request).getIssuerName();
                    BigInteger serialNumber = ((DecryptionKeyCallback.X509IssuerSerialBasedRequest)request).getSerialNumber();
                    privKey = this.getPrivateKey(issuerName, serialNumber, cb.getRuntimeProperties());
                    ((DecryptionKeyCallback.PrivateKeyRequest)request).setPrivateKey(privKey);
                    continue;
                }
                if (((DecryptionKeyCallback)cb).getRequest() instanceof DecryptionKeyCallback.X509CertificateBasedRequest) {
                    request = (DecryptionKeyCallback.X509CertificateBasedRequest)((DecryptionKeyCallback)cb).getRequest();
                    cert = ((DecryptionKeyCallback.X509CertificateBasedRequest)request).getX509Certificate();
                    privKey2 = this.getPrivateKey(cert, (Map)cb.getRuntimeProperties());
                    ((DecryptionKeyCallback.PrivateKeyRequest)request).setPrivateKey(privKey2);
                    continue;
                }
                if (((DecryptionKeyCallback)cb).getRequest() instanceof DecryptionKeyCallback.ThumbprintBasedRequest) {
                    request = (DecryptionKeyCallback.ThumbprintBasedRequest)((DecryptionKeyCallback)cb).getRequest();
                    ski = ((DecryptionKeyCallback.ThumbprintBasedRequest)request).getThumbprintIdentifier();
                    privKey2 = this.getPrivateKeyForThumbprint(ski, cb.getRuntimeProperties());
                    ((DecryptionKeyCallback.PrivateKeyRequest)request).setPrivateKey(privKey2);
                    continue;
                }
                if (((DecryptionKeyCallback)cb).getRequest() instanceof DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest) {
                    request = (DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest)((DecryptionKeyCallback)cb).getRequest();
                    PrivateKey privKey3 = this.getPrivateKeyFromKeyStore(((DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest)request).getPublicKey(), cb.getRuntimeProperties());
                    ((DecryptionKeyCallback.PrivateKeyRequest)request).setPrivateKey(privKey3);
                    continue;
                }
                log.log(Level.SEVERE, "WSS1504.unsupported.callbackType");
                throw unsupported;
            }
            if (callbacks[i] instanceof EncryptionKeyCallback) {
                cb = (EncryptionKeyCallback)callbacks[i];
                if (((EncryptionKeyCallback)cb).getRequest() instanceof EncryptionKeyCallback.AliasX509CertificateRequest) {
                    request = (EncryptionKeyCallback.AliasX509CertificateRequest)((EncryptionKeyCallback)cb).getRequest();
                    alias = ((EncryptionKeyCallback.AliasX509CertificateRequest)request).getAlias();
                    if ("".equals(alias) || alias == null) {
                        this.getDefaultCertificateFromTrustStore(cb.getRuntimeProperties(), (EncryptionKeyCallback.AliasX509CertificateRequest)request);
                        continue;
                    }
                    try {
                        KeyStore tStore = this.getTrustStore(cb.getRuntimeProperties());
                        if (tStore == null) continue;
                        X509Certificate cert3 = (X509Certificate)tStore.getCertificate(alias);
                        ((EncryptionKeyCallback.X509CertificateRequest)request).setX509Certificate(cert3);
                        continue;
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "WSS1526.failedto.getcertificate", e);
                        throw new RuntimeException(e);
                    }
                }
                if (((EncryptionKeyCallback)cb).getRequest() instanceof EncryptionKeyCallback.PublicKeyBasedRequest) {
                    request = (EncryptionKeyCallback.PublicKeyBasedRequest)((EncryptionKeyCallback)cb).getRequest();
                    try {
                        cert = this.getCertificateFromTrustStoreForSAML(((EncryptionKeyCallback.PublicKeyBasedRequest)request).getPublicKey(), cb.getRuntimeProperties());
                        ((EncryptionKeyCallback.X509CertificateRequest)request).setX509Certificate(cert);
                        continue;
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "WSS1526.failedto.getcertificate", e);
                        throw new RuntimeException(e);
                    }
                }
                if (!(((EncryptionKeyCallback)cb).getRequest() instanceof EncryptionKeyCallback.AliasSymmetricKeyRequest)) continue;
                log.log(Level.SEVERE, "WSS1504.unsupported.callbackType");
                throw unsupported;
            }
            if (callbacks[i] instanceof CertificateValidationCallback) {
                cb = (CertificateValidationCallback)callbacks[i];
                this.getTrustStore(cb.getRuntimeProperties());
                ((CertificateValidationCallback)cb).setValidator(this.certValidator);
                continue;
            }
            if (callbacks[i] instanceof DynamicPolicyCallback) {
                DynamicPolicyCallback dp = (DynamicPolicyCallback)callbacks[i];
                SecurityPolicy policy = dp.getSecurityPolicy();
                if (!(policy instanceof AuthenticationTokenPolicy.SAMLAssertionBinding)) continue;
                AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)((AuthenticationTokenPolicy.SAMLAssertionBinding)policy).clone();
                if (samlBinding.getAssertion() == null && samlBinding.getAuthorityBinding() == null && samlBinding.getAssertionReader() == null) {
                    this.populateAssertion(samlBinding, dp);
                    continue;
                }
                if (samlBinding.getAssertion() != null || samlBinding.getAssertionReader() != null) {
                    Subject subj = (Subject)dp.getRuntimeProperties().get("javax.security.auth.Subject");
                    this.validateSAMLAssertion(samlBinding, subj, dp.getRuntimeProperties());
                    continue;
                }
                if (samlBinding.getAuthorityBinding() != null && samlBinding.getAssertionId() != null) {
                    this.locateSAMLAssertion(samlBinding, dp.getRuntimeProperties());
                    continue;
                }
                log.log(Level.SEVERE, "WSS1506.invalid.SAMLPolicy");
                throw new UnsupportedCallbackException(null, "SAML Assertion not present in the Policy");
            }
            log.log(Level.SEVERE, "WSS1504.unsupported.callbackType");
            throw unsupported;
        }
    }

    private boolean isMyCert(X509Certificate certificate, Map runtimeProps) {
        try {
            SignatureKeyCallback.DefaultPrivKeyCertRequest request = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
            this.getDefaultPrivKeyCert(request, runtimeProps);
            X509Certificate cert = request.getX509Certificate();
            if (cert != null && cert.equals(certificate)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void populateAssertion(AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding, DynamicPolicyCallback dp) throws IOException, UnsupportedCallbackException {
        if ("SV".equals(samlBinding.getAssertionType())) {
            if (this.samlHandler != null) {
                SAMLCallback sc = new SAMLCallback();
                SecurityUtil.copy(sc.getRuntimeProperties(), dp.getRuntimeProperties());
                sc.setConfirmationMethod("SV-Assertion");
                sc.setSAMLVersion(samlBinding.getSAMLVersion());
                Callback[] cbs = new Callback[]{sc};
                this.samlHandler.handle(cbs);
                samlBinding.setAssertion(sc.getAssertionElement());
                samlBinding.setAssertion(sc.getAssertionReader());
                samlBinding.setAuthorityBinding(sc.getAuthorityBindingElement());
                dp.setSecurityPolicy(samlBinding);
                samlBinding.setAssertionId(sc.getAssertionId());
                samlBinding.setSAMLVersion(sc.getSAMLVersion());
                return;
            }
            log.log(Level.SEVERE, "WSS1507.no.SAMLCallbackHandler");
            throw new UnsupportedCallbackException(null, "A Required SAML Callback Handler was not specified in configuration : Cannot Populate SAML Assertion");
        }
        if (this.samlHandler != null) {
            SAMLCallback sc = new SAMLCallback();
            SecurityUtil.copy(sc.getRuntimeProperties(), dp.getRuntimeProperties());
            sc.setConfirmationMethod("HOK-Assertion");
            sc.setSAMLVersion(samlBinding.getSAMLVersion());
            Callback[] cbs = new Callback[]{sc};
            this.samlHandler.handle(cbs);
            samlBinding.setAssertion(sc.getAssertionElement());
            samlBinding.setAssertion(sc.getAssertionReader());
            samlBinding.setAuthorityBinding(sc.getAuthorityBindingElement());
            samlBinding.setAssertionId(sc.getAssertionId());
            samlBinding.setSAMLVersion(sc.getSAMLVersion());
            dp.setSecurityPolicy(samlBinding);
            PrivateKeyBinding pkBinding = (PrivateKeyBinding)samlBinding.newPrivateKeyBinding();
            SignatureKeyCallback.DefaultPrivKeyCertRequest request = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
            this.getDefaultPrivKeyCert(request, dp.getRuntimeProperties());
            pkBinding.setPrivateKey(request.getPrivateKey());
            return;
        }
        log.log(Level.SEVERE, "WSS1507.no.SAMLCallbackHandler");
        throw new UnsupportedCallbackException(null, "A Required SAML Callback Handler was not specified in configuration : Cannot Populate SAML Assertion");
    }

    private void validateSAMLAssertion(AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding, Subject subj, Map props) throws IOException, UnsupportedCallbackException {
        if (this.sValidator != null) {
            try {
                if (this.sValidator instanceof ValidatorExtension) {
                    ((ValidatorExtension)((Object)this.sValidator)).setRuntimeProperties(props);
                }
                if (samlBinding.getAssertion() != null) {
                    if (this.sValidator instanceof SAMLValidator) {
                        ((SAMLValidator)this.sValidator).validate(samlBinding.getAssertion(), props, subj);
                    } else {
                        this.sValidator.validate(samlBinding.getAssertion());
                    }
                } else if (samlBinding.getAssertionReader() != null) {
                    if (this.sValidator instanceof SAMLValidator) {
                        ((SAMLValidator)this.sValidator).validate(samlBinding.getAssertionReader(), props, subj);
                    } else {
                        this.sValidator.validate(samlBinding.getAssertionReader());
                    }
                }
            }
            catch (SAMLAssertionValidator.SAMLValidationException e) {
                log.log(Level.SEVERE, "WSS1508.failed.validateSAMLAssertion", e);
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void locateSAMLAssertion(AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding, Map context) throws IOException, UnsupportedCallbackException {
        Element binding = samlBinding.getAuthorityBinding();
        String assertionId = samlBinding.getAssertionId();
        if ("SV".equals(samlBinding.getAssertionType())) {
            if (this.samlHandler != null) {
                SAMLCallback sc = new SAMLCallback();
                sc.setConfirmationMethod("SV-Assertion");
                sc.setSAMLVersion(samlBinding.getSAMLVersion());
                sc.setAssertionId(assertionId);
                sc.setAuthorityBindingElement(binding);
                Callback[] cbs = new Callback[]{sc};
                this.samlHandler.handle(cbs);
                samlBinding.setAssertion(sc.getAssertionElement());
                samlBinding.setAssertion(sc.getAssertionReader());
                samlBinding.setSAMLVersion(sc.getSAMLVersion());
                return;
            }
            log.log(Level.SEVERE, "WSS1507.no.SAMLCallbackHandler");
            throw new UnsupportedCallbackException(null, "A Required SAML Callback Handler was not specified in configuration : Cannot Populate SAML Assertion");
        }
        if (this.samlHandler != null) {
            SAMLCallback sc = new SAMLCallback();
            sc.setConfirmationMethod("HOK-Assertion");
            sc.setSAMLVersion(samlBinding.getSAMLVersion());
            sc.setAssertionId(assertionId);
            sc.setAuthorityBindingElement(binding);
            Callback[] cbs = new Callback[]{sc};
            this.samlHandler.handle(cbs);
            samlBinding.setAssertion(sc.getAssertionElement());
            samlBinding.setAssertion(sc.getAssertionReader());
            samlBinding.setSAMLVersion(sc.getSAMLVersion());
            PrivateKeyBinding pkBinding = (PrivateKeyBinding)samlBinding.newPrivateKeyBinding();
            SignatureKeyCallback.DefaultPrivKeyCertRequest request = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
            this.getDefaultPrivKeyCert(request, context);
            pkBinding.setPrivateKey(request.getPrivateKey());
            return;
        }
        log.log(Level.SEVERE, "WSS1507.no.SAMLCallbackHandler");
        throw new UnsupportedCallbackException(null, "A Required SAML Callback Handler was not specified in configuration : Cannot Populate SAML Assertion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTrustStore() throws XWSSecurityException {
        try {
            if (this.trustStoreURL == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Got NULL for TrustStore URL");
                }
                return;
            }
            if (this.trustStorePassword == null && log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Got NULL for TrustStore Password");
            }
            char[] trustStorePasswordChars = null;
            Class cbh = this.loadClassSilent(this.trustStorePassword);
            if (cbh != null) {
                CallbackHandler hdlr = (CallbackHandler)cbh.newInstance();
                PasswordCallback pc = new PasswordCallback("TrustStorePassword", false);
                Callback[] cbs = new Callback[]{pc};
                hdlr.handle(cbs);
                trustStorePasswordChars = ((PasswordCallback)cbs[0]).getPassword();
            } else {
                trustStorePasswordChars = this.trustStorePassword.toCharArray();
            }
            this.trustStore = KeyStore.getInstance(this.trustStoreType);
            InputStream is = null;
            URL tURL = SecurityUtil.loadFromClasspath("META-INF/" + this.trustStoreURL);
            try {
                is = tURL != null ? tURL.openStream() : new FileInputStream(this.trustStoreURL);
                this.trustStore.load(is, trustStorePasswordChars);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1509.failed.init.truststore", e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKeyStore() throws XWSSecurityException {
        try {
            if (this.keyStoreURL == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Got NULL for KeyStore URL");
                }
                return;
            }
            if (this.keyStorePassword == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Got NULL for KeyStore PASSWORD");
                }
                return;
            }
            char[] keyStorePasswordChars = null;
            Class cbh = this.loadClassSilent(this.keyStorePassword);
            if (cbh != null) {
                CallbackHandler hdlr = (CallbackHandler)cbh.newInstance();
                PasswordCallback pc = new PasswordCallback("KeyStorePassword", false);
                Callback[] cbs = new Callback[]{pc};
                hdlr.handle(cbs);
                keyStorePasswordChars = ((PasswordCallback)cbs[0]).getPassword();
            } else {
                keyStorePasswordChars = this.keyStorePassword.toCharArray();
            }
            if (this.keyPwd == null) {
                this.keyPassword = keyStorePasswordChars;
            } else {
                this.initKeyPassword();
            }
            this.keyStore = KeyStore.getInstance(this.keyStoreType);
            InputStream is = null;
            URL kURL = SecurityUtil.loadFromClasspath("META-INF/" + this.keyStoreURL);
            try {
                is = kURL != null ? kURL.openStream() : new FileInputStream(this.keyStoreURL);
                this.keyStore.load(is, keyStorePasswordChars);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1510.failed.init.keystore", e);
            throw new RuntimeException(e);
        }
    }

    private X509Certificate getCertificateFromTrustStore(byte[] ski, Map runtimeProps) throws IOException {
        try {
            Object obj;
            X509Certificate cert;
            if (runtimeProps != null && (cert = XWSSUtil.matchesProgrammaticInfo(obj = runtimeProps.get("server-certificate"), ski, "Identifier")) != null) {
                return cert;
            }
            if (this.getTrustStore(runtimeProps) == null && this.getCertStore(runtimeProps) == null) {
                return null;
            }
            if (this.trustStore != null) {
                Enumeration<String> aliases = this.trustStore.aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate x509Cert;
                    byte[] keyId;
                    String alias = aliases.nextElement();
                    Certificate cert2 = this.trustStore.getCertificate(alias);
                    if (cert2 == null || !"X.509".equals(cert2.getType()) || (keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(x509Cert = (X509Certificate)cert2)) == null || !Arrays.equals(ski, keyId)) continue;
                    return x509Cert;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1526.failedto.getcertificate", e);
            throw new RuntimeException(e);
        }
        if (this.certStore != null) {
            KeyIdentifierCertSelector selector = null;
            if (selector == null) {
                selector = new KeyIdentifierCertSelector(ski);
            }
            Collection<? extends Certificate> certs = null;
            try {
                certs = this.certStore.getCertificates(selector);
            }
            catch (CertStoreException ex) {
                log.log(Level.SEVERE, "WSS1530.exception.in.certstore.lookup", ex);
                throw new RuntimeException(ex);
            }
            if (certs.size() > 0) {
                return (X509Certificate)certs.iterator().next();
            }
        }
        return null;
    }

    private X509Certificate getCertificateFromTrustStore(String issuerName, BigInteger serialNumber, Map runtimeProps) throws IOException {
        try {
            Object obj;
            X509Certificate cert;
            if (runtimeProps != null && (cert = XWSSUtil.matchesProgrammaticInfo(obj = runtimeProps.get("server-certificate"), serialNumber, issuerName)) != null) {
                return cert;
            }
            if (this.getTrustStore(runtimeProps) == null && this.getCertStore(runtimeProps) == null) {
                return null;
            }
            if (this.certStore != null) {
                IssuerNameAndSerialCertSelector selector = null;
                if (selector == null) {
                    selector = new IssuerNameAndSerialCertSelector(serialNumber, issuerName);
                }
                Collection<? extends Certificate> certs = null;
                try {
                    certs = this.certStore.getCertificates(selector);
                }
                catch (CertStoreException ex) {
                    log.log(Level.SEVERE, "WSS1530.exception.in.certstore.lookup", ex);
                    throw new RuntimeException(ex);
                }
                if (certs.size() > 0) {
                    return (X509Certificate)certs.iterator().next();
                }
            }
            if (this.trustStore != null) {
                Enumeration<String> aliases = this.trustStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    Certificate cert2 = this.trustStore.getCertificate(alias);
                    if (cert2 == null || !"X.509".equals(cert2.getType())) continue;
                    X509Certificate x509Cert = (X509Certificate)cert2;
                    String thisIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                    BigInteger thisSerialNumber = x509Cert.getSerialNumber();
                    if (!thisIssuerName.equals(issuerName) || !thisSerialNumber.equals(serialNumber)) continue;
                    return x509Cert;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1526.failedto.getcertificate", e);
            throw new RuntimeException(e);
        }
        return null;
    }

    public PrivateKey getPrivateKey(byte[] ski, Map runtimeProps) throws IOException {
        try {
            Object obj;
            X509Certificate cert;
            if (runtimeProps != null && (cert = XWSSUtil.matchesProgrammaticInfo(obj = runtimeProps.get("certificate"), ski, "Identifier")) != null) {
                return XWSSUtil.getProgrammaticPrivateKey(runtimeProps);
            }
            if (this.getKeyStore(runtimeProps) == null) {
                return null;
            }
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                Certificate cert2;
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || (cert2 = this.keyStore.getCertificate(alias)) == null || !"X.509".equals(cert2.getType()) || (keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(x509Cert = (X509Certificate)cert2)) == null || !Arrays.equals(ski, keyId)) continue;
                return this.getPrivateKey(runtimeProps, alias);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1505.failedto.getkey", e);
            throw new RuntimeException(e);
        }
        return null;
    }

    public PrivateKey getPrivateKey(String issuerName, BigInteger serialNumber, Map runtimeProps) throws IOException {
        try {
            Object obj;
            X509Certificate cert;
            if (runtimeProps != null && (cert = XWSSUtil.matchesProgrammaticInfo(obj = runtimeProps.get("certificate"), serialNumber, issuerName)) != null) {
                return XWSSUtil.getProgrammaticPrivateKey(runtimeProps);
            }
            if (this.getKeyStore(runtimeProps) == null) {
                return null;
            }
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cert2;
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || (cert2 = this.keyStore.getCertificate(alias)) == null || !"X.509".equals(cert2.getType())) continue;
                X509Certificate x509Cert = (X509Certificate)cert2;
                String thisIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                BigInteger thisSerialNumber = x509Cert.getSerialNumber();
                if (!thisIssuerName.equals(issuerName) || !thisSerialNumber.equals(serialNumber)) continue;
                return this.getPrivateKey(runtimeProps, alias);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1505.failedto.getkey", e);
            throw new RuntimeException(e);
        }
        return null;
    }

    public PrivateKey getPrivateKey(X509Certificate certificate, Map runtimeProps) throws IOException {
        try {
            Object obj;
            if (runtimeProps != null && (obj = runtimeProps.get("certificate")) != null && obj.equals(certificate)) {
                return XWSSUtil.getProgrammaticPrivateKey(runtimeProps);
            }
            if (this.getKeyStore(runtimeProps) == null) {
                return null;
            }
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cert;
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || (cert = this.keyStore.getCertificate(alias)) == null || !cert.equals(certificate)) continue;
                return this.getPrivateKey(runtimeProps, alias);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1505.failedto.getkey", e);
            throw new RuntimeException(e);
        }
        return null;
    }

    private void getDefaultCertificateFromTrustStore(Map context, EncryptionKeyCallback.AliasX509CertificateRequest req) throws IOException {
        String currentAlias = null;
        Object obj = context.get("server-certificate");
        if (obj instanceof X509Certificate) {
            req.setX509Certificate((X509Certificate)obj);
            return;
        }
        if (this.peerEntityAlias != null) {
            currentAlias = this.peerEntityAlias;
        } else {
            CertSelector selector;
            this.getCertStore(context);
            if (this.certStore != null) {
                selector = null;
                if (this.certSelectorClass != null) {
                    selector = XWSSUtil.getCertSelector(this.certSelectorClass, context);
                }
                if (selector != null) {
                    Collection<? extends Certificate> certs = null;
                    try {
                        certs = this.certStore.getCertificates(selector);
                    }
                    catch (CertStoreException ex) {
                        log.log(Level.SEVERE, "WSS1526.failedto.getcertificate", ex);
                        throw new RuntimeException(ex);
                    }
                    if (certs.size() > 0) {
                        req.setX509Certificate((X509Certificate)certs.iterator().next());
                        return;
                    }
                }
            }
            if (this.getTrustStore(context) != null) {
                Enumeration<String> aliases;
                if (this.truststoreCertSelectorClass != null) {
                    selector = XWSSUtil.getCertSelector(this.truststoreCertSelectorClass, context);
                    if (selector != null) {
                        aliases = null;
                        try {
                            aliases = this.trustStore.aliases();
                        }
                        catch (KeyStoreException ex) {
                            log.log(Level.SEVERE, "WSS1526.failedto.getcertificate", ex);
                            throw new RuntimeException(ex);
                        }
                        while (aliases.hasMoreElements()) {
                            String currAlias = aliases.nextElement();
                            Certificate thisCertificate = null;
                            try {
                                thisCertificate = this.trustStore.getCertificate(currAlias);
                            }
                            catch (KeyStoreException ex) {
                                log.log(Level.SEVERE, "WSS1526.failedto.getcertificate", ex);
                                throw new RuntimeException(ex);
                            }
                            if (!(thisCertificate instanceof X509Certificate) || !selector.match(thisCertificate)) continue;
                            req.setX509Certificate((X509Certificate)thisCertificate);
                            return;
                        }
                    }
                } else {
                    X509Certificate cert = this.getDynamicCertificate(context);
                    if (cert != null) {
                        req.setX509Certificate(cert);
                        return;
                    }
                    aliases = null;
                    try {
                        aliases = this.trustStore.aliases();
                    }
                    catch (KeyStoreException ex) {
                        log.log(Level.SEVERE, "WSS1526.failedto.getcertificate", ex);
                        throw new RuntimeException(ex);
                    }
                    while (aliases.hasMoreElements()) {
                        currentAlias = aliases.nextElement();
                        if (!"certificate-authority".equals(currentAlias) && !"root".equals(currentAlias)) {
                            log.log(Level.WARNING, "truststore peeralias not found,picking up the arbitrary certificate ");
                            break;
                        }
                        currentAlias = null;
                    }
                }
            }
        }
        if (this.getTrustStore(context) != null && currentAlias != null) {
            X509Certificate thisCertificate = null;
            try {
                thisCertificate = (X509Certificate)this.trustStore.getCertificate(currentAlias);
            }
            catch (KeyStoreException ex) {
                log.log(Level.SEVERE, "WSS1526.failedto.getcertificate", ex);
                throw new RuntimeException(ex);
            }
            req.setX509Certificate(thisCertificate);
            return;
        }
        log.log(Level.SEVERE, "WSS1511.failed.locate.peerCertificate");
        throw new RuntimeException("An Error occurred while locating PEER Entity certificate in TrustStore");
    }

    private void getDefaultPrivKeyCert(SignatureKeyCallback.DefaultPrivKeyCertRequest request, Map context) throws IOException {
        Object obj = context.get("certificate");
        boolean foundCert = false;
        if (obj instanceof X509Certificate) {
            request.setX509Certificate((X509Certificate)obj);
            foundCert = true;
        }
        if ((obj = context.get("privatekey")) instanceof PrivateKey) {
            request.setPrivateKey((PrivateKey)obj);
            if (foundCert) {
                return;
            }
        }
        this.getKeyStore(context);
        String uniqueAlias = null;
        try {
            if (this.myAlias != null) {
                uniqueAlias = this.myAlias;
            } else {
                if (this.keystoreCertSelectorClass != null) {
                    AliasSelector selector = null;
                    try {
                        selector = (AliasSelector)this.keystoreCertSelectorClass.newInstance();
                    }
                    catch (IllegalAccessException ex) {
                        log.log(Level.SEVERE, "WSS1532.exception.instantiating.aliasselector", ex);
                        throw new RuntimeException(ex);
                    }
                    catch (InstantiationException ex) {
                        log.log(Level.SEVERE, "WSS1532.exception.instantiating.aliasselector", ex);
                        throw new RuntimeException(ex);
                    }
                    uniqueAlias = selector.select(context);
                }
                if (uniqueAlias == null) {
                    Enumeration<String> aliases = this.keyStore.aliases();
                    while (aliases.hasMoreElements()) {
                        Certificate thisCertificate;
                        String currentAlias = aliases.nextElement();
                        if (!this.keyStore.isKeyEntry(currentAlias) || (thisCertificate = this.keyStore.getCertificate(currentAlias)) == null || !(thisCertificate instanceof X509Certificate)) continue;
                        if (uniqueAlias == null) {
                            uniqueAlias = currentAlias;
                            continue;
                        }
                        uniqueAlias = null;
                        break;
                    }
                }
            }
            if (uniqueAlias == null) {
                log.log(Level.SEVERE, "WSS1512.failed.locate.certificate.privatekey");
                throw new RuntimeException("An Error occurred while locating default certificate and privateKey in KeyStore");
            }
            request.setX509Certificate((X509Certificate)this.keyStore.getCertificate(uniqueAlias));
            request.setPrivateKey(this.getPrivateKey(context, uniqueAlias));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1505.failedto.getkey", e);
            throw new RuntimeException(e);
        }
    }

    public void validateExpirationTime(Date expires, long maxClockSkew, long timestampFreshnessLimit) throws TimestampValidationCallback.TimestampValidationException {
        Date currentTime = DefaultCallbackHandler.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkew, false);
        if (expires.before(currentTime)) {
            log.log(Level.SEVERE, "WSS1514.error.aheadCurrentTime");
            throw new TimestampValidationCallback.TimestampValidationException("The current time is ahead of the expiration time in Timestamp");
        }
    }

    public void validateCreationTime(Date created, long maxClockSkew, long timestampFreshnessLimit) throws TimestampValidationCallback.TimestampValidationException {
        Date current = DefaultCallbackHandler.getFreshnessAndSkewAdjustedDate(maxClockSkew, timestampFreshnessLimit);
        if (created.before(current)) {
            log.log(Level.SEVERE, "WSS1515.error.currentTime");
            log.log(Level.SEVERE, "Creation time:" + created);
            log.log(Level.SEVERE, "Current time:" + current);
            throw new TimestampValidationCallback.TimestampValidationException("The creation time is older than  currenttime - timestamp-freshness-limit - max-clock-skew");
        }
        Date currentTime = DefaultCallbackHandler.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkew, true);
        if (currentTime.before(created)) {
            log.log(Level.SEVERE, "WSS1516.error.creationAheadCurrent.time");
            throw new TimestampValidationCallback.TimestampValidationException("The creation time is ahead of the current time.");
        }
    }

    private static Date getFreshnessAndSkewAdjustedDate(long maxClockSkew, long timestampFreshnessLimit) {
        GregorianCalendar c = new GregorianCalendar();
        long offset = c.get(15);
        if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)((Calendar)c).getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        long adjustedTime = currentTime - maxClockSkew - timestampFreshnessLimit;
        c.setTimeInMillis(adjustedTime);
        return c.getTime();
    }

    private static Date getGMTDateWithSkewAdjusted(Calendar c, long maxClockSkew, boolean addSkew) {
        long offset = c.get(15);
        if (c.getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)c.getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        currentTime = addSkew ? (currentTime += maxClockSkew) : (currentTime -= maxClockSkew);
        c.setTimeInMillis(currentTime);
        return c.getTime();
    }

    private X509Certificate getCertificateFromTrustStoreForThumbprint(byte[] ski, Map runtimeProps) throws IOException {
        try {
            Object obj;
            X509Certificate cert;
            if (runtimeProps != null && (cert = XWSSUtil.matchesProgrammaticInfo(obj = runtimeProps.get("server-certificate"), ski, "Thumbprint")) != null) {
                return cert;
            }
            if (this.getTrustStore(runtimeProps) == null && this.getCertStore(runtimeProps) == null) {
                return null;
            }
            if (this.trustStore != null) {
                Enumeration<String> aliases = this.trustStore.aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate x509Cert;
                    byte[] keyId;
                    String alias = aliases.nextElement();
                    Certificate cert2 = this.trustStore.getCertificate(alias);
                    if (cert2 == null || !"X.509".equals(cert2.getType()) || (keyId = XWSSUtil.getThumbprintIdentifier(x509Cert = (X509Certificate)cert2)) == null || !Arrays.equals(ski, keyId)) continue;
                    return x509Cert;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1526.failedto.getcertificate", e);
            throw new RuntimeException(e);
        }
        if (this.certStore != null) {
            DigestCertSelector selector = null;
            if (selector == null) {
                selector = new DigestCertSelector(ski, "SHA-1");
            }
            Collection<? extends Certificate> certs = null;
            try {
                certs = this.certStore.getCertificates(selector);
            }
            catch (CertStoreException ex) {
                log.log(Level.SEVERE, "WSS1530.exception.in.certstore.lookup", ex);
                throw new RuntimeException(ex);
            }
            if (certs.size() > 0) {
                return (X509Certificate)certs.iterator().next();
            }
        }
        return null;
    }

    public PrivateKey getPrivateKeyForThumbprint(byte[] ski, Map runtimeProps) throws IOException {
        try {
            Object obj;
            X509Certificate cert;
            if (runtimeProps != null && (cert = XWSSUtil.matchesProgrammaticInfo(obj = runtimeProps.get("certificate"), ski, "Thumbprint")) != null) {
                return XWSSUtil.getProgrammaticPrivateKey(runtimeProps);
            }
            if (this.getKeyStore(runtimeProps) == null) {
                return null;
            }
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                Certificate cert2;
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || (cert2 = this.keyStore.getCertificate(alias)) == null || !"X.509".equals(cert2.getType()) || (keyId = XWSSUtil.getThumbprintIdentifier(x509Cert = (X509Certificate)cert2)) == null || !Arrays.equals(ski, keyId)) continue;
                return this.getPrivateKey(runtimeProps, alias);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1505.failedto.getkey", e);
            throw new RuntimeException(e);
        }
        return null;
    }

    private Class loadClassSilent(String classname) {
        block8: {
            ClassLoader loader;
            Class<?> ret;
            block7: {
                if (classname == null) {
                    return null;
                }
                ret = null;
                loader = Thread.currentThread().getContextClassLoader();
                if (loader != null) {
                    try {
                        ret = loader.loadClass(classname);
                        return ret;
                    }
                    catch (ClassNotFoundException e) {
                        if (!log.isLoggable(Level.FINE)) break block7;
                        log.log(Level.FINE, "LoadClassSilent: could not load class " + classname, e);
                    }
                }
            }
            if ((loader = this.getClass().getClassLoader()) != null) {
                try {
                    ret = loader.loadClass(classname);
                    return ret;
                }
                catch (ClassNotFoundException e) {
                    if (!log.isLoggable(Level.FINE)) break block8;
                    log.log(Level.FINE, "LoadClassSilent: could not load class " + classname, e);
                }
            }
        }
        return null;
    }

    private Class loadClass(String classname) throws XWSSecurityException {
        ClassLoader loader;
        Class<?> ret;
        block7: {
            if (classname == null) {
                return null;
            }
            ret = null;
            loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                try {
                    ret = loader.loadClass(classname);
                    return ret;
                }
                catch (ClassNotFoundException e) {
                    if (!log.isLoggable(Level.FINE)) break block7;
                    log.log(Level.FINE, "LoadClass: could not load class " + classname, e);
                }
            }
        }
        loader = this.getClass().getClassLoader();
        try {
            ret = loader.loadClass(classname);
            return ret;
        }
        catch (ClassNotFoundException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "LoadClass: could not load class " + classname, e);
            }
            log.log(Level.SEVERE, "WSS1521.error.getting.userClass");
            throw new XWSSecurityException("Could not find User Class " + classname);
        }
    }

    private long toLong(String lng) throws XWSSecurityException {
        if (lng == null) {
            return 0L;
        }
        Long ret = 0L;
        ret = Long.valueOf(lng);
        try {
            ret = Long.valueOf(lng);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1522.error.getting.longValue", e);
            throw new XWSSecurityException(e);
        }
        return ret;
    }

    private void initNewInstances() throws XWSSecurityException {
        try {
            if (this.usernameCbHandler != null) {
                this.usernameHandler = (CallbackHandler)this.usernameCbHandler.newInstance();
            } else if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Got NULL for Username Callback Handler");
            }
            if (this.passwordCbHandler != null) {
                this.passwordHandler = (CallbackHandler)this.passwordCbHandler.newInstance();
            } else if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Got NULL for Password Callback Handler");
            }
            if (this.samlCbHandler != null) {
                this.samlHandler = (CallbackHandler)this.samlCbHandler.newInstance();
            }
            if (this.usernameValidator != null) {
                this.pwValidator = (PasswordValidationCallback.PasswordValidator)this.usernameValidator.newInstance();
            }
            if (this.timestampValidator != null) {
                this.tsValidator = (TimestampValidationCallback.TimestampValidator)this.timestampValidator.newInstance();
            }
            if (this.samlValidator != null) {
                this.sValidator = (SAMLAssertionValidator)this.samlValidator.newInstance();
            }
            this.certValidator = this.certificateValidator != null ? (CertificateValidationCallback.CertificateValidator)this.certificateValidator.newInstance() : new X509CertificateValidatorImpl();
            if (this.certstoreCbHandler != null) {
                this.certstoreHandler = (CallbackHandler)this.certstoreCbHandler.newInstance();
            }
            if (this.keystoreCbHandler != null) {
                this.keystoreHandler = (CallbackHandler)this.keystoreCbHandler.newInstance();
            }
            if (this.truststoreCbHandler != null) {
                this.truststoreHandler = (CallbackHandler)this.truststoreCbHandler.newInstance();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1523.error.getting.newInstance.CallbackHandler", e);
            throw new XWSSecurityException(e);
        }
    }

    private X509Certificate getCertificateFromTrustStoreForSAML(PublicKey pk, Map runtimeProps) throws IOException {
        try {
            Object obj;
            X509Certificate cert;
            if (runtimeProps != null && (cert = XWSSUtil.matchesProgrammaticInfo(obj = runtimeProps.get("server-certificate"), pk)) != null) {
                return cert;
            }
            if (this.getTrustStore(runtimeProps) == null && this.getCertStore(runtimeProps) == null) {
                return null;
            }
            if (this.trustStore != null) {
                Enumeration<String> aliases = this.trustStore.aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate x509Cert;
                    String alias = aliases.nextElement();
                    Certificate cert2 = this.trustStore.getCertificate(alias);
                    if (cert2 == null || !"X.509".equals(cert2.getType()) || !(x509Cert = (X509Certificate)cert2).getPublicKey().equals(pk)) continue;
                    return x509Cert;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1526.failedto.getcertificate", e);
            throw new RuntimeException(e);
        }
        if (this.certStore != null) {
            PublicKeyCertSelector selector = null;
            if (selector == null) {
                selector = new PublicKeyCertSelector(pk);
            }
            Collection<? extends Certificate> certs = null;
            try {
                certs = this.certStore.getCertificates(selector);
            }
            catch (CertStoreException ex) {
                log.log(Level.SEVERE, "WSS1530.exception.in.certstore.lookup", ex);
                throw new RuntimeException(ex);
            }
            if (certs.size() > 0) {
                return (X509Certificate)certs.iterator().next();
            }
        }
        return null;
    }

    private PrivateKey getPrivateKeyFromKeyStore(PublicKey pk, Map runtimeProps) throws IOException {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cert;
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || !pk.equals((cert = this.keyStore.getCertificate(alias)).getPublicKey())) continue;
                PrivateKey key = this.getPrivateKey(runtimeProps, alias);
                return key;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1505.failedto.getkey", e);
            throw new RuntimeException(e);
        }
        return null;
    }

    private String resolveHome(String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("$WSIT_HOME")) {
            String wsitHome = System.getProperty("WSIT_HOME");
            if (wsitHome != null) {
                String ret = url.replace("$WSIT_HOME", wsitHome);
                return ret;
            }
            log.log(Level.SEVERE, "WSS1524.unableto.resolve.URI.WSIT_HOME.notset");
            throw new RuntimeException("The following config URL: " + url + " in the WSDL could not be resolved because System Property WSIT_HOME was not set");
        }
        return url;
    }

    private void initKeyPassword() {
        try {
            Class cbh = this.loadClassSilent(this.keyPwd);
            if (cbh != null) {
                CallbackHandler hdlr = (CallbackHandler)cbh.newInstance();
                PasswordCallback pc = new PasswordCallback("KeyPassword", false);
                Callback[] cbs = new Callback[]{pc};
                hdlr.handle(cbs);
                this.keyPassword = ((PasswordCallback)cbs[0]).getPassword();
            } else {
                this.keyPassword = this.keyPwd.toCharArray();
            }
        }
        catch (InstantiationException ex) {
            log.log(Level.SEVERE, "WSS1528.failed.initialize.key.password", ex);
            throw new RuntimeException(ex);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "WSS1528.failed.initialize.key.password", e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException ie) {
            log.log(Level.SEVERE, "WSS1528.failed.initialize.key.password", ie);
            throw new RuntimeException(ie);
        }
        catch (UnsupportedCallbackException ue) {
            log.log(Level.SEVERE, "WSS1528.failed.initialize.key.password", ue);
            throw new RuntimeException(ue);
        }
    }

    private X509Certificate getDynamicCertificate(Map context) {
        X509Certificate cert = null;
        X509Certificate self = null;
        Subject requesterSubject = this.getRequesterSubject(context);
        if (requesterSubject != null) {
            Set<Object> publicCredentials = requesterSubject.getPublicCredentials();
            for (Object cred : publicCredentials) {
                if (!(cred instanceof X509Certificate)) continue;
                X509Certificate certificate = (X509Certificate)cred;
                if (!this.isMyCert(certificate, context)) {
                    cert = certificate;
                    break;
                }
                self = certificate;
            }
            if (cert != null) {
                return cert;
            }
            if (self != null) {
                return self;
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Could not locate Incoming Client Certificate in Caller Subject");
        }
        return null;
    }

    public Subject getRequesterSubject(final Map context) {
        Subject otherPartySubject = (Subject)context.get("javax.security.auth.Subject");
        if (otherPartySubject != null) {
            return otherPartySubject;
        }
        otherPartySubject = (Subject)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Subject otherPartySubj = new Subject();
                context.put("javax.security.auth.Subject", otherPartySubj);
                return otherPartySubj;
            }
        });
        return otherPartySubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getKeyStore(Map runtimeProps) {
        try {
            if (this.keyStore != null) {
                KeyStore keyStore = this.keyStore;
                return keyStore;
            }
            KeyStore keyStore = this.getKeyStoreUsingCallback(runtimeProps);
            return keyStore;
        }
        finally {
            if (this.keyStore == null) {
                log.log(Level.SEVERE, "Could not locate KeyStore, check keystore assertion in WSIT configuration");
                throw new XWSSecurityRuntimeException("Could not locate KeyStore, check keystore assertion in WSIT configuration");
            }
        }
    }

    private synchronized KeyStore getKeyStoreUsingCallback(Map runtimeProps) {
        if (this.keyStore == null && this.keystoreHandler != null) {
            try {
                KeyStoreCallback cb = new KeyStoreCallback();
                SecurityUtil.copy(cb.getRuntimeProperties(), runtimeProps);
                Callback[] cbs = new Callback[]{cb};
                this.keystoreHandler.handle(cbs);
                this.keyStore = cb.getKeystore();
                if (this.keyStore == null) {
                    log.log(Level.SEVERE, "No KeyStore set in KeyStorCallback  by CallbackHandler");
                    throw new XWSSecurityRuntimeException("No KeyStore set in KeyStorCallback  by CallbackHandler");
                }
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new XWSSecurityRuntimeException(ex);
            }
            catch (UnsupportedCallbackException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new XWSSecurityRuntimeException(ex);
            }
        }
        return this.keyStore;
    }

    private KeyStore getTrustStore(Map runtimeProps) {
        if (this.trustStore != null) {
            return this.trustStore;
        }
        return this.getTrustStoreUsingCallback(runtimeProps);
    }

    private CertStore getCertStore(Map runtimeProps) {
        if (this.certStore != null) {
            return this.certStore;
        }
        return this.getCertStoreUsingCallback(runtimeProps);
    }

    private synchronized CertStore getCertStoreUsingCallback(Map runtimeProps) {
        if (this.certstoreHandler != null) {
            CertStoreCallback cb = new CertStoreCallback();
            SecurityUtil.copy(cb.getRuntimeProperties(), runtimeProps);
            Callback[] callbacks = new Callback[]{cb};
            try {
                this.certstoreHandler.handle(callbacks);
                this.certStore = cb.getCertStore();
            }
            catch (UnsupportedCallbackException ex) {
                log.log(Level.SEVERE, "WSS1529.exception.in.certstore.callback", ex);
                throw new XWSSecurityRuntimeException(ex);
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, "WSS1529.exception.in.certstore.callback", ex);
                throw new XWSSecurityRuntimeException(ex);
            }
        }
        return this.certStore;
    }

    private synchronized KeyStore getTrustStoreUsingCallback(Map runtimeProps) {
        if (this.trustStore == null && this.truststoreHandler != null) {
            try {
                KeyStoreCallback cb = new KeyStoreCallback();
                SecurityUtil.copy(cb.getRuntimeProperties(), runtimeProps);
                Callback[] cbs = new Callback[]{cb};
                this.truststoreHandler.handle(cbs);
                this.trustStore = cb.getKeystore();
                if (this.trustStore == null) {
                    log.log(Level.SEVERE, "No TrustStore set in KeyStorCallback  by CallbackHandler");
                    throw new XWSSecurityRuntimeException("No TrustStore set in KeyStorCallback  by CallbackHandler");
                }
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new XWSSecurityRuntimeException(ex);
            }
            catch (UnsupportedCallbackException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new XWSSecurityRuntimeException(ex);
            }
        }
        return this.trustStore;
    }

    private PrivateKey getPrivateKey(Map runtimeProps, String alias) {
        PrivateKey privKey = null;
        if (this.keystoreHandler != null) {
            try {
                PrivateKeyCallback cb = new PrivateKeyCallback();
                cb.setKeystore(this.keyStore);
                cb.setAlias(alias);
                SecurityUtil.copy(cb.getRuntimeProperties(), runtimeProps);
                Callback[] cbs = new Callback[]{cb};
                this.keystoreHandler.handle(cbs);
                privKey = cb.getKey();
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new XWSSecurityRuntimeException(ex);
            }
            catch (UnsupportedCallbackException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new XWSSecurityRuntimeException(ex);
            }
        }
        try {
            privKey = (PrivateKey)this.keyStore.getKey(alias, this.keyPassword);
        }
        catch (KeyStoreException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (UnrecoverableKeyException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        if (privKey == null) {
            log.log(Level.SEVERE, "PrivateKey returned by PrivateKeyCallback was Null");
            throw new XWSSecurityRuntimeException("PrivateKey returned by PrivateKeyCallback was Null");
        }
        return privKey;
    }

    public SAMLAssertionValidator getSAMLValidator() {
        return this.sValidator;
    }

    public class X509CertificateValidatorImpl
    implements CertificateValidationCallback.CertificateValidator,
    ValidatorExtension {
        private Map runtimeProps = null;

        public boolean validate(X509Certificate certificate) throws CertificateValidationCallback.CertificateValidationException {
            PKIXBuilderParameters parameters;
            try {
                certificate.checkValidity();
            }
            catch (CertificateExpiredException e) {
                log.log(Level.SEVERE, "WSS1517.X509.expired", e);
                throw new CertificateValidationCallback.CertificateValidationException("X509Certificate Expired", e);
            }
            catch (CertificateNotYetValidException e) {
                log.log(Level.SEVERE, "WSS1527.X509.notValid", e);
                throw new CertificateValidationCallback.CertificateValidationException("X509Certificate Not Yet Valid", e);
            }
            if (certificate.getIssuerX500Principal().equals(certificate.getSubjectX500Principal())) {
                if (this.isTrustedSelfSigned(certificate, DefaultCallbackHandler.this.getTrustStore(this.runtimeProps))) {
                    return true;
                }
                log.log(Level.SEVERE, "WSS1533.X509.SelfSignedCertificate.notValid");
                throw new CertificateValidationCallback.CertificateValidationException("Validation of self signed certificate failed");
            }
            X509CertSelector certSelector = new X509CertSelector();
            certSelector.setCertificate(certificate);
            CertPathValidator certValidator = null;
            CertPath certPath = null;
            List<Object> certChainList = new ArrayList<X509Certificate>();
            boolean caFound = false;
            Principal certChainIssuer = null;
            int noOfEntriesInTrustStore = 0;
            boolean isIssuerCertMatched = false;
            try {
                KeyStore tStore = DefaultCallbackHandler.this.getTrustStore(this.runtimeProps);
                CertStore cStore = DefaultCallbackHandler.this.getCertStore(this.runtimeProps);
                parameters = new PKIXBuilderParameters(tStore, (CertSelector)certSelector);
                parameters.setRevocationEnabled(DefaultCallbackHandler.this.revocationEnabled);
                if (cStore != null) {
                    parameters.addCertStore(cStore);
                } else {
                    CertStore cs = CertStore.getInstance("Collection", new CollectionCertStoreParameters(Collections.singleton(certificate)));
                    parameters.addCertStore(cs);
                }
                Certificate[] certChain = null;
                String certAlias = tStore.getCertificateAlias(certificate);
                if (certAlias != null) {
                    certChain = tStore.getCertificateChain(certAlias);
                }
                if (certChain == null) {
                    certChainList.add(certificate);
                    certChainIssuer = certificate.getIssuerX500Principal();
                    noOfEntriesInTrustStore = tStore.size();
                } else {
                    certChainList = Arrays.asList(certChain);
                }
                while (!caFound && noOfEntriesInTrustStore-- != 0 && certChain == null) {
                    Enumeration<String> aliases = tStore.aliases();
                    while (aliases.hasMoreElements()) {
                        X509Certificate x509Cert;
                        String alias = aliases.nextElement();
                        Certificate cert = tStore.getCertificate(alias);
                        if (cert == null || !"X.509".equals(cert.getType()) || certChainList.contains(cert) || !((Object)certChainIssuer).equals((x509Cert = (X509Certificate)cert).getSubjectX500Principal())) continue;
                        certChainList.add(cert);
                        if (x509Cert.getSubjectX500Principal().equals(x509Cert.getIssuerX500Principal())) {
                            caFound = true;
                            break;
                        }
                        certChainIssuer = x509Cert.getIssuerDN();
                        if (isIssuerCertMatched) continue;
                        isIssuerCertMatched = true;
                    }
                    if (caFound) continue;
                    if (!isIssuerCertMatched) break;
                    isIssuerCertMatched = false;
                }
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                certPath = cf.generateCertPath(certChainList);
                certValidator = CertPathValidator.getInstance("PKIX");
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS1518.failedto.validate.certificate", e);
                throw new CertificateValidationCallback.CertificateValidationException(e.getMessage(), e);
            }
            try {
                certValidator.validate(certPath, parameters);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS1518.failedto.validate.certificate", e);
                throw new CertificateValidationCallback.CertificateValidationException(e.getMessage(), e);
            }
            return true;
        }

        private boolean isTrustedSelfSigned(X509Certificate cert, KeyStore trustStore) throws CertificateValidationCallback.CertificateValidationException {
            if (trustStore == null) {
                return false;
            }
            try {
                Enumeration<String> aliases = trustStore.aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate x509Cert;
                    String alias = aliases.nextElement();
                    Certificate certificate = trustStore.getCertificate(alias);
                    if (certificate == null || !"X.509".equals(certificate.getType()) || (x509Cert = (X509Certificate)certificate) == null || !x509Cert.equals(cert)) continue;
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS1518.failedto.validate.certificate", e);
                throw new CertificateValidationCallback.CertificateValidationException(e.getMessage(), e);
            }
        }

        public void setRuntimeProperties(Map props) {
            this.runtimeProps = props;
        }
    }

    private class DefaultTimestampValidator
    implements TimestampValidationCallback.TimestampValidator {
        private DefaultTimestampValidator() {
        }

        public void validate(TimestampValidationCallback.Request request) throws TimestampValidationCallback.TimestampValidationException {
            TimestampValidationCallback.UTCTimestampRequest utcTimestampRequest = (TimestampValidationCallback.UTCTimestampRequest)request;
            SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            SimpleDateFormat calendarFormatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
            Date created = null;
            Date expired = null;
            try {
                created = calendarFormatter1.parse(utcTimestampRequest.getCreated());
                if (utcTimestampRequest.getExpired() != null) {
                    expired = calendarFormatter1.parse(utcTimestampRequest.getExpired());
                }
            }
            catch (ParseException pe) {
                try {
                    created = calendarFormatter2.parse(utcTimestampRequest.getCreated());
                    if (utcTimestampRequest.getExpired() != null) {
                        expired = calendarFormatter2.parse(utcTimestampRequest.getExpired());
                    }
                }
                catch (ParseException ipe) {
                    log.log(Level.SEVERE, "WSS1513.exception.validate.timestamp", ipe);
                    throw new TimestampValidationCallback.TimestampValidationException(ipe.getMessage());
                }
            }
            long maxClockSkewLocal = utcTimestampRequest.getMaxClockSkew();
            if (DefaultCallbackHandler.this.mcs != null && DefaultCallbackHandler.this.maxClockSkewG >= 0L) {
                maxClockSkewLocal = DefaultCallbackHandler.this.maxClockSkewG;
            }
            long tsfLocal = utcTimestampRequest.getTimestampFreshnessLimit();
            if (DefaultCallbackHandler.this.tfl != null && DefaultCallbackHandler.this.timestampFreshnessLimitG > 0L) {
                tsfLocal = DefaultCallbackHandler.this.timestampFreshnessLimitG;
            }
            DefaultCallbackHandler.this.validateCreationTime(created, maxClockSkewLocal, tsfLocal);
            if (expired != null) {
                DefaultCallbackHandler.this.validateExpirationTime(expired, maxClockSkewLocal, tsfLocal);
            }
        }
    }
}

