/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.internal;

import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.WSATXAResource;
import com.sun.xml.ws.tx.at.common.TransactionManagerImpl;
import com.sun.xml.ws.tx.at.internal.BranchRecord;
import com.sun.xml.ws.tx.at.internal.ForeignRecoveryContext;
import com.sun.xml.ws.tx.at.internal.ForeignRecoveryContextManager;
import com.sun.xml.ws.tx.at.internal.JTAHelper;
import com.sun.xml.ws.tx.at.internal.WSATNoOpXAResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import javax.xml.ws.WebServiceException;

public class WSATGatewayRM
implements XAResource {
    private static WSATGatewayRM singleton;
    private String resourceRegistrationName;
    private Map<Xid, BranchRecord> branches;
    private List<Xid> pendingXids;
    private final Object currentXidLock = new Object();
    private Xid currentXid;
    static boolean isReady;
    public static final boolean isWSATRecoveryEnabled;
    public static final String txlogdir;
    private static final String txlogdirinbound;
    private static TransactionManager m_transactionManager;
    private static Transaction m_transaction;

    private WSATGatewayRM(String serverName) {
        this.resourceRegistrationName = "RM_NAME_PREFIX" + serverName;
        this.branches = Collections.synchronizedMap(new HashMap());
        this.pendingXids = Collections.synchronizedList(new ArrayList());
    }

    public static synchronized WSATGatewayRM getInstance() {
        if (singleton == null) {
            WSATGatewayRM.create("server");
        }
        while (!isReady) {
            try {
                System.out.println("WSATGatewayRM is not ready to receive requests as recovery logs are being read");
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return singleton;
    }

    public static synchronized WSATGatewayRM create(String serverName) {
        if (singleton == null) {
            singleton = new WSATGatewayRM(serverName);
            if (isWSATRecoveryEnabled) {
                singleton.initStore();
                singleton.recoverPendingBranches();
            }
        }
        isReady = true;
        return singleton;
    }

    private void initStore() {
        File file = new File(txlogdir);
        file.mkdirs();
        file = new File(txlogdirinbound);
        file.mkdirs();
    }

    private void recoverPendingBranches() {
        int i;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("recoverPendingBranches() outbound");
        }
        FileInputStream fis = null;
        ObjectInputStream in = null;
        File[] files = new File(txlogdir).listFiles();
        if (files != null) {
            for (i = 0; i < files.length; ++i) {
                try {
                    fis = new FileInputStream(files[i]);
                    in = new ObjectInputStream(fis);
                    BranchRecord branch = (BranchRecord)in.readObject();
                    branch.commit(branch.getXid(), false);
                    in.close();
                    continue;
                }
                catch (Throwable e) {
                    throw new WebServiceException("Failure while recovering WS-AT transaction logs", e);
                }
            }
        }
        if (WSATHelper.isDebugEnabled()) {
            this.debug("recoverPendingBranches() inbound");
        }
        fis = null;
        in = null;
        files = new File(txlogdirinbound).listFiles();
        if (files != null) {
            for (i = 0; i < files.length; ++i) {
                try {
                    fis = new FileInputStream(files[i]);
                    in = new ObjectInputStream(fis);
                    ForeignRecoveryContext frc = (ForeignRecoveryContext)in.readObject();
                    ForeignRecoveryContextManager.getInstance().add(frc, true);
                    in.close();
                    continue;
                }
                catch (Throwable e) {
                    throw new WebServiceException("Failure while recovering WS-AT transaction logs inbound", e);
                }
            }
        }
    }

    public void stop() {
        try {
            this.unregisterResource();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
    }

    private void unregisterResource() throws SystemException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid registerWSATResource(Xid xid, XAResource wsatResource, Transaction tx) throws IllegalStateException, RollbackException, SystemException {
        if (tx == null) {
            throw new IllegalStateException("Transaction " + tx + " does not exist, wsatResource=" + wsatResource);
        }
        Object object = this.currentXidLock;
        synchronized (object) {
            tx.enlistResource((XAResource)this);
            ((WSATXAResource)wsatResource).setXid(this.currentXid);
            BranchRecord branch = this.getOrCreateBranch(this.currentXid);
            branch.addSubordinate(this.currentXid, (WSATXAResource)wsatResource);
            tx.enlistResource((XAResource)new WSATNoOpXAResource());
            if (WSATHelper.isDebugEnabled()) {
                this.debug("registerWSATResource() xid=" + this.currentXid);
            }
        }
        return this.currentXid;
    }

    public void start(Xid xid, int flags) throws XAException {
        this.currentXid = xid;
        this.debug("start currentXid:" + this.currentXid + " xid:" + xid);
        if (WSATHelper.isDebugEnabled()) {
            this.debug("start() xid=" + xid + ", flags=" + flags);
        }
        switch (flags) {
            case 0: {
                this.getOrCreateBranch(xid);
                break;
            }
            case 0x200000: 
            case 0x8000000: {
                BranchRecord branch = this.getBranch(xid);
                if (branch != null) break;
                JTAHelper.throwXAException(-4, "Attempt to resume xid " + xid + " that is not in SUSPENDED state.");
                break;
            }
            case 0x20000000: {
                JTAHelper.throwXAException(-3, "error while attempting to rollback branch" + this.resourceRegistrationName);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid flag:" + flags);
            }
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        BranchRecord branch;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("end() xid=" + xid + ", flags=" + flags);
        }
        if ((branch = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "end: no branch info for " + xid);
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("prepare() xid=" + xid);
        }
        BranchRecord branch = this.getBranch(xid);
        if (WSATHelper.isDebugEnabled()) {
            this.debug("prepare() xid=" + xid + " branch=" + branch);
        }
        if (branch == null) {
            JTAHelper.throwXAException(-4, "prepare: no branch info for " + xid);
        }
        if (WSATHelper.isDebugEnabled()) {
            this.debug("prepare() xid=" + xid);
        }
        this.persistBranchIfNecessary(branch);
        return branch.prepare(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        BranchRecord branch;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("commit() xid=" + xid);
        }
        if ((branch = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "commit: no branch information for xid:" + xid);
        }
        try {
            branch.commit(xid, onePhase);
        }
        finally {
            this.deleteBranchIfNecessary(branch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        BranchRecord branch;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("rollback() xid=" + xid);
        }
        if ((branch = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "rollback: no branch info for " + xid);
        }
        try {
            branch.rollback(xid);
        }
        finally {
            this.deleteBranchIfNecessary(branch);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("recover() flag=" + flag);
        }
        if ((flag & 0x1000000) != 0) {
            if (WSATHelper.isDebugEnabled()) {
                this.debug("WSAT recover(" + flag + ") returning " + this.pendingXids);
            }
            Xid[] xids = this.pendingXids.toArray(new Xid[this.pendingXids.size()]);
            return xids;
        }
        if (WSATHelper.isDebugEnabled()) {
            this.debug("recover() returning nothing");
        }
        return new Xid[0];
    }

    public void forget(Xid xid) throws XAException {
        BranchRecord branch;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("forget() xid=" + xid);
        }
        if ((branch = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "forget: no branch info for " + xid);
        }
        this.deleteBranchIfNecessary(branch);
    }

    public int getTransactionTimeout() throws XAException {
        return -1;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (!(xares instanceof WSATGatewayRM)) {
            return false;
        }
        WSATGatewayRM oxares = (WSATGatewayRM)xares;
        return this.equals(oxares);
    }

    public boolean detectedUnavailable() {
        return true;
    }

    public int getDelistFlag() {
        return 0x4000000;
    }

    private synchronized BranchRecord getOrCreateBranch(Xid xid) {
        BranchRecord branch = this.getBranch(xid);
        if (branch == null) {
            branch = new BranchRecord(xid);
            this.branches.put(xid, branch);
        }
        return branch;
    }

    private synchronized BranchRecord getBranch(Xid xid) {
        BranchRecord branch = this.branches.get(xid);
        if (branch != null && xid.getBranchQualifier() != null) {
            branch.assignBranchXid(xid);
        }
        return branch;
    }

    private void delete(BranchRecord branch) {
        this.releaseBranchRecord(branch);
        this.branches.remove(branch.getXid());
        this.pendingXids.removeAll(branch.getAllXids());
        branch.cleanup();
    }

    private void persistBranchRecord(BranchRecord branch) throws IOException {
        if (!isWSATRecoveryEnabled) {
            return;
        }
        if (WSATHelper.isDebugEnabled()) {
            this.debug("persist branch record " + branch);
        }
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        fos = new FileOutputStream(txlogdir + branch.getXid().getGlobalTransactionId() + branch.getXid().getBranchQualifier());
        out = new ObjectOutputStream(fos);
        out.writeObject(branch);
        out.close();
        branch.setLogged(true);
    }

    private void releaseBranchRecord(BranchRecord branch) {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("release branch record " + branch);
        }
        new File(txlogdir + branch.getXid().getGlobalTransactionId() + branch.getXid().getBranchQualifier());
        branch.setLogged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistBranchIfNecessary(BranchRecord branch) throws XAException {
        try {
            BranchRecord branchRecord = branch;
            synchronized (branchRecord) {
                if (!branch.isLogged()) {
                    this.persistBranchRecord(branch);
                    this.pendingXids.addAll(branch.getAllXids());
                }
            }
        }
        catch (IOException pse) {
            this.debug("error persisting branch " + branch + ": " + pse.toString());
            JTAHelper.throwXAException(-3, "Error persisting branch " + branch, pse);
        }
    }

    private boolean deleteBranchIfNecessary(BranchRecord branch) throws XAException {
        return true;
    }

    private TransactionManager getTM() {
        return TransactionManagerImpl.getInstance();
    }

    private Transaction getTransaction(Xid xid) {
        if (m_transaction != null) {
            return m_transaction;
        }
        try {
            return TransactionManagerImpl.getInstance().getTransaction();
        }
        catch (SystemException ex) {
            Logger.getLogger(WSATGatewayRM.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    static void setTM(TransactionManager transactionManager) {
        m_transactionManager = transactionManager;
    }

    static void setTx(Transaction transaction) {
        m_transaction = transaction;
    }

    private void debug(String msg) {
        if (WSATHelper.isDebugEnabled()) {
            System.out.println("[WSATGatewayRM] " + this.resourceRegistrationName + " msg:" + msg);
        }
    }

    static {
        isReady = false;
        isWSATRecoveryEnabled = new Boolean(System.getProperty("wsat.recovery.enabled", "false"));
        txlogdir = System.getProperty("wsat.recovery.logdir", ".") + "/wsatlogs/";
        txlogdirinbound = System.getProperty("wsat.recovery.logdir", ".") + "/wsatlogsinbound/";
        WSATGatewayRM.create("server");
    }

    private final class BranchObjectHandler {
        private static final int VERSION = 1;

        private BranchObjectHandler() {
        }

        public Object readObject(ObjectInput in) throws ClassNotFoundException, IOException {
            int version = in.readInt();
            if (version != 1) {
                throw new IOException("Stream corrupted.  Invalid WS-AT gateway branch version: " + version);
            }
            BranchRecord branch = new BranchRecord();
            branch.readExternal(in);
            if (WSATHelper.isDebugEnabled()) {
                WSATGatewayRM.this.debug("read WS-AT branch " + branch);
            }
            return branch;
        }

        public void writeObject(ObjectOutput out, Object o) throws IOException {
            if (!(o instanceof BranchRecord)) {
                throw new IOException("Cannot serialize class of type: " + (o == null ? null : o.getClass().toString()));
            }
            out.writeInt(1);
            BranchRecord branch = (BranchRecord)o;
            branch.writeExternal(out);
            if (WSATHelper.isDebugEnabled()) {
                WSATGatewayRM.this.debug("serialized WS-AT branch " + branch);
            }
        }
    }
}

