/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.keyinfo.TokenBuilder;
import com.sun.xml.ws.security.opt.impl.reference.DirectReference;
import com.sun.xml.ws.security.opt.impl.tokens.UsernameToken;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.util.logging.Level;

public class UsernameTokenBuilder
extends TokenBuilder {
    AuthenticationTokenPolicy.UsernameTokenBinding binding = null;

    public UsernameTokenBuilder(JAXBFilterProcessingContext context, AuthenticationTokenPolicy.UsernameTokenBinding binding) {
        super(context);
        this.binding = binding;
    }

    public BuilderResult process() throws XWSSecurityException {
        String untokenId = this.binding.getUUID();
        if (untokenId == null || untokenId.equals("")) {
            untokenId = this.context.generateID();
        }
        SecurityUtil.checkIncludeTokenPolicyOpt(this.context, this.binding, untokenId);
        String referenceType = this.binding.getReferenceType();
        BuilderResult result = new BuilderResult();
        if ("Direct".equals(referenceType)) {
            UsernameToken unToken = this.createUsernameToken(this.binding, this.binding.getUsernameToken());
            if (unToken == null) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_0280_FAILED_CREATE_USERNAME_TOKEN());
                throw new XWSSecurityException("Username Token is NULL");
            }
            DirectReference dr = this.buildDirectReference(unToken.getId(), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
            this.buildKeyInfo(dr, this.binding.getSTRID());
        }
        result.setKeyInfo(this.keyInfo);
        return result;
    }
}

