/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.tx.at;

import com.sun.xml.ws.api.FeatureConstructor;
import com.sun.xml.ws.api.tx.at.Transactional;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalFeature
extends WebServiceFeature {
    public static final String ID = "http://docs.oasis-open.org/ws-tx/";
    private Transactional.TransactionFlowType flowType = Transactional.TransactionFlowType.SUPPORTS;
    private boolean isExplicitMode;
    private Transactional.Version version = Transactional.Version.DEFAULT;
    private Map<String, Transactional.TransactionFlowType> flowTypeMap = new HashMap<String, Transactional.TransactionFlowType>();
    private Map<String, Boolean> enabledMap = new HashMap<String, Boolean>();

    @FeatureConstructor(value={"enabled", "value", "version"})
    public TransactionalFeature(boolean enabled, Transactional.TransactionFlowType value, Transactional.Version version) {
        this.enabled = enabled;
        this.flowType = value;
        this.version = version;
    }

    public TransactionalFeature() {
        this.enabled = true;
    }

    public TransactionalFeature(boolean enabled) {
        this.enabled = enabled;
    }

    public Transactional.TransactionFlowType getFlowType() {
        return this.flowType;
    }

    public Transactional.TransactionFlowType getFlowType(String operationName) {
        Transactional.TransactionFlowType type = this.flowTypeMap.get(operationName);
        if (!this.isExplicitMode && type == null) {
            type = this.flowType;
        }
        return type;
    }

    public void setFlowType(Transactional.TransactionFlowType flowType) {
        this.flowType = flowType;
    }

    public void setFlowType(String operationName, Transactional.TransactionFlowType flowType) {
        this.flowTypeMap.put(operationName, flowType);
    }

    public String getID() {
        return ID;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabled(String operationName, boolean enabled) {
        this.enabledMap.put(operationName, enabled);
    }

    public boolean isEnabled(String operationName) {
        Boolean isEnabled = this.enabledMap.get(operationName);
        if (isEnabled == null) {
            return this.isExplicitMode ? false : this.enabled;
        }
        return isEnabled;
    }

    public Transactional.Version getVersion() {
        return this.version;
    }

    public void setVersion(Transactional.Version version) {
        this.version = version;
    }

    public Map<String, Transactional.TransactionFlowType> getFlowTypeMap() {
        return this.flowTypeMap;
    }

    public Map<String, Boolean> getEnabledMap() {
        return this.enabledMap;
    }

    public boolean isExplicitMode() {
        return this.isExplicitMode;
    }

    public void setExplicitMode(boolean explicitMode) {
        this.isExplicitMode = explicitMode;
    }
}

