/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.tx.at.WSATConstants;
import com.sun.xml.ws.tx.at.WSATSynchronization;
import com.sun.xml.ws.tx.at.WSATXAResource;
import com.sun.xml.ws.tx.at.api.Transactional;
import com.sun.xml.ws.tx.at.common.CoordinatorIF;
import com.sun.xml.ws.tx.at.common.ParticipantIF;
import com.sun.xml.ws.tx.at.common.WSATVersion;
import com.sun.xml.ws.tx.at.common.client.CoordinatorProxyBuilder;
import com.sun.xml.ws.tx.at.common.client.ParticipantProxyBuilder;
import com.sun.xml.ws.tx.at.internal.BranchXidImpl;
import com.sun.xml.ws.tx.at.internal.TransactionServicesImpl;
import com.sun.xml.ws.tx.at.runtime.TransactionIdHelper;
import com.sun.xml.ws.tx.at.runtime.TransactionServices;
import com.sun.xml.ws.tx.at.tube.WSATTubeHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import javax.xml.soap.SOAPException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSATHelper<T> {
    public static final WSATHelper V10 = new WSATHelper().WSATVersion(WSATVersion.v10);
    public static final WSATHelper V11 = new WSATHelper(){

        public String getRegistrationCoordinatorAddress() {
            return this.getHostAndPort() + "/wsat-wsat/RegistrationPortTypeRPC11";
        }

        public String getCoordinatorAddress() {
            return this.getHostAndPort() + "/wsat-wsat/CoordinatorPortType11";
        }

        public String getParticipantAddress() {
            return this.getHostAndPort() + "/wsat-wsat/ParticipantPortType11";
        }

        public String getRegistrationRequesterAddress() {
            return this.getHostAndPort() + "/wsat-wsat/RegistrationRequesterPortType11";
        }
    }.WSATVersion(WSATVersion.v11);
    private Map<WSATXAResource, ParticipantIF<T>> m_durableParticipantPortMap = new HashMap<WSATXAResource, ParticipantIF<T>>();
    private final Object m_durableParticipantPortMapLock = new Object();
    private Map<Xid, WSATXAResource> m_durableParticipantXAResourceMap = new HashMap<Xid, WSATXAResource>();
    private final Object m_durableParticipantXAResourceMapLock = new Object();
    private Map<Xid, ParticipantIF<T>> m_volatileParticipantPortMap = new HashMap<Xid, ParticipantIF<T>>();
    private final Object m_volatileParticipantPortMapLock = new Object();
    private Map<Xid, WSATSynchronization> m_volatileParticipantSynchronizationMap = new HashMap<Xid, WSATSynchronization>();
    private final Object m_volatileParticipantSynchronizationMapLock = new Object();
    private final int m_waitForReplyTimeout = new Integer(System.getProperty("com.sun.xml.ws.tx.at.reply.timeout", "120"));
    private final boolean m_isUseLocalServerAddress = Boolean.valueOf(System.getProperty("com.sun.xml.ws.tx.at.use.local.server.address", "false"));
    protected WSATVersion<T> builderFactory;

    WSATHelper WSATVersion(WSATVersion builderFactory) {
        this.builderFactory = builderFactory;
        return this;
    }

    protected WSATHelper() {
    }

    public static WSATHelper getInstance() {
        return V10;
    }

    public static WSATHelper getInstance(Transactional.Version version) {
        if (version == Transactional.Version.WSAT10 || version == Transactional.Version.DEFAULT) {
            return V10;
        }
        if (version == Transactional.Version.WSAT12 || version == Transactional.Version.WSAT11) {
            return V11;
        }
        throw new WebServiceException("not supported WSAT version");
    }

    public static TransactionServices getTransactionServices() {
        return TransactionServicesImpl.getInstance();
    }

    public int getWaitForReplyTimeout() {
        return this.m_waitForReplyTimeout * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDurableParticipantStatus(Xid xid, String status) {
        WSATXAResource wsatXAResourceLock;
        Object object = this.m_durableParticipantXAResourceMapLock;
        synchronized (object) {
            wsatXAResourceLock = this.getDurableParticipantXAResourceMap().get(new BranchXidImpl(xid));
        }
        if (wsatXAResourceLock == null) {
            return false;
        }
        object = wsatXAResourceLock;
        synchronized (object) {
            wsatXAResourceLock.setStatus(status);
            wsatXAResourceLock.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setVolatileParticipantStatus(Xid xid, String status) {
        WSATSynchronization wsatSynchronization;
        Object object = this.m_volatileParticipantSynchronizationMapLock;
        synchronized (object) {
            wsatSynchronization = this.m_volatileParticipantSynchronizationMap.get(xid);
        }
        if (wsatSynchronization == null) {
            return false;
        }
        object = wsatSynchronization;
        synchronized (object) {
            wsatSynchronization.setStatus(status);
            wsatSynchronization.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDurableParticipant(WSATXAResource wsatXAResource) {
        Object object = this.m_durableParticipantPortMapLock;
        synchronized (object) {
            if (this.getDurableParticipantPortMap().containsKey(wsatXAResource)) {
                this.m_durableParticipantPortMap.remove(wsatXAResource);
            }
        }
        object = this.m_durableParticipantXAResourceMapLock;
        synchronized (object) {
            if (this.getDurableParticipantXAResourceMap().containsKey(wsatXAResource.getXid())) {
                this.getDurableParticipantXAResourceMap().remove(wsatXAResource.getXid());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeVolatileParticipant(Xid xid) {
        Object object = this.m_volatileParticipantPortMapLock;
        synchronized (object) {
            if (this.m_volatileParticipantPortMap.containsKey(new BranchXidImpl(xid))) {
                this.m_volatileParticipantPortMap.remove(new BranchXidImpl(xid));
            }
        }
        object = this.m_volatileParticipantSynchronizationMapLock;
        synchronized (object) {
            if (this.m_volatileParticipantSynchronizationMap.containsKey(new BranchXidImpl(xid))) {
                this.m_volatileParticipantSynchronizationMap.remove(new BranchXidImpl(xid));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(EndpointReference epr, Xid xid, WSATXAResource wsatXAResource) throws XAException {
        Object object = this.m_durableParticipantXAResourceMapLock;
        synchronized (object) {
            BranchXidImpl branchXid = new BranchXidImpl(xid);
            this.getDurableParticipantXAResourceMap().put(branchXid, wsatXAResource);
        }
        ParticipantIF<T> port = this.getDurableParticipantPort(epr, xid, wsatXAResource);
        T notification = this.builderFactory.newNotificationBuilder().build();
        port.prepare(notification);
    }

    public void commit(EndpointReference epr, Xid xid, WSATXAResource wsatXAResource) throws XAException {
        T notification = this.builderFactory.newNotificationBuilder().build();
        this.getDurableParticipantPort(epr, xid, wsatXAResource).commit(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(EndpointReference epr, Xid xid, WSATXAResource wsatXAResource) throws XAException {
        Object object = this.m_durableParticipantXAResourceMapLock;
        synchronized (object) {
            BranchXidImpl branchXid = new BranchXidImpl(xid);
            this.getDurableParticipantXAResourceMap().put(branchXid, wsatXAResource);
        }
        T notification = this.builderFactory.newNotificationBuilder().build();
        this.getDurableParticipantPort(epr, xid, wsatXAResource).rollback(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion(EndpointReference epr, Xid xid, WSATSynchronization wsatSynchronization) throws SOAPException {
        T notification = this.builderFactory.newNotificationBuilder().build();
        this.getVolatileParticipantPort(epr, xid).prepare(notification);
        Object object = this.m_volatileParticipantSynchronizationMapLock;
        synchronized (object) {
            this.m_volatileParticipantSynchronizationMap.put(new BranchXidImpl(xid), wsatSynchronization);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParticipantIF<T> getVolatileParticipantPort(EndpointReference epr, Xid xid) throws SOAPException {
        ParticipantIF<T> participantPort;
        Object object = this.m_volatileParticipantPortMapLock;
        synchronized (object) {
            participantPort = this.m_volatileParticipantPortMap.get(new BranchXidImpl(xid));
        }
        if (participantPort != null) {
            return participantPort;
        }
        participantPort = this.getParticipantPort(epr, xid, null);
        object = this.m_volatileParticipantPortMapLock;
        synchronized (object) {
            this.m_volatileParticipantPortMap.put(new BranchXidImpl(xid), participantPort);
        }
        return participantPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParticipantIF<T> getDurableParticipantPort(EndpointReference epr, Xid xid, WSATXAResource wsatXAResource) throws XAException {
        ParticipantIF<T> participantPort;
        Object object = this.m_durableParticipantPortMapLock;
        synchronized (object) {
            participantPort = this.getDurableParticipantPortMap().get(wsatXAResource);
        }
        if (participantPort != null) {
            return participantPort;
        }
        try {
            participantPort = this.getParticipantPort(epr, xid, new String(wsatXAResource.getXid().getBranchQualifier()));
        }
        catch (SOAPException e) {
            e.printStackTrace();
            XAException xaException = new XAException("Unable to create durable participant port:" + (Object)((Object)e));
            xaException.initCause(e);
            xaException.errorCode = -7;
            throw xaException;
        }
        object = this.m_durableParticipantXAResourceMapLock;
        synchronized (object) {
            BranchXidImpl branchXid = new BranchXidImpl(xid);
            this.getDurableParticipantXAResourceMap().put(branchXid, wsatXAResource);
        }
        object = this.m_durableParticipantPortMapLock;
        synchronized (object) {
            this.getDurableParticipantPortMap().put(wsatXAResource, participantPort);
        }
        return participantPort;
    }

    public ParticipantIF<T> getParticipantPort(EndpointReference epr, Xid xid, String bqual) throws SOAPException {
        String txId = TransactionIdHelper.getInstance().xid2wsatid(xid);
        ParticipantProxyBuilder<T> proxyBuilder = this.builderFactory.newParticipantProxyBuilder();
        ParticipantIF participantProxyIF = ((ParticipantProxyBuilder)((ParticipantProxyBuilder)proxyBuilder.to(epr)).txIdForReference(txId, bqual)).build();
        return participantProxyIF;
    }

    public CoordinatorIF<T> getCoordinatorPort(EndpointReference epr, Xid xid) {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("WSATHelper.getCoordinatorPort xid:" + xid + " epr:" + epr);
        }
        String txId = TransactionIdHelper.getInstance().xid2wsatid(xid);
        CoordinatorProxyBuilder<T> proxyBuilder = this.builderFactory.newCoordinatorProxyBuilder();
        CoordinatorIF coordinatorProxy = ((CoordinatorProxyBuilder)((CoordinatorProxyBuilder)proxyBuilder.to(epr)).txIdForReference(txId, "")).build();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("WSATHelper.getCoordinatorPort xid:" + xid + " epr:" + epr + " coordinatorProxy:" + coordinatorProxy);
        }
        return coordinatorProxy;
    }

    public String getRoutingAddress() {
        return "none";
    }

    String getHostAndPort() {
        boolean isSSLRequired = WSATTubeHelper.isSSLRequired();
        return "http://localhost:8080/";
    }

    public String getRegistrationCoordinatorAddress() {
        return this.getHostAndPort() + "/wsat-wsat/RegistrationPortTypeRPC";
    }

    public String getCoordinatorAddress() {
        return this.getHostAndPort() + "/wsat-wsat/CoordinatorPortType";
    }

    public String getParticipantAddress() {
        return this.getHostAndPort() + "/wsat-wsat/ParticipantPortType";
    }

    public String getRegistrationRequesterAddress() {
        return this.getHostAndPort() + "/wsat-wsat/RegistrationRequesterPortType";
    }

    public Xid getXidFromWebServiceContextHeaderList(WebServiceContext context) {
        String txId = this.getWSATTidFromWebServiceContextHeaderList(context);
        return TransactionIdHelper.getInstance().wsatid2xid(txId);
    }

    public String getWSATTidFromWebServiceContextHeaderList(WebServiceContext context) {
        MessageContext messageContext = context.getMessageContext();
        HeaderList headerList = (HeaderList)messageContext.get((Object)"com.sun.xml.ws.api.message.HeaderList");
        Iterator<Header> headers = headerList.getHeaders(WSATConstants.TXID_QNAME, false);
        if (!headers.hasNext()) {
            throw new WebServiceException("txid does not exist in header");
        }
        String txId = headers.next().getStringContent();
        return txId;
    }

    public String getBQualFromWebServiceContextHeaderList(WebServiceContext context) {
        MessageContext messageContext = context.getMessageContext();
        HeaderList headerList = (HeaderList)messageContext.get((Object)"com.sun.xml.ws.api.message.HeaderList");
        Iterator<Header> headers = headerList.getHeaders(WSATConstants.BRANCHQUAL_QNAME, false);
        if (!headers.hasNext()) {
            throw new WebServiceException("branchqual does not exist in header");
        }
        String bqual = headers.next().getStringContent();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("WSATHelper.getBQualFromWebServiceContextHeaderList returning bqual:" + bqual + " on thread:" + Thread.currentThread());
        }
        return bqual;
    }

    public static boolean isDebugEnabled() {
        return true;
    }

    public Map<WSATXAResource, ParticipantIF<T>> getDurableParticipantPortMap() {
        return this.m_durableParticipantPortMap;
    }

    Map<Xid, WSATXAResource> getDurableParticipantXAResourceMap() {
        return this.m_durableParticipantXAResourceMap;
    }

    public Map<Xid, WSATSynchronization> getVolatileParticipantSynchronizationMap() {
        return this.m_volatileParticipantSynchronizationMap;
    }

    public Map<Xid, ParticipantIF<T>> getVolatileParticipantPortMap() {
        return this.m_volatileParticipantPortMap;
    }

    public void debug(String msg) {
        Logger.getLogger(WSATHelper.class.getName()).log(Level.INFO, (String)null);
    }

    public static String assignUUID() {
        return UUID.randomUUID().toString();
    }
}

