/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.testing;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RmRuntimeVersion;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;

public abstract class PacketFilter {
    protected static final long UNSPECIFIED = -1L;
    private static final Logger LOGGER = Logger.getLogger(PacketFilter.class);
    private RuntimeContext rc;

    protected PacketFilter() {
    }

    public abstract Packet filterClientRequest(Packet var1) throws Exception;

    public abstract Packet filterServerResponse(Packet var1) throws Exception;

    protected final String getSequenceId(Packet packet) {
        try {
            if (this.notInitialized(packet) || this.isRmProtocolMessage(packet)) {
                return null;
            }
            JaxwsApplicationMessage message = new JaxwsApplicationMessage(packet, packet.getMessage().getID(this.rc.addressingVersion, this.rc.soapVersion));
            this.rc.protocolHandler.loadSequenceHeaderData(message, message.getJaxwsMessage());
            return message.getSequenceId();
        }
        catch (Exception ex) {
            LOGGER.warning("Unexpected exception occured", ex);
            return null;
        }
    }

    protected final long getMessageId(Packet packet) {
        try {
            if (this.notInitialized(packet) || this.isRmProtocolMessage(packet)) {
                return -1L;
            }
            JaxwsApplicationMessage message = new JaxwsApplicationMessage(packet, packet.getMessage().getID(this.rc.addressingVersion, this.rc.soapVersion));
            this.rc.protocolHandler.loadSequenceHeaderData(message, message.getJaxwsMessage());
            return message.getMessageNumber();
        }
        catch (Exception ex) {
            LOGGER.warning("Unexpected exception occured", ex);
            return -1L;
        }
    }

    protected final RmRuntimeVersion getRmVersion() {
        return this.rc.rmVersion;
    }

    protected final boolean isRmProtocolMessage(Packet packet) {
        return this.rc.rmVersion.protocolVersion.isProtocolAction(this.rc.communicator.getWsaAction(packet));
    }

    final void configure(RuntimeContext context) {
        this.rc = context;
    }

    private boolean notInitialized(Packet packet) {
        return this.rc == null || packet == null || packet.getMessage() == null;
    }
}

