/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.ProcessorException;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.ModelInfo;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Processor
implements com.sun.xml.rpc.spi.tools.Processor {
    private Properties _options;
    private Configuration _configuration;
    private List _actions;
    private Model _model;
    private boolean _printStackTrace;
    private ProcessorEnvironment _env;

    public Processor(Configuration configuration, Properties options) {
        this._configuration = configuration;
        this._options = options;
        this._actions = new ArrayList();
        this._printStackTrace = Boolean.valueOf(this._options.getProperty("printStackTrace"));
        this._env = (ProcessorEnvironment)this._configuration.getEnvironment();
    }

    public void add(ProcessorAction action) {
        this._actions.add(action);
    }

    public com.sun.xml.rpc.spi.model.Model getModel() {
        return this._model;
    }

    public void run() {
        this.runModeler();
        if (this._model != null) {
            this.runActions();
        }
    }

    public void runModeler() {
        try {
            ModelInfo modelInfo = (ModelInfo)this._configuration.getModelInfo();
            if (modelInfo == null) {
                throw new ProcessorException("processor.missing.model");
            }
            this._model = modelInfo.buildModel(this._options);
        }
        catch (JAXRPCExceptionBase e) {
            if (this._printStackTrace) {
                this._env.printStackTrace(e);
            }
            this._env.error(e);
        }
        catch (Exception e) {
            if (this._printStackTrace) {
                this._env.printStackTrace(e);
            }
            this._env.error(new LocalizableExceptionAdapter(e));
        }
    }

    public void runActions() {
        try {
            if (this._model == null) {
                return;
            }
            for (ProcessorAction action : this._actions) {
                action.perform(this._model, this._configuration, this._options);
            }
        }
        catch (JAXRPCExceptionBase e) {
            if (this._printStackTrace) {
                this._env.printStackTrace(e);
            }
            this._env.error(e);
        }
        catch (Exception e) {
            if (this._printStackTrace) {
                this._env.printStackTrace(e);
            }
            this._env.error(new LocalizableExceptionAdapter(e));
        }
    }
}

