/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.security.impl.policyconv.EncryptedSupportingTokensProcessor;
import com.sun.xml.ws.security.impl.policyconv.EncryptionAssertionProcessor;
import com.sun.xml.ws.security.impl.policyconv.EndorsingEncryptedSupportingTokensProcessor;
import com.sun.xml.ws.security.impl.policyconv.EndorsingSupportingTokensProcessor;
import com.sun.xml.ws.security.impl.policyconv.IntegrityAssertionProcessor;
import com.sun.xml.ws.security.impl.policyconv.PolicyID;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyUtil;
import com.sun.xml.ws.security.impl.policyconv.SignatureTargetCreator;
import com.sun.xml.ws.security.impl.policyconv.SignedEncryptedSupportingTokensProcessor;
import com.sun.xml.ws.security.impl.policyconv.SignedEndorsingEncryptedSupportingTokensProcessor;
import com.sun.xml.ws.security.impl.policyconv.SignedEndorsingSupportingTokensProcessor;
import com.sun.xml.ws.security.impl.policyconv.SignedSupportingTokensProcessor;
import com.sun.xml.ws.security.impl.policyconv.SupportingTokensProcessor;
import com.sun.xml.ws.security.impl.policyconv.TokenProcessor;
import com.sun.xml.ws.security.impl.policyconv.XWSSPolicyContainer;
import com.sun.xml.ws.security.policy.Binding;
import com.sun.xml.ws.security.policy.EncryptedElements;
import com.sun.xml.ws.security.policy.EncryptedParts;
import com.sun.xml.ws.security.policy.EncryptedSupportingTokens;
import com.sun.xml.ws.security.policy.EndorsingEncryptedSupportingTokens;
import com.sun.xml.ws.security.policy.EndorsingSupportingTokens;
import com.sun.xml.ws.security.policy.SignedElements;
import com.sun.xml.ws.security.policy.SignedEncryptedSupportingTokens;
import com.sun.xml.ws.security.policy.SignedEndorsingEncryptedSupportingTokens;
import com.sun.xml.ws.security.policy.SignedEndorsingSupportingTokens;
import com.sun.xml.ws.security.policy.SignedParts;
import com.sun.xml.ws.security.policy.SignedSupportingTokens;
import com.sun.xml.ws.security.policy.SupportingTokens;
import com.sun.xml.ws.security.policy.WSSAssertion;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.KeyBindingBase;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.impl.policy.mls.TimestampPolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.util.Vector;
import javax.xml.namespace.QName;

public abstract class BindingProcessor {
    protected String protectionOrder = "SignBeforeEncrypting";
    protected boolean isServer = false;
    protected boolean isIncoming = false;
    protected SignaturePolicy primarySP = null;
    protected EncryptionPolicy primaryEP = null;
    protected EncryptionPolicy sEncPolicy = null;
    protected SignaturePolicy sSigPolicy = null;
    protected XWSSPolicyContainer container = null;
    protected Vector<SignedParts> signedParts = null;
    protected Vector<EncryptedParts> encryptedParts = null;
    protected Vector<SignedElements> signedElements = null;
    protected Vector<EncryptedElements> encryptedElements = null;
    protected PolicyID pid = new PolicyID();
    protected TokenProcessor tokenProcessor = null;
    protected IntegrityAssertionProcessor iAP = null;
    protected EncryptionAssertionProcessor eAP = null;
    private WSSAssertion wss11 = null;
    private boolean isIssuedTokenAsEncryptedSupportingToken = false;
    protected boolean foundEncryptTargets = false;

    protected void protectPrimarySignature() throws PolicyException {
        boolean encryptSignConfirm;
        if (this.primarySP == null) {
            return;
        }
        boolean bl = encryptSignConfirm = this.isServer && !this.isIncoming || !this.isServer && this.isIncoming;
        if ("EncryptBeforeSigning".equals(this.protectionOrder)) {
            EncryptionPolicy ep = this.getSecondaryEncryptionPolicy();
            EncryptionPolicy.FeatureBinding epFB = (EncryptionPolicy.FeatureBinding)ep.getFeatureBinding();
            EncryptionTarget et = this.eAP.getTargetCreator().newURIEncryptionTarget(this.primarySP.getUUID());
            SecurityPolicyUtil.setName(et, this.primarySP);
            epFB.addTargetBinding(et);
            if (this.foundEncryptTargets && this.isWSS11() && this.requireSC() && encryptSignConfirm && this.getBinding().getSignatureProtection()) {
                this.eAP.process(Target.SIGNATURE_CONFIRMATION, epFB);
            }
        } else {
            EncryptionPolicy.FeatureBinding epFB = (EncryptionPolicy.FeatureBinding)this.primaryEP.getFeatureBinding();
            EncryptionTarget et = this.eAP.getTargetCreator().newURIEncryptionTarget(this.primarySP.getUUID());
            SecurityPolicyUtil.setName(et, this.primarySP);
            epFB.addTargetBinding(et);
            if (this.foundEncryptTargets && this.isWSS11() && this.requireSC() && encryptSignConfirm && this.getBinding().getSignatureProtection()) {
                this.eAP.process(Target.SIGNATURE_CONFIRMATION, epFB);
            }
        }
    }

    protected void protectTimestamp(TimestampPolicy tp) {
        if (this.primarySP != null) {
            SignatureTarget target = this.iAP.getTargetCreator().newURISignatureTarget(tp.getUUID());
            this.iAP.getTargetCreator().addTransform(target);
            SecurityPolicyUtil.setName(target, tp);
            SignaturePolicy.FeatureBinding spFB = (SignaturePolicy.FeatureBinding)this.primarySP.getFeatureBinding();
            spFB.addTargetBinding(target);
        }
    }

    protected void protectToken(WSSPolicy token) {
        if (this.primarySP == null) {
            return;
        }
        if (this.isServer && this.isIncoming || !this.isServer && !this.isIncoming) {
            this.protectToken(token, false);
        }
    }

    protected void protectToken(WSSPolicy token, boolean ignoreSTR) {
        SignatureTargetCreator stc;
        String uuid = token != null ? token.getUUID() : null;
        String uid = null;
        String includeToken = ((KeyBindingBase)token).getIncludeToken();
        boolean strIgnore = false;
        QName qName = null;
        if (includeToken.endsWith("Always") || includeToken.endsWith("AlwaysToRecipient") || includeToken.endsWith("Once")) {
            strIgnore = true;
        }
        if (PolicyTypeUtil.usernameTokenBinding(token)) {
            uid = ((AuthenticationTokenPolicy.UsernameTokenBinding)token).getUUID();
            if (uid == null) {
                uid = this.pid.generateID();
                ((AuthenticationTokenPolicy.UsernameTokenBinding)token).setSTRID(uid);
            }
            strIgnore = true;
            qName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
        } else if (PolicyTypeUtil.x509CertificateBinding(token)) {
            uid = ((AuthenticationTokenPolicy.X509CertificateBinding)token).getSTRID();
            if (uid == null) {
                uid = this.pid.generateID();
                ((AuthenticationTokenPolicy.X509CertificateBinding)token).setSTRID(uid);
            }
            qName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken");
        } else if (PolicyTypeUtil.samlTokenPolicy(token)) {
            uid = this.generateSAMLSTRID();
            ((AuthenticationTokenPolicy.SAMLAssertionBinding)token).setSTRID(uid);
            qName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Assertion");
        } else if (PolicyTypeUtil.issuedTokenKeyBinding(token)) {
            IssuedTokenKeyBinding itb = (IssuedTokenKeyBinding)token;
            uid = itb.getSTRID();
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(itb.getTokenType()) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(itb.getTokenType())) {
                uid = this.generateSAMLSTRID();
                itb.setSTRID(uid);
                uuid = uid;
            }
            if (uid == null) {
                uid = this.pid.generateID();
                itb.setSTRID(uid);
            }
        } else if (PolicyTypeUtil.secureConversationTokenKeyBinding(token)) {
            SecureConversationTokenKeyBinding sctBinding = (SecureConversationTokenKeyBinding)token;
        }
        if (includeToken.endsWith("Never") || PolicyTypeUtil.samlTokenPolicy(token) || PolicyTypeUtil.issuedTokenKeyBinding(token)) {
            uuid = uid;
        }
        if (!ignoreSTR) {
            if (uuid != null) {
                stc = this.iAP.getTargetCreator();
                SignatureTarget st = stc.newURISignatureTarget(uuid);
                if (!strIgnore) {
                    stc.addSTRTransform(st);
                    st.setPolicyName(qName);
                } else {
                    stc.addTransform(st);
                }
                SignaturePolicy.FeatureBinding fb = (SignaturePolicy.FeatureBinding)this.primarySP.getFeatureBinding();
                fb.addTargetBinding(st);
            }
        } else {
            WSSPolicy kbd;
            stc = this.iAP.getTargetCreator();
            SignatureTarget st = null;
            st = PolicyTypeUtil.derivedTokenKeyBinding(token) ? (PolicyTypeUtil.symmetricKeyBinding(kbd = ((DerivedTokenKeyBinding)token).getOriginalKeyBinding()) ? stc.newURISignatureTarget(uuid) : stc.newURISignatureTarget(uuid)) : stc.newURISignatureTarget(uuid);
            if (st != null) {
                if (!strIgnore) {
                    stc.addSTRTransform(st);
                    st.setPolicyName(qName);
                } else {
                    stc.addTransform(st);
                }
                SignaturePolicy.FeatureBinding fb = (SignaturePolicy.FeatureBinding)this.primarySP.getFeatureBinding();
                fb.addTargetBinding(st);
            }
        }
    }

    protected abstract EncryptionPolicy getSecondaryEncryptionPolicy() throws PolicyException;

    private String generateSAMLSTRID() {
        StringBuilder sb = new StringBuilder();
        sb.append("SAML");
        sb.append(this.pid.generateID());
        return sb.toString();
    }

    protected void addPrimaryTargets() throws PolicyException {
        SignaturePolicy.FeatureBinding spFB = null;
        if (this.primarySP != null) {
            spFB = (SignaturePolicy.FeatureBinding)this.primarySP.getFeatureBinding();
        }
        EncryptionPolicy.FeatureBinding epFB = null;
        if (this.primaryEP != null) {
            epFB = (EncryptionPolicy.FeatureBinding)this.primaryEP.getFeatureBinding();
        }
        if (spFB != null) {
            if (spFB.getCanonicalizationAlgorithm() == null || spFB.getCanonicalizationAlgorithm().equals("")) {
                spFB.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            }
            for (SignedElements se : this.signedElements) {
                this.iAP.process(se, spFB);
            }
            for (SignedParts sp : this.signedParts) {
                if (!SecurityPolicyUtil.isSignedPartsEmpty(sp)) continue;
                this.signedParts.removeAllElements();
                this.signedParts.add(sp);
                break;
            }
            for (SignedParts sp : this.signedParts) {
                this.iAP.process(sp, spFB);
            }
            if (this.isWSS11() && this.requireSC()) {
                this.iAP.process(Target.SIGNATURE_CONFIRMATION, spFB);
            }
        }
        if (epFB != null) {
            for (EncryptedParts ep : this.encryptedParts) {
                this.foundEncryptTargets = true;
                this.eAP.process(ep, epFB);
            }
            for (EncryptedElements encEl : this.encryptedElements) {
                this.foundEncryptTargets = true;
                this.eAP.process(encEl, epFB);
            }
        }
    }

    protected boolean requireSC() {
        return this.wss11 != null && this.wss11.getRequiredProperties() != null && this.wss11.getRequiredProperties().contains("RequireSignatureConfirmation");
    }

    protected abstract Binding getBinding();

    public void processSupportingTokens(SupportingTokens st) throws PolicyException {
        SupportingTokensProcessor stp = new SupportingTokensProcessor(st, this.tokenProcessor, this.getBinding(), this.container, this.primarySP, this.getEncryptionPolicy(), this.pid);
        stp.process();
    }

    public void processSupportingTokens(SignedSupportingTokens st) throws PolicyException {
        SignedSupportingTokensProcessor stp = new SignedSupportingTokensProcessor(st, this.tokenProcessor, this.getBinding(), this.container, this.primarySP, this.getEncryptionPolicy(), this.pid);
        stp.process();
    }

    public void processSupportingTokens(EndorsingSupportingTokens est) throws PolicyException {
        EndorsingSupportingTokensProcessor stp = new EndorsingSupportingTokensProcessor(est, this.tokenProcessor, this.getBinding(), this.container, this.primarySP, this.getEncryptionPolicy(), this.pid);
        stp.process();
    }

    public void processSupportingTokens(SignedEndorsingSupportingTokens est) throws PolicyException {
        SignedEndorsingSupportingTokensProcessor stp = new SignedEndorsingSupportingTokensProcessor(est, this.tokenProcessor, this.getBinding(), this.container, this.primarySP, this.getEncryptionPolicy(), this.pid);
        stp.process();
    }

    public void processSupportingTokens(SignedEncryptedSupportingTokens sest) throws PolicyException {
        SignedEncryptedSupportingTokensProcessor setp = new SignedEncryptedSupportingTokensProcessor(sest, this.tokenProcessor, this.getBinding(), this.container, this.primarySP, this.getEncryptionPolicy(), this.pid);
        setp.process();
        this.isIssuedTokenAsEncryptedSupportingToken(setp.isIssuedTokenAsEncryptedSupportingToken());
    }

    public void processSupportingTokens(EncryptedSupportingTokens est) throws PolicyException {
        EncryptedSupportingTokensProcessor etp = new EncryptedSupportingTokensProcessor(est, this.tokenProcessor, this.getBinding(), this.container, this.primarySP, this.getEncryptionPolicy(), this.pid);
        etp.process();
        this.isIssuedTokenAsEncryptedSupportingToken(etp.isIssuedTokenAsEncryptedSupportingToken());
    }

    public void processSupportingTokens(EndorsingEncryptedSupportingTokens est) throws PolicyException {
        EndorsingEncryptedSupportingTokensProcessor etp = new EndorsingEncryptedSupportingTokensProcessor(est, this.tokenProcessor, this.getBinding(), this.container, this.primarySP, this.getEncryptionPolicy(), this.pid);
        etp.process();
        this.isIssuedTokenAsEncryptedSupportingToken(etp.isIssuedTokenAsEncryptedSupportingToken());
    }

    public void processSupportingTokens(SignedEndorsingEncryptedSupportingTokens est) throws PolicyException {
        SignedEndorsingEncryptedSupportingTokensProcessor etp = new SignedEndorsingEncryptedSupportingTokensProcessor(est, this.tokenProcessor, this.getBinding(), this.container, this.primarySP, this.getEncryptionPolicy(), this.pid);
        etp.process();
        this.isIssuedTokenAsEncryptedSupportingToken(etp.isIssuedTokenAsEncryptedSupportingToken());
    }

    protected SignaturePolicy getSignaturePolicy() {
        if ("SignBeforeEncrypting".equals(this.getBinding().getProtectionOrder())) {
            return this.primarySP;
        }
        return this.sSigPolicy;
    }

    private EncryptionPolicy getEncryptionPolicy() throws PolicyException {
        if ("SignBeforeEncrypting".equals(this.getBinding().getProtectionOrder())) {
            return this.primaryEP;
        }
        return this.getSecondaryEncryptionPolicy();
    }

    protected abstract void close();

    public boolean isWSS11() {
        return this.wss11 != null;
    }

    public void setWSS11(WSSAssertion wss11) {
        this.wss11 = wss11;
    }

    public boolean isIssuedTokenAsEncryptedSupportingToken() {
        return this.isIssuedTokenAsEncryptedSupportingToken;
    }

    private void isIssuedTokenAsEncryptedSupportingToken(boolean value) {
        this.isIssuedTokenAsEncryptedSupportingToken = value;
    }
}

