/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.jaxws;

import com.sun.xml.ws.api.policy.PolicyResolver;
import com.sun.xml.ws.api.policy.PolicyResolverFactory;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapMutator;
import com.sun.xml.ws.policy.WsitPolicyUtil;
import com.sun.xml.ws.policy.jaxws.PolicyConfigParser;
import com.sun.xml.ws.policy.jaxws.privateutil.LocalizationMessages;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import java.net.URL;
import java.util.Collection;
import javax.xml.ws.WebServiceException;

public class WsitPolicyResolver
implements PolicyResolver {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(WsitPolicyResolver.class);

    public PolicyMap resolve(PolicyResolver.ServerContext context) throws WebServiceException {
        String configId;
        Class endpointClass = context.getEndpointClass();
        String string2 = configId = endpointClass == null ? null : endpointClass.getName();
        if (!context.hasWsdl()) {
            PolicyMap map = null;
            try {
                Collection<PolicyMapMutator> mutators = context.getMutators();
                map = PolicyConfigParser.parse(configId, context.getContainer(), mutators.toArray(new PolicyMapMutator[mutators.size()]));
            }
            catch (PolicyException e) {
                throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_5006_FAILED_TO_READ_WSIT_CONFIG_FOR_ID(configId), (Throwable)e));
            }
            if (map == null) {
                LOGGER.config(LocalizationMessages.WSP_5008_CREATE_POLICY_MAP_FOR_CONFIG(configId));
            } else {
                WsitPolicyUtil.validateServerPolicyMap(map);
            }
            return map;
        }
        try {
            URL wsitConfigFile;
            if (configId != null && (wsitConfigFile = PolicyConfigParser.findConfigFile(configId, context.getContainer())) != null) {
                LOGGER.warning(LocalizationMessages.WSP_5024_WSIT_CONFIG_AND_WSDL(wsitConfigFile));
            }
            return PolicyResolverFactory.DEFAULT_POLICY_RESOLVER.resolve(context);
        }
        catch (PolicyException e) {
            throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_5023_FIND_WSIT_CONFIG_FAILED(), (Throwable)e));
        }
    }

    public PolicyMap resolve(PolicyResolver.ClientContext context) {
        PolicyMap effectivePolicyMap;
        try {
            PolicyMap clientConfigPolicyMap = PolicyConfigParser.parse("client", context.getContainer(), new PolicyMapMutator[0]);
            if (clientConfigPolicyMap == null) {
                LOGGER.config(LocalizationMessages.WSP_5014_CLIENT_CONFIG_PROCESSING_SKIPPED());
                effectivePolicyMap = context.getPolicyMap();
            } else {
                effectivePolicyMap = WsitPolicyUtil.mergePolicyMap(context.getPolicyMap(), clientConfigPolicyMap);
            }
        }
        catch (PolicyException e) {
            throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_5004_ERROR_WHILE_PROCESSING_CLIENT_CONFIG(), (Throwable)e));
        }
        if (effectivePolicyMap != null) {
            return WsitPolicyUtil.doAlternativeSelection(effectivePolicyMap);
        }
        return null;
    }
}

