/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.policy.spi_impl;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.spi.PolicyFeatureConfigurator;
import com.sun.xml.ws.rx.mc.MakeConnectionSupportedFeature;
import com.sun.xml.ws.rx.policy.assertion.RmConfigurator;
import com.sun.xml.ws.rx.policy.assertion.wsmc200702.MakeConnectionSupportedAssertion;
import com.sun.xml.ws.rx.rm.ReliableMessagingFeatureBuilder;
import com.sun.xml.ws.rx.rm.RmVersion;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RxFeatureConfigurator
implements PolicyFeatureConfigurator {
    private static final Logger LOGGER = Logger.getLogger(RxFeatureConfigurator.class);

    @Override
    public Collection<WebServiceFeature> getFeatures(PolicyMapKey key, PolicyMap policyMap) throws PolicyException {
        Policy policy;
        LinkedList<WebServiceFeature> features = new LinkedList<WebServiceFeature>();
        if (key != null && policyMap != null && (policy = policyMap.getEndpointEffectivePolicy(key)) != null) {
            for (AssertionSet alternative : policy) {
                ReliableMessagingFeatureBuilder rmFeatureBuilder = null;
                for (RmVersion rmv : RmVersion.values()) {
                    if (!this.isPresentAndMandatory(alternative, rmv.rmAssertionName)) continue;
                    rmFeatureBuilder = new ReliableMessagingFeatureBuilder(rmv);
                    break;
                }
                if (rmFeatureBuilder != null) {
                    for (PolicyAssertion assertion : alternative) {
                        if (!(assertion instanceof RmConfigurator)) continue;
                        RmConfigurator rmAssertion = (RmConfigurator)RmConfigurator.class.cast(assertion);
                        if (!rmAssertion.isCompatibleWith(rmFeatureBuilder.getVersion())) {
                            LOGGER.warning(String.format("Inconsistency detected in a WS-Policy expression:\n[ %s ] assertion is not compatible with WS-ReliableMessaging version [ %s ].\nPlease, update your WS-Policy expression by replacing current assertion with the assertions compatible with the used WS-ReliableMessaging version. Note that future Metro release may decide reject such inconsistent policies and fail to deploy your web service.", new Object[]{rmAssertion.getName(), rmFeatureBuilder.getVersion()}));
                        }
                        rmFeatureBuilder = rmAssertion.update(rmFeatureBuilder);
                    }
                    features.add(rmFeatureBuilder.build());
                }
                if (!this.isPresentAndMandatory(alternative, MakeConnectionSupportedAssertion.NAME)) continue;
                features.add(new MakeConnectionSupportedFeature());
            }
        }
        return features;
    }

    private Collection<PolicyAssertion> getAssertionsWithName(AssertionSet alternative, QName name) throws PolicyException {
        Collection<PolicyAssertion> assertions = alternative.get(name);
        if (assertions.size() > 1) {
            throw LOGGER.logSevereException(new PolicyException(String.format("%n duplicate [%s] policy assertions in a single policy alternative detected", assertions.size(), name)));
        }
        return assertions;
    }

    private boolean isPresentAndMandatory(AssertionSet alternative, QName assertionName) throws PolicyException {
        Collection<PolicyAssertion> assertions = this.getAssertionsWithName(alternative, assertionName);
        for (PolicyAssertion assertion : assertions) {
            if (assertion.isOptional()) continue;
            return true;
        }
        return false;
    }
}

