/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessageBase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class JaxwsApplicationMessage
extends ApplicationMessageBase {
    private static final Logger LOGGER = Logger.getLogger(JaxwsApplicationMessage.class);
    @Nullable
    private Packet packet;
    @NotNull
    private final Message message;
    @Nullable
    private final String wsaAction;

    public JaxwsApplicationMessage(@NotNull Packet packet, @NotNull String correlationId) {
        super(correlationId);
        assert (packet != null);
        assert (packet.getMessage() != null);
        this.packet = packet;
        this.message = packet.getMessage();
        this.wsaAction = null;
    }

    private JaxwsApplicationMessage(int initialResendCounterValue, @NotNull String correlationId, @NotNull String wsaAction, @NotNull String sequenceId, long messageNumber, Message message) {
        super(initialResendCounterValue, correlationId, sequenceId, messageNumber, null);
        assert (message != null);
        this.packet = null;
        this.message = message;
        this.wsaAction = wsaAction;
    }

    @NotNull
    public Message getJaxwsMessage() {
        return this.message;
    }

    @NotNull
    public Packet getPacket() {
        return this.packet;
    }

    void setPacket(Packet newPacket) {
        newPacket.setMessage(this.message);
        this.packet = newPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this.message != null) {
                XMLStreamWriter xsw = XMLStreamWriterFactory.create(baos, "UTF-8");
                try {
                    this.packet.getMessage().copy().writeTo(xsw);
                }
                catch (XMLStreamException ex) {
                    throw LOGGER.logSevereException(new RxRuntimeException("Unable to serialize message to XML stream", ex));
                }
                finally {
                    try {
                        xsw.close();
                    }
                    catch (XMLStreamException ex) {
                        LOGGER.warning("Error closing XMLStreamWriter after message was serialized to XML stream", ex);
                    }
                }
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException ex) {
                LOGGER.warning("Error closing ByteArrayOutputStream after message was serialized to bytes", ex);
            }
        }
    }

    public String getWsaAction() {
        return this.wsaAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JaxwsApplicationMessage newInstance(@NotNull InputStream dataStream, int initialResendCounterValue, @NotNull String correlationId, @NotNull String wsaAction, @NotNull String sequenceId, long messageNumber) {
        try {
            JaxwsApplicationMessage jaxwsApplicationMessage;
            XMLStreamReader xsr = XMLStreamReaderFactory.create(null, dataStream, "UTF-8", true);
            try {
                Message m = Messages.create(xsr);
                jaxwsApplicationMessage = new JaxwsApplicationMessage(initialResendCounterValue, correlationId, wsaAction, sequenceId, messageNumber, m);
            }
            catch (Throwable throwable) {
                try {
                    xsr.close();
                }
                catch (XMLStreamException ex) {
                    LOGGER.warning("Error closing XMLStreamReader after message was de-serialized from XML stream", ex);
                }
                throw throwable;
            }
            try {
                xsr.close();
            }
            catch (XMLStreamException ex) {
                LOGGER.warning("Error closing XMLStreamReader after message was de-serialized from XML stream", ex);
            }
            return jaxwsApplicationMessage;
        }
        finally {
            try {
                dataStream.close();
            }
            catch (IOException ex) {
                LOGGER.warning("Error closing data input stream after message was de-serialized from bytes", ex);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JAX-WS Application Message { ");
        sb.append("sequenceId=[ ").append(this.getSequenceId()).append(" ], ");
        sb.append("messageNumber=[ ").append(this.getMessageNumber()).append(" ], ");
        sb.append("correlationId=[ ").append(this.getCorrelationId()).append(" ], ");
        sb.append("nextResendCount=[ ").append(this.getNextResendCount()).append(" ], ");
        sb.append("wsaAction=[ ").append(this.wsaAction);
        sb.append(" ] }");
        return super.toString();
    }
}

