/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.marshaller;

import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import com.sun.xml.bind.marshaller.DataWriter;
import com.sun.xml.bind.marshaller.DumbEscapeHandler;
import com.sun.xml.bind.marshaller.Messages;
import com.sun.xml.bind.marshaller.NioEscapeHandler;
import com.sun.xml.bind.marshaller.SAX2DOMEx;
import com.sun.xml.bind.marshaller.SAXMarshaller;
import com.sun.xml.bind.marshaller.SchemaLocationFilter;
import com.sun.xml.bind.marshaller.XMLWriter;
import com.sun.xml.bind.serializer.XMLSerializable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.helpers.AbstractMarshallerImpl;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class MarshallerImpl
extends AbstractMarshallerImpl {
    private String indent = "    ";
    private CharacterEscapeHandler escapeHandler = null;
    private static final String INDENT_STRING = "com.sun.xml.bind.indentString";
    private static final String ENCODING_HANDLER = "com.sun.xml.bind.characterEscapeHandler";

    public MarshallerImpl() {
        DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)DatatypeConverterImpl.theInstance);
    }

    public void marshal(Object obj, Result result) throws JAXBException {
        if (!(obj instanceof XMLSerializable) || obj == null) {
            throw new MarshalException(Messages.format("MarshallerImpl.NotMarshallable"));
        }
        XMLSerializable so = (XMLSerializable)obj;
        if (result instanceof SAXResult) {
            this.write(so, ((SAXResult)result).getHandler());
            return;
        }
        if (result instanceof DOMResult) {
            Node node = ((DOMResult)result).getNode();
            if (node == null) {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.newDocument();
                    ((DOMResult)result).setNode(doc);
                    this.write(so, new SAX2DOMEx(doc));
                }
                catch (ParserConfigurationException pce) {
                    throw new InternalError();
                }
            } else {
                this.write(so, new SAX2DOMEx(node));
            }
            return;
        }
        if (result instanceof StreamResult) {
            StreamResult sr = (StreamResult)result;
            XMLWriter w = null;
            if (sr.getWriter() != null) {
                w = this.createWriter(sr.getWriter());
            } else if (sr.getOutputStream() != null) {
                w = this.createWriter(sr.getOutputStream());
            } else if (sr.getSystemId() != null) {
                String fileURL = sr.getSystemId();
                if (fileURL.startsWith("file:///")) {
                    fileURL = fileURL.substring(8).indexOf(":") > 0 ? fileURL.substring(8) : fileURL.substring(7);
                }
                try {
                    w = this.createWriter(new FileOutputStream(fileURL));
                }
                catch (IOException e) {
                    throw new MarshalException((Throwable)e);
                }
            }
            if (w == null) {
                throw new IllegalArgumentException();
            }
            this.write(so, w);
            return;
        }
        throw new MarshalException(Messages.format("MarshallerImpl.UnsupportedResult"));
    }

    private void write(XMLSerializable obj, ContentHandler writer) throws JAXBException {
        try {
            if (this.getSchemaLocation() != null || this.getNoNSSchemaLocation() != null) {
                writer = new SchemaLocationFilter(this.getSchemaLocation(), this.getNoNSSchemaLocation(), writer);
            }
            SAXMarshaller serializer = new SAXMarshaller(writer, this);
            writer.setDocumentLocator(new LocatorImpl());
            writer.startDocument();
            obj.serializeElements(serializer);
            writer.endDocument();
        }
        catch (SAXException e) {
            throw new MarshalException((Throwable)e);
        }
    }

    protected CharacterEscapeHandler createEscapeHandler(String encoding) {
        if (this.escapeHandler != null) {
            return this.escapeHandler;
        }
        try {
            return new NioEscapeHandler(this.getJavaEncoding(encoding));
        }
        catch (Throwable e) {
            return DumbEscapeHandler.theInstance;
        }
    }

    public XMLWriter createWriter(Writer w, String encoding) throws JAXBException {
        CharacterEscapeHandler ceh = this.createEscapeHandler(encoding);
        if (this.isFormattedOutput()) {
            DataWriter d = new DataWriter(w, encoding, ceh);
            d.setIndentStep(this.indent);
            return d;
        }
        return new XMLWriter(w, encoding, ceh);
    }

    public XMLWriter createWriter(Writer w) throws JAXBException {
        return this.createWriter(w, this.getEncoding());
    }

    public XMLWriter createWriter(OutputStream os) throws JAXBException {
        return this.createWriter(os, this.getEncoding());
    }

    public XMLWriter createWriter(OutputStream os, String encoding) throws JAXBException {
        try {
            return this.createWriter(new OutputStreamWriter(os, this.getJavaEncoding(encoding)), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new MarshalException(Messages.format("MarshallerImpl.UnsupportedEncoding", encoding), (Throwable)e);
        }
    }

    public Object getProperty(String name) throws PropertyException {
        if (INDENT_STRING.equals(name)) {
            return this.indent;
        }
        if (ENCODING_HANDLER.equals(name)) {
            return this.escapeHandler;
        }
        return super.getProperty(name);
    }

    public void setProperty(String name, Object value) throws PropertyException {
        if (INDENT_STRING.equals(name) && value instanceof String) {
            this.indent = (String)value;
            return;
        }
        if (ENCODING_HANDLER.equals(name)) {
            this.escapeHandler = (CharacterEscapeHandler)value;
            return;
        }
        super.setProperty(name, value);
    }
}

