/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.tools.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.glassfish.gmbal.generic.Pair;
import org.glassfish.gmbal.tools.argparser.ArgParser;
import org.glassfish.gmbal.tools.argparser.DefaultValue;
import org.glassfish.gmbal.tools.argparser.Help;
import org.glassfish.gmbal.tools.file.ActionFactory;
import org.glassfish.gmbal.tools.file.Block;
import org.glassfish.gmbal.tools.file.BlockParser;
import org.glassfish.gmbal.tools.file.FileWrapper;
import org.glassfish.gmbal.tools.file.Recognizer;
import org.glassfish.gmbal.tools.file.Scanner;

public class WorkspaceRename {
    private static final String[] SUBSTITUTE_SUFFIXES = new String[]{"c", "h", "java", "sjava", "idl", "htm", "html", "xml", "dtd", "bnd", "tdesc", "policy", "secure", "mc", "mcd", "scm", "vthought", "ksh", "sh", "classlist", "config", "jmk", "properties", "prp", "xjmk", "set", "settings", "data", "txt", "text", "javaref", "idlref"};
    private static final String[] SUBSTITUTE_NAMES = new String[]{"Makefile.corba", "Makefile.example", "ExampleMakefile", "Makefile"};
    private static final String[] COPY_SUFFIXES = new String[]{"sxc", "sxi", "sxw", "odp", "gif", "png", "jar", "zip", "jpg", "pom", "pdf", "doc", "mif", "fm", "book", "zargo", "zuml", "cvsignore", "hgignore", "list", "old", "orig", "rej", "hgtags", "xsl", "bat", "css", "icns"};
    private static final String[] IGNORE_SUFFIXES = new String[]{"swo", "swp", "class", "o"};
    private static final String[] IGNORE_NAMES = new String[]{"NORENAME", "errorfile", "sed_pattern_file.version"};
    private static final String[] IGNORE_DIRS = new String[]{".hg", ".snprj", ".cvs", "SCCS", "obj", "obj_g", "Codemgr_wsdata", "deleted_files", "build", "rename", "freezepoint", "test-output", "webrev", "javadoc"};
    private static final String[][] patterns = new String[][]{{"com.sun.corba.se", "com.sun.corba.VERSION"}, {"com/sun/corba/se", "com/sun/corba/VERSION"}, {"org.apache.bcel", "com.sun.corba.VERSION.org.apache.bcel"}, {"org.apache.regexp", "com.sun.corba.VERSION.org.apache.regexp"}, {"org.objectweb.asm", "com.sun.corba.VERSION.org.objectweb.asm"}};
    private final int verbose;
    private final boolean dryrun;
    private final File source;
    private final File destination;
    private final String version;
    private final boolean copyonly;
    private final boolean expandtabs;

    public static void main(String[] strs) {
        new WorkspaceRename(strs).run();
    }

    private void trace(String msg) {
        System.out.println(msg);
    }

    private FileWrapper makeTargetFileWrapper(FileWrapper arg) {
        String rootName = this.source.getAbsolutePath();
        String sourceName = arg.getAbsoluteName();
        if (this.verbose > 1) {
            this.trace("makeTargetFileWrapper: rootName = " + rootName);
            this.trace("makeTargetFileWrapper: sourceName = " + sourceName);
        }
        if (sourceName.startsWith(rootName)) {
            String targetName = sourceName.indexOf("org/objectweb") >= 0 ? sourceName.substring(rootName.length()).replace("org/objectweb/asm", "com/sun/corba/" + this.version + "/org/objectweb/asm") : sourceName.substring(rootName.length()).replace("com/sun/corba/se", "com/sun/corba/" + this.version);
            File result = new File(this.destination, targetName);
            File resultDir = result.getParentFile();
            boolean res = resultDir.mkdirs();
            if (this.verbose > 1 && !res) {
                this.trace("failed to create directory " + resultDir);
            }
            FileWrapper fwres = new FileWrapper(result);
            if (this.verbose > 1) {
                this.trace("makeTargetFileWrapper: arg = " + arg);
                this.trace("makeTargetFileWrapper: fwres = " + fwres);
            }
            return fwres;
        }
        throw new RuntimeException("makeTargetFileWrapper: arg file " + sourceName + " does not start with root name " + rootName);
    }

    public WorkspaceRename(String[] strs) {
        ArgParser<Arguments> ap = new ArgParser<Arguments>(Arguments.class);
        Arguments args = ap.parse(strs);
        this.version = args.version();
        this.source = args.source();
        this.destination = args.destination();
        this.verbose = args.verbose();
        this.dryrun = args.dryrun();
        this.copyonly = args.copyonly();
        this.expandtabs = args.expandtabs();
        if (this.verbose > 0) {
            this.trace("Main: args:\n" + args);
        }
    }

    private void run() {
        try {
            final byte[] copyBuffer = new byte[262144];
            Scanner.Action copyAction = new Scanner.Action(){

                public String toString() {
                    return "copyAction";
                }

                public boolean evaluate(FileWrapper fw) {
                    try {
                        FileWrapper target = WorkspaceRename.this.makeTargetFileWrapper(fw);
                        if (target.isYoungerThan(fw)) {
                            if (WorkspaceRename.this.verbose > 1) {
                                WorkspaceRename.this.trace("copyAction: copying " + fw + " to " + target);
                            }
                            fw.copyTo(target, copyBuffer);
                        } else if (WorkspaceRename.this.verbose > 1) {
                            WorkspaceRename.this.trace("copyAction: NOT copying " + fw + " to " + target);
                        }
                        return true;
                    }
                    catch (IOException exc) {
                        System.out.println("Exception while processing file " + fw + ": " + exc);
                        exc.printStackTrace();
                        return false;
                    }
                }
            };
            final ArrayList<Pair<String, String>> substitutions = new ArrayList<Pair<String, String>>();
            for (String[] pstrs : patterns) {
                String pattern = pstrs[0];
                String replacement = pstrs[1].replace("VERSION", this.version);
                Pair<String, String> pair = new Pair<String, String>(pattern, replacement);
                substitutions.add(pair);
            }
            Scanner.Action renameAction = new Scanner.Action(){

                public String toString() {
                    return "renameAction";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean evaluate(FileWrapper fw) {
                    FileWrapper target = WorkspaceRename.this.makeTargetFileWrapper(fw);
                    try {
                        if (target.isYoungerThan(fw)) {
                            if (WorkspaceRename.this.verbose > 1) {
                                WorkspaceRename.this.trace("renameAction: renaming " + fw + " to " + target);
                            }
                            Block sourceBlock = BlockParser.getBlock(fw);
                            Block targetBlock = sourceBlock.substitute(substitutions);
                            if (WorkspaceRename.this.expandtabs) {
                                targetBlock = targetBlock.expandTabs();
                            }
                            boolean result = target.delete();
                            if (WorkspaceRename.this.verbose > 1 && !result) {
                                WorkspaceRename.this.trace("renameAction: failed to delete file " + target);
                            }
                            target.open(FileWrapper.OpenMode.WRITE);
                            targetBlock.write(target);
                        } else if (WorkspaceRename.this.verbose > 1) {
                            WorkspaceRename.this.trace("renameAction: NOT renaming " + fw + " to " + target);
                        }
                        boolean sourceBlock = true;
                        return sourceBlock;
                    }
                    catch (IOException exc) {
                        System.out.println("Exception while processing file " + fw + ": " + exc);
                        exc.printStackTrace();
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        target.close();
                    }
                }
            };
            ActionFactory af = new ActionFactory(this.verbose, this.dryrun);
            Recognizer recognizer = af.getRecognizerAction();
            Scanner.Action skipAction = af.getSkipAction();
            Scanner.Action action = this.copyonly ? copyAction : renameAction;
            for (String str : SUBSTITUTE_SUFFIXES) {
                recognizer.addKnownSuffix(str, action);
            }
            for (String str : SUBSTITUTE_NAMES) {
                recognizer.addKnownName(str, action);
            }
            recognizer.setShellScriptAction(action);
            for (String str : COPY_SUFFIXES) {
                recognizer.addKnownSuffix(str, copyAction);
            }
            for (String str : IGNORE_SUFFIXES) {
                recognizer.addKnownSuffix(str, skipAction);
            }
            for (String str : IGNORE_NAMES) {
                recognizer.addKnownName(str, skipAction);
            }
            if (this.verbose > 0) {
                this.trace("Main: contents of recognizer:");
                recognizer.dump();
            }
            Scanner scanner = new Scanner(this.verbose, this.source);
            for (String str : IGNORE_DIRS) {
                scanner.addDirectoryToSkip(str);
            }
            scanner.scan(recognizer);
        }
        catch (IOException exc) {
            System.out.println("Exception while processing: " + exc);
            exc.printStackTrace();
        }
    }

    private static interface Arguments {
        @Help(value="Set to >0 to get information about actions taken for every file.  Larger values give more detail.")
        @DefaultValue(value="0")
        public int verbose();

        @Help(value="Set to true to avoid modifying any files")
        @DefaultValue(value="false")
        public boolean dryrun();

        @Help(value="Source directory for rename")
        @DefaultValue(value="")
        public File source();

        @Help(value="Destination directory for rename")
        @DefaultValue(value="")
        public File destination();

        @Help(value="The renamed package")
        @DefaultValue(value="ee")
        public String version();

        @Help(value="If true, copy all files without renaming anything")
        @DefaultValue(value="false")
        public boolean copyonly();

        @Help(value="If true, expand all tabs into spaces on files that are renamed (all text file)")
        @DefaultValue(value="true")
        public boolean expandtabs();
    }
}

