/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.ws.addressing.EPRSDDocumentFilter;
import com.sun.xml.ws.addressing.WSEPRExtension;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.ws.api.pipe.ServerPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.TubelineAssembler;
import com.sun.xml.ws.api.pipe.TubelineAssemblerFactory;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.EndpointAwareCodec;
import com.sun.xml.ws.api.server.EndpointComponent;
import com.sun.xml.ws.api.server.EndpointReferenceExtensionContributor;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.ws.model.wsdl.WSDLProperties;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.resources.HandlerMessages;
import com.sun.xml.ws.server.InvokerTube;
import com.sun.xml.ws.server.MonitorRootService;
import com.sun.xml.ws.server.ServiceDefinitionImpl;
import com.sun.xml.ws.util.Pool;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.wsdl.OperationDispatcher;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import org.glassfish.gmbal.ManagedObjectManager;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSEndpointImpl<T>
extends WSEndpoint<T> {
    @NotNull
    private final QName serviceName;
    @NotNull
    private final QName portName;
    private final WSBinding binding;
    private final SEIModel seiModel;
    @NotNull
    private final Container container;
    private final WSDLPort port;
    private final Tube masterTubeline;
    private final ServiceDefinitionImpl serviceDef;
    private final SOAPVersion soapVersion;
    private final Engine engine;
    @NotNull
    private final Codec masterCodec;
    @NotNull
    private final PolicyMap endpointPolicy;
    private final Pool<Tube> tubePool;
    private final OperationDispatcher operationDispatcher;
    @NotNull
    private final ManagedObjectManager managedObjectManager;
    @NotNull
    private final ServerTubeAssemblerContext context;
    private Map<QName, WSEndpointReference.EPRExtension> endpointReferenceExtensions = new HashMap<QName, WSEndpointReference.EPRExtension>();
    private boolean disposed;
    private final Class<T> implementationClass;
    @Nullable
    private final WSDLProperties wsdlProperties;
    private final Set<EndpointComponent> componentRegistry = new LinkedHashSet<EndpointComponent>();
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.endpoint");

    WSEndpointImpl(@NotNull QName serviceName, @NotNull QName portName, WSBinding binding, Container container, SEIModel seiModel, WSDLPort port, Class<T> implementationClass, @Nullable ServiceDefinitionImpl serviceDef, InvokerTube terminalTube, boolean isSynchronous, PolicyMap endpointPolicy) {
        this.serviceName = serviceName;
        this.portName = portName;
        this.binding = binding;
        this.soapVersion = binding.getSOAPVersion();
        this.container = container;
        this.port = port;
        this.implementationClass = implementationClass;
        this.serviceDef = serviceDef;
        this.seiModel = seiModel;
        this.endpointPolicy = endpointPolicy;
        this.managedObjectManager = this.createManagedObjectManager(serviceName, portName);
        if (serviceDef != null) {
            serviceDef.setOwner(this);
        }
        TubelineAssembler assembler = TubelineAssemblerFactory.create(Thread.currentThread().getContextClassLoader(), binding.getBindingId(), container);
        assert (assembler != null);
        this.operationDispatcher = port == null ? null : new OperationDispatcher(port, binding, seiModel);
        this.context = new ServerPipeAssemblerContext(seiModel, port, this, terminalTube, isSynchronous);
        this.masterTubeline = assembler.createServer(this.context);
        Codec c = this.context.getCodec();
        if (c instanceof EndpointAwareCodec) {
            c = c.copy();
            ((EndpointAwareCodec)c).setEndpoint(this);
        }
        this.masterCodec = c;
        this.tubePool = new Pool.TubePool(this.masterTubeline);
        terminalTube.setEndpoint(this);
        this.engine = new Engine(this.toString());
        this.wsdlProperties = port == null ? null : new WSDLProperties(port);
        HashMap<QName, WSEndpointReference.EPRExtension> eprExtensions = new HashMap<QName, WSEndpointReference.EPRExtension>();
        try {
            EndpointReferenceExtensionContributor[] eprExtnContributors;
            WSEndpointReference wsdlEpr;
            if (port != null && (wsdlEpr = ((WSDLPortImpl)port).getEPR()) != null) {
                for (WSEndpointReference.EPRExtension extnEl : wsdlEpr.getEPRExtensions()) {
                    eprExtensions.put(extnEl.getQName(), extnEl);
                }
            }
            for (EndpointReferenceExtensionContributor eprExtnContributor : eprExtnContributors = ServiceFinder.find(EndpointReferenceExtensionContributor.class).toArray()) {
                WSEndpointReference.EPRExtension wsdlEPRExtn = (WSEndpointReference.EPRExtension)eprExtensions.remove(eprExtnContributor.getQName());
                WSEndpointReference.EPRExtension endpointEprExtn = eprExtnContributor.getEPRExtension(this, wsdlEPRExtn);
                if (endpointEprExtn == null) continue;
                eprExtensions.put(endpointEprExtn.getQName(), endpointEprExtn);
            }
            for (WSEndpointReference.EPRExtension extn : eprExtensions.values()) {
                this.endpointReferenceExtensions.put(extn.getQName(), new WSEPRExtension(XMLStreamBuffer.createNewBufferFromXMLStreamReader(extn.readAsXMLStreamReader()), extn.getQName()));
            }
        }
        catch (XMLStreamException ex) {
            throw new WebServiceException((Throwable)ex);
        }
        if (!eprExtensions.isEmpty()) {
            serviceDef.addFilter(new EPRSDDocumentFilter(this));
        }
    }

    public Collection<WSEndpointReference.EPRExtension> getEndpointReferenceExtensions() {
        return this.endpointReferenceExtensions.values();
    }

    @Nullable
    public OperationDispatcher getOperationDispatcher() {
        return this.operationDispatcher;
    }

    @Override
    public PolicyMap getPolicyMap() {
        return this.endpointPolicy;
    }

    @Override
    @NotNull
    public Class<T> getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    @NotNull
    public WSBinding getBinding() {
        return this.binding;
    }

    @Override
    @NotNull
    public Container getContainer() {
        return this.container;
    }

    @Override
    public WSDLPort getPort() {
        return this.port;
    }

    @Override
    @Nullable
    public SEIModel getSEIModel() {
        return this.seiModel;
    }

    @Override
    public void setExecutor(Executor exec) {
        this.engine.setExecutor(exec);
    }

    @Override
    public void schedule(final Packet request, final WSEndpoint.CompletionCallback callback, FiberContextSwitchInterceptor interceptor) {
        request.endpoint = this;
        if (this.wsdlProperties != null) {
            request.addSatellite(this.wsdlProperties);
        }
        Fiber fiber = this.engine.createFiber();
        if (interceptor != null) {
            fiber.addInterceptor(interceptor);
        }
        final Tube tube = this.tubePool.take();
        fiber.start(tube, request, new Fiber.CompletionCallback(){

            public void onCompletion(@NotNull Packet response) {
                WSEndpointImpl.this.tubePool.recycle(tube);
                if (callback != null) {
                    callback.onCompletion(response);
                }
            }

            public void onCompletion(@NotNull Throwable error) {
                error.printStackTrace();
                Message faultMsg = SOAPFaultBuilder.createSOAPFaultMessage(WSEndpointImpl.this.soapVersion, null, error);
                Packet response = request.createServerResponse(faultMsg, request.endpoint.getPort(), null, request.endpoint.getBinding());
                if (callback != null) {
                    callback.onCompletion(response);
                }
            }
        });
    }

    @Override
    @NotNull
    public WSEndpoint.PipeHead createPipeHead() {
        return new WSEndpoint.PipeHead(){
            private final Tube tube;
            {
                this.tube = TubeCloner.clone(WSEndpointImpl.this.masterTubeline);
            }

            @NotNull
            public Packet process(Packet request, WebServiceContextDelegate wscd, TransportBackChannel tbc) {
                Packet response;
                request.webServiceContextDelegate = wscd;
                request.transportBackChannel = tbc;
                request.endpoint = WSEndpointImpl.this;
                if (WSEndpointImpl.this.wsdlProperties != null) {
                    request.addSatellite(WSEndpointImpl.this.wsdlProperties);
                }
                Fiber fiber = WSEndpointImpl.this.engine.createFiber();
                try {
                    response = fiber.runSync(this.tube, request);
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                    Message faultMsg = SOAPFaultBuilder.createSOAPFaultMessage(WSEndpointImpl.this.soapVersion, null, re);
                    response = request.createServerResponse(faultMsg, request.endpoint.getPort(), null, request.endpoint.getBinding());
                }
                return response;
            }
        };
    }

    @Override
    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.masterTubeline.preDestroy();
        block4: for (Handler handler : this.binding.getHandlerChain()) {
            for (Method method : handler.getClass().getMethods()) {
                if (method.getAnnotation(PreDestroy.class) == null) continue;
                try {
                    method.invoke((Object)handler, new Object[0]);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, HandlerMessages.HANDLER_PREDESTROY_IGNORE(e.getMessage()), e);
                }
                continue block4;
            }
        }
        try {
            this.managedObjectManager.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "TBD", e);
        }
    }

    @Override
    public ServiceDefinitionImpl getServiceDefinition() {
        return this.serviceDef;
    }

    @Override
    public Set<EndpointComponent> getComponentRegistry() {
        return this.componentRegistry;
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, String address, String wsdlAddress, Element ... referenceParameters) {
        List<Element> refParams = null;
        if (referenceParameters != null) {
            refParams = Arrays.asList(referenceParameters);
        }
        return this.getEndpointReference(clazz, address, wsdlAddress, null, refParams);
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, String address, String wsdlAddress, List<Element> metadata, List<Element> referenceParameters) {
        QName portType = null;
        if (this.port != null) {
            portType = this.port.getBinding().getPortTypeName();
        }
        AddressingVersion av = AddressingVersion.fromSpecClass(clazz);
        return new WSEndpointReference(av, address, this.serviceName, this.portName, portType, metadata, wsdlAddress, referenceParameters, this.endpointReferenceExtensions.values(), null).toSpec(clazz);
    }

    @Override
    @NotNull
    public QName getPortName() {
        return this.portName;
    }

    @Override
    @NotNull
    public Codec createCodec() {
        return this.masterCodec.copy();
    }

    @Override
    @NotNull
    public QName getServiceName() {
        return this.serviceName;
    }

    @Override
    @NotNull
    public ManagedObjectManager getManagedObjectManager() {
        return this.managedObjectManager;
    }

    @Override
    @NotNull
    public ServerTubeAssemblerContext getAssemblerContext() {
        return this.context;
    }

    @NotNull
    private ManagedObjectManager createManagedObjectManager(QName serviceName, QName portName) {
        String rootName = serviceName.toString() + portName.toString();
        if (rootName.equals("")) {
            rootName = "provider";
        }
        return new MonitorRootService(this).createManagedObjectManager(true, rootName);
    }
}

