/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.config.management;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.config.management.CommunicationServer;
import com.sun.xml.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.ws.api.config.management.EndpointStarter;
import com.sun.xml.ws.api.config.management.ManagedHttpMetadataPublisher;
import com.sun.xml.ws.api.config.management.ManagementFactory;
import com.sun.xml.ws.api.config.management.NamedParameters;
import com.sun.xml.ws.api.config.management.ReconfigNotifier;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.EndpointComponent;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.config.management.ManagementUtil;
import com.sun.xml.ws.policy.PolicyMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.glassfish.gmbal.ManagedObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedEndpoint<T>
extends WSEndpoint<T>
implements EndpointStarter {
    public static final String ENDPOINT_ID_PARAMETER_NAME = "ENDPOINT_ID";
    public static final String ENDPOINT_INSTANCE_PARAMETER_NAME = "ENDPOINT_INSTANCE";
    public static final String CREATION_ATTRIBUTES_PARAMETER_NAME = "CREATION_ATTRIBUTES";
    public static final String CLASS_LOADER_PARAMETER_NAME = "CLASS_LOADER";
    public static final String ENDPOINT_STARTER_PARAMETER_NAME = "ENDPOINT_STARTER";
    private static final Logger LOGGER = Logger.getLogger(ManagedEndpoint.class);
    private final String id;
    private final EndpointCreationAttributes creationAttributes;
    private WSEndpoint<T> endpointDelegate;
    private final CountDownLatch startSignal = new CountDownLatch(1);
    private final Collection<CommunicationServer> commInterfaces;
    private final Collection<ReconfigNotifier> reconfigNotifiers = new LinkedList<ReconfigNotifier>();

    public ManagedEndpoint(String id, WSEndpoint<T> endpoint, EndpointCreationAttributes attributes) {
        try {
            this.id = id;
            this.creationAttributes = attributes;
            this.endpointDelegate = endpoint;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            ManagementFactory factory = new ManagementFactory(ManagementUtil.getAssertion(endpoint));
            NamedParameters parameters = new NamedParameters().put(ENDPOINT_ID_PARAMETER_NAME, this.id).put(ENDPOINT_INSTANCE_PARAMETER_NAME, this).put(CREATION_ATTRIBUTES_PARAMETER_NAME, this.creationAttributes).put(CLASS_LOADER_PARAMETER_NAME, classLoader).put(ENDPOINT_STARTER_PARAMETER_NAME, this);
            this.commInterfaces = factory.createCommunicationImpls(parameters);
            for (CommunicationServer commInterface : this.commInterfaces) {
                commInterface.start();
            }
            this.startSignal.await();
        }
        catch (InterruptedException e) {
            throw LOGGER.logSevereException(new WebServiceException((Throwable)e));
        }
    }

    public void addNotifier(ReconfigNotifier notifier) {
        this.reconfigNotifiers.add(notifier);
    }

    @Override
    public void startEndpoint() {
        this.startSignal.countDown();
        for (ReconfigNotifier notifier : this.reconfigNotifiers) {
            notifier.sendNotification();
        }
    }

    public String getId() {
        return this.id;
    }

    public synchronized void swapEndpointDelegate(WSEndpoint<T> endpoint) {
        Set<EndpointComponent> endpointComponents = endpoint.getComponentRegistry();
        endpointComponents.add(new ManagedHttpMetadataPublisher());
        this.endpointDelegate = endpoint;
        LOGGER.info(ManagementMessages.WSM_5004_RECONFIGURED_ENDPOINT(this.id));
    }

    @Override
    public Codec createCodec() {
        return this.endpointDelegate.createCodec();
    }

    @Override
    public QName getServiceName() {
        return this.endpointDelegate.getServiceName();
    }

    @Override
    public QName getPortName() {
        return this.endpointDelegate.getPortName();
    }

    @Override
    public Class<T> getImplementationClass() {
        return this.endpointDelegate.getImplementationClass();
    }

    @Override
    public WSBinding getBinding() {
        return this.endpointDelegate.getBinding();
    }

    @Override
    public Container getContainer() {
        return this.endpointDelegate.getContainer();
    }

    @Override
    public WSDLPort getPort() {
        return this.endpointDelegate.getPort();
    }

    @Override
    public void setExecutor(Executor exec) {
        this.endpointDelegate.setExecutor(exec);
    }

    @Override
    public void schedule(Packet request, WSEndpoint.CompletionCallback callback, FiberContextSwitchInterceptor interceptor) {
        this.endpointDelegate.schedule(request, callback, interceptor);
    }

    @Override
    public WSEndpoint.PipeHead createPipeHead() {
        return this.endpointDelegate.createPipeHead();
    }

    @Override
    public void dispose() {
        for (CommunicationServer commInterface : this.commInterfaces) {
            commInterface.stop();
        }
        if (this.endpointDelegate != null) {
            this.endpointDelegate.dispose();
        }
    }

    @Override
    public ServiceDefinition getServiceDefinition() {
        return this.endpointDelegate.getServiceDefinition();
    }

    @Override
    public Set<EndpointComponent> getComponentRegistry() {
        return this.endpointDelegate.getComponentRegistry();
    }

    @Override
    public SEIModel getSEIModel() {
        return this.endpointDelegate.getSEIModel();
    }

    @Override
    public PolicyMap getPolicyMap() {
        return this.endpointDelegate.getPolicyMap();
    }

    @Override
    public ManagedObjectManager getManagedObjectManager() {
        return this.endpointDelegate.getManagedObjectManager();
    }

    @Override
    public ServerTubeAssemblerContext getAssemblerContext() {
        return this.endpointDelegate.getAssemblerContext();
    }
}

