/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.parser.handler;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import org.jvnet.wom.api.parser.WSDLEventReceiver;
import org.jvnet.wom.api.parser.WSDLEventSource;
import org.jvnet.wom.impl.parser.handler.AbstractHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class WSDLContentHandler
implements ContentHandler,
WSDLEventSource {
    private Locator locator;
    private final Stack<AttributesImpl> attStack = new Stack();
    private AttributesImpl currentAtts;
    StringBuffer text = new StringBuffer();
    WSDLEventReceiver currentHandler;
    static final String IMPOSSIBLE = "\u0000";
    private ContentHandler redirect = null;
    private int redirectionDepth = 0;
    private final List<String> namespaces = new ArrayList<String>();
    private int nsEffectivePtr = 0;
    private final Stack<Integer> nsEffectiveStack = new Stack();
    NamespaceContext nsContext = new NamespaceContextImpl();
    private int indent = 0;
    private boolean needIndent = true;

    public Locator getLocator() {
        return this.locator;
    }

    public Attributes getCurrentAttributes() {
        return this.currentAtts;
    }

    private void reset() {
        this.attStack.clear();
        this.currentAtts = null;
        this.currentHandler = null;
        this.indent = 0;
        this.locator = null;
        this.namespaces.clear();
        this.needIndent = true;
        this.redirect = null;
        this.redirectionDepth = 0;
        this.text = new StringBuffer();
        this.attStack.push(new AttributesImpl());
    }

    public void setRootHandler(AbstractHandler rootHandler) {
        if (this.currentHandler != null) {
            throw new IllegalStateException();
        }
        this.currentHandler = rootHandler;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        this.currentHandler.leaveElement(IMPOSSIBLE, IMPOSSIBLE, IMPOSSIBLE);
        this.reset();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.redirect != null) {
            this.redirect.startPrefixMapping(prefix, uri);
        } else {
            this.namespaces.add(prefix);
            this.namespaces.add(uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.redirect != null) {
            this.redirect.endPrefixMapping(prefix);
        } else {
            this.namespaces.remove(this.namespaces.size() - 1);
            this.namespaces.remove(this.namespaces.size() - 1);
        }
    }

    public void startElement(String uri, String localname, String qname, Attributes atts) throws SAXException {
        if (this.redirect != null) {
            this.redirect.startElement(uri, localname, qname, atts);
            ++this.redirectionDepth;
        } else {
            this.processPendingText(true);
            this.currentHandler.enterElement(uri, localname, qname, atts);
        }
    }

    public void onEnterElementConsumed(String uri, String localName, String qname, Attributes atts) throws SAXException {
        this.currentAtts = new AttributesImpl(atts);
        this.attStack.push(this.currentAtts);
        this.nsEffectiveStack.push(this.nsEffectivePtr);
        this.nsEffectivePtr = this.namespaces.size();
    }

    public void onLeaveElementConsumed(String uri, String localName, String qname) throws SAXException {
        this.attStack.pop();
        this.currentAtts = this.attStack.isEmpty() ? null : this.attStack.peek();
        this.nsEffectivePtr = this.nsEffectiveStack.pop();
    }

    public void endElement(String uri, String localname, String qname) throws SAXException {
        if (this.redirect != null) {
            this.redirect.endElement(uri, localname, qname);
            --this.redirectionDepth;
            if (this.redirectionDepth != 0) {
                return;
            }
            for (int i = 0; i < this.namespaces.size(); i += 2) {
                this.redirect.endPrefixMapping(this.namespaces.get(i));
            }
            this.redirect.endDocument();
            this.redirect = null;
        } else {
            this.currentHandler.leaveElement(uri, localname, qname);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.redirect != null) {
            this.redirect.characters(ch, start, length);
        } else {
            this.text.append(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.redirect != null) {
            this.redirect.ignorableWhitespace(ch, start, length);
        } else {
            this.text.append(ch, start, length);
        }
    }

    public int getAttributeIndex(String uri, String localname) {
        return this.currentAtts.getIndex(uri, localname);
    }

    public void consumeAttribute(int index) throws SAXException {
        String uri = this.currentAtts.getURI(index);
        String local = this.currentAtts.getLocalName(index);
        String qname = this.currentAtts.getQName(index);
        String value = this.currentAtts.getValue(index);
        this.currentAtts.removeAttribute(index);
        this.currentHandler.enterAttribute(uri, local, qname);
        this.currentHandler.text(value);
        this.currentHandler.leaveAttribute(uri, local, qname);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.redirect != null) {
            this.redirect.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.redirect != null) {
            this.redirect.skippedEntity(name);
        }
    }

    public int replace(WSDLEventReceiver _old, WSDLEventReceiver _new) {
        if (_old != this.currentHandler) {
            throw new IllegalStateException();
        }
        this.currentHandler = _new;
        return 0;
    }

    public void sendEnterElement(int receiverThreadId, String uri, String localName, String qname, Attributes atts) throws SAXException {
        this.currentHandler.enterElement(uri, localName, qname, atts);
    }

    public void sendLeaveElement(int receiverThreadId, String uri, String localName, String qname) throws SAXException {
        this.currentHandler.leaveElement(uri, localName, qname);
    }

    public void sendText(int receiverThreadId, String value) throws SAXException {
        this.currentHandler.text(value);
    }

    public void sendEnterAttribute(int receiverThreadId, String uri, String localName, String qname) throws SAXException {
        this.currentHandler.enterAttribute(uri, localName, qname);
    }

    public void sendLeaveAttribute(int receiverThreadId, String uri, String localName, String qname) throws SAXException {
        this.currentHandler.leaveAttribute(uri, localName, qname);
    }

    private void processPendingText(boolean ignorable) throws SAXException {
        if (!ignorable || this.text.toString().trim().length() != 0) {
            this.currentHandler.text(this.text.toString());
        }
        if (this.text.length() > 1024) {
            this.text = new StringBuffer();
        } else {
            this.text.setLength(0);
        }
    }

    public void processList(String str) throws SAXException {
        StringTokenizer t = new StringTokenizer(str, " \t\r\n");
        while (t.hasMoreTokens()) {
            this.currentHandler.text(t.nextToken());
        }
    }

    public void redirectSubtree(ContentHandler child, String uri, String local, String qname) throws SAXException {
        this.redirect = child;
        this.redirect.setDocumentLocator(this.locator);
        this.redirect.startDocument();
        for (int i = 0; i < this.namespaces.size(); i += 2) {
            this.redirect.startPrefixMapping(this.namespaces.get(i), this.namespaces.get(i + 1));
        }
        this.redirect.startElement(uri, local, qname, this.currentAtts);
        this.redirectionDepth = 1;
    }

    public String resolveNamespacePrefix(String prefix) {
        for (int i = this.nsEffectivePtr - 2; i >= 0; i -= 2) {
            if (!this.namespaces.get(i).equals(prefix)) continue;
            return this.namespaces.get(i + 1);
        }
        if (prefix.equals("")) {
            return "";
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return null;
    }

    protected void unexpectedX(String token) throws SAXException {
        throw new SAXParseException(MessageFormat.format("Unexpected {0} appears at line {1} column {2}", token, this.getLocator().getLineNumber(), this.getLocator().getColumnNumber()), this.getLocator());
    }

    private void printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            System.out.print("  ");
        }
    }

    public void trace(String s) {
        if (this.needIndent) {
            this.needIndent = false;
            this.printIndent();
        }
        System.out.print(s);
    }

    public void traceln(String s) {
        this.trace(s);
        this.trace("\n");
        this.needIndent = true;
    }

    private class NamespaceContextImpl
    implements NamespaceContext {
        private NamespaceContextImpl() {
        }

        public String getNamespaceURI(String prefix) {
            for (int i = WSDLContentHandler.this.nsEffectivePtr - 2; i >= 0; i -= 2) {
                if (!((String)WSDLContentHandler.this.namespaces.get(i)).equals(prefix)) continue;
                return (String)WSDLContentHandler.this.namespaces.get(i + 1);
            }
            if (prefix.equals("")) {
                return "";
            }
            if (prefix.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            return null;
        }

        public String getPrefix(String namespaceURI) {
            for (int i = WSDLContentHandler.this.nsEffectivePtr - 2; i >= 0; i -= 2) {
                if (!((String)WSDLContentHandler.this.namespaces.get(i + 1)).equals(namespaceURI)) continue;
                return (String)WSDLContentHandler.this.namespaces.get(i);
            }
            if (namespaceURI.equals("")) {
                return "";
            }
            if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
                return "xml";
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            String[] prefixes = new String[WSDLContentHandler.this.nsEffectivePtr / 2];
            int i = WSDLContentHandler.this.nsEffectivePtr - 2;
            int j = 0;
            while (i >= 0) {
                prefixes[j] = (String)WSDLContentHandler.this.namespaces.get(i);
                i -= 2;
                ++j;
            }
            return Arrays.asList(prefixes).iterator();
        }
    }
}

