/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSFeatureList;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.server.DummyWebServiceFeature;
import com.sun.xml.ws.util.RuntimeVersion;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.InheritedAttributes;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.ManagedObjectManager;
import org.glassfish.gmbal.ManagedObjectManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedObject
@Description(value="Metro Web Service endpoint")
@AMXMetadata(type="Service")
public final class MonitorRootService {
    private final WSEndpoint endpoint;
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.endpoint");
    private static boolean monitoring = true;
    private static int typelibDebug = -1;
    private static String registrationDebug = "NONE";
    private static boolean runtimeDebug = false;
    private static int maxUniqueEndpointRootNameRetries = 100;

    MonitorRootService(WSEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @ManagedAttribute
    @Description(value="Policy associated with Endpoint")
    public String policy() {
        return this.endpoint.getPolicyMap() != null ? this.endpoint.getPolicyMap().toString() : null;
    }

    @ManagedAttribute
    @Description(value="Container")
    @NotNull
    public Container container() {
        return this.endpoint.getContainer();
    }

    @ManagedAttribute
    @Description(value="Port name")
    @NotNull
    public QName portName() {
        return this.endpoint.getPortName();
    }

    @ManagedAttribute
    @Description(value="Service name")
    @NotNull
    public QName serviceName() {
        return this.endpoint.getServiceName();
    }

    @ManagedAttribute
    @Description(value="The last tube in the dispatch chain")
    @NotNull
    public Tube terminalTube() {
        return this.endpoint.getAssemblerContext().getTerminalTube();
    }

    @ManagedAttribute
    @Description(value="True if tubeline is known to be used for serving synchronous transport")
    public boolean synchronous() {
        return this.endpoint.getAssemblerContext().isSynchronous();
    }

    @ManagedAttribute
    @Description(value="")
    public String codecMimeType() {
        return this.endpoint.getAssemblerContext().getCodec().getMimeType();
    }

    @ManagedAttribute
    @Description(value="Binding SOAP Version")
    public String bindingSOAPVersionHttpBindingId() {
        return this.endpoint.getBinding().getSOAPVersion().httpBindingId;
    }

    @ManagedAttribute
    @Description(value="Binding Addressing Version")
    public AddressingVersion bindingAddressingVersion() {
        return this.endpoint.getBinding().getAddressingVersion();
    }

    @ManagedAttribute
    @Description(value="Binding Addressing Version")
    @NotNull
    public BindingID bindingID() {
        return this.endpoint.getBinding().getBindingId();
    }

    @ManagedAttribute
    @Description(value="Binding features")
    @NotNull
    public WSFeatureList bindingFeatures() {
        return this.endpoint.getBinding().getFeatures();
    }

    @ManagedAttribute
    @Description(value="WSDLPort name")
    public QName wsdlPortName() {
        return this.endpoint.getPort() != null ? this.endpoint.getPort().getName() : null;
    }

    @ManagedAttribute
    @Description(value="WSDLPort bound port type")
    public WSDLBoundPortType wsdlBoundPortType() {
        return this.endpoint.getPort() != null ? this.endpoint.getPort().getBinding() : null;
    }

    @ManagedAttribute
    @Description(value="Endpoint address")
    public EndpointAddress wsdlEndpointAddress() {
        return this.endpoint.getPort() != null ? this.endpoint.getPort().getAddress() : null;
    }

    @ManagedAttribute
    @Description(value="WSDLPort owner")
    public WSDLService wsdlOwner() {
        return this.endpoint.getPort() != null ? this.endpoint.getPort().getOwner() : null;
    }

    @ManagedAttribute
    @Description(value="Service Definition root name")
    public QName serviceDefinitionRootName() {
        return this.endpoint.getServiceDefinition() != null ? this.endpoint.getServiceDefinition().getPrimary().getRootName() : null;
    }

    @ManagedAttribute
    @Description(value="True if this document is WSDL")
    public boolean serviceDefinitionIsWSDL() {
        return this.endpoint.getServiceDefinition() != null ? Boolean.valueOf(this.endpoint.getServiceDefinition().getPrimary().isWSDL()) : null;
    }

    @ManagedAttribute
    @Description(value="True if this document is schema")
    public boolean serviceDefinitionIsSchema() {
        return this.endpoint.getServiceDefinition() != null ? Boolean.valueOf(this.endpoint.getServiceDefinition().getPrimary().isSchema()) : null;
    }

    @ManagedAttribute
    @Description(value="Documents referenced")
    public Set<String> serviceDefinitionImports() {
        return this.endpoint.getServiceDefinition() != null ? this.endpoint.getServiceDefinition().getPrimary().getImports() : null;
    }

    @ManagedAttribute
    @Description(value="System ID where document is taken from")
    public URL serviceDefinitionURL() {
        return this.endpoint.getServiceDefinition() != null ? this.endpoint.getServiceDefinition().getPrimary().getURL() : null;
    }

    @ManagedAttribute
    @Description(value="SEI model WSDL location")
    public String seiModelWSDLLocation() {
        return this.endpoint.getSEIModel() != null ? this.endpoint.getSEIModel().getWSDLLocation() : null;
    }

    @ManagedAttribute
    @Description(value="SEI model service name")
    public QName seiModelServiceName() {
        return this.endpoint.getSEIModel() != null ? this.endpoint.getSEIModel().getServiceQName() : null;
    }

    @ManagedAttribute
    @Description(value="SEI model port name")
    public QName seiModelPortName() {
        return this.endpoint.getSEIModel() != null ? this.endpoint.getSEIModel().getPortName() : null;
    }

    @ManagedAttribute
    @Description(value="SEI model port type name")
    public QName seiModelPortTypeName() {
        return this.endpoint.getSEIModel() != null ? this.endpoint.getSEIModel().getPortTypeName() : null;
    }

    @ManagedAttribute
    @Description(value="SEI model bound port type name")
    public QName seiModelBoundPortTypeName() {
        return this.endpoint.getSEIModel() != null ? this.endpoint.getSEIModel().getBoundPortTypeName() : null;
    }

    @ManagedAttribute
    @Description(value="SEI model target namespace")
    public String seiModelTargetNamespace() {
        return this.endpoint.getSEIModel() != null ? this.endpoint.getSEIModel().getTargetNamespace() : null;
    }

    @ManagedAttribute
    @Description(value="JAX-WS runtime version")
    public String jaxwsRuntimeVersion() {
        return RuntimeVersion.VERSION.toString();
    }

    @NotNull
    ManagedObjectManager createManagedObjectManager(QName serviceName, QName portName) {
        if (!monitoring) {
            return ManagedObjectManagerFactory.createNOOP();
        }
        String sname = serviceName.toString();
        String pname = portName.toString();
        if (sname.equals("") && pname.equals("")) {
            sname = "pro";
            pname = "vider";
        }
        return this.createMOMLoop(sname, pname, 0);
    }

    @NotNull
    private ManagedObjectManager createMOMLoop(String serviceName, String portName, int unique) {
        ManagedObjectManager mom = this.createMOM(this.isFederated());
        mom = this.initMOM(mom);
        mom = this.createRoot(mom, serviceName, portName, unique);
        return mom;
    }

    private ObjectName isFederated() {
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName amxName = new ObjectName("amx:pp=/mon,type=server-mon,name=server");
            return mbeanServer.isRegistered(amxName) ? amxName : null;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "GlassFish AMX monitoring root not available.  Trying standalone.", t);
            return null;
        }
    }

    @NotNull
    private ManagedObjectManager createMOM(ObjectName amxName) {
        boolean isFederated = amxName != null;
        try {
            return isFederated ? ManagedObjectManagerFactory.createFederated(amxName) : ManagedObjectManagerFactory.createStandalone("com.sun.metro");
        }
        catch (Throwable t) {
            if (isFederated) {
                logger.log(Level.WARNING, "Problem while attempting to federate with GlassFish AMX monitoring..  Trying standalone.", t);
                return this.createMOM(null);
            }
            logger.log(Level.WARNING, "TBD - Ignoring exception - starting up without monitoring", t);
            return ManagedObjectManagerFactory.createNOOP();
        }
    }

    @NotNull
    private ManagedObjectManager initMOM(ManagedObjectManager mom) {
        try {
            if (typelibDebug != -1) {
                mom.setTypelibDebug(typelibDebug);
            }
            if (registrationDebug.equals("FINE")) {
                mom.setRegistrationDebug(ManagedObjectManager.RegistrationDebugLevel.FINE);
            } else if (registrationDebug.equals("NORMAL")) {
                mom.setRegistrationDebug(ManagedObjectManager.RegistrationDebugLevel.NORMAL);
            } else {
                mom.setRegistrationDebug(ManagedObjectManager.RegistrationDebugLevel.NONE);
            }
            mom.setRuntimeDebug(runtimeDebug);
            mom.stripPrefix("com.sun.xml.ws.server", "com.sun.xml.ws.rx.rm.runtime.sequence");
            mom.addAnnotation((AnnotatedElement)((Object)WebServiceFeature.class), DummyWebServiceFeature.class.getAnnotation(ManagedData.class));
            mom.addAnnotation((AnnotatedElement)((Object)WebServiceFeature.class), DummyWebServiceFeature.class.getAnnotation(Description.class));
            mom.addAnnotation((AnnotatedElement)((Object)WebServiceFeature.class), DummyWebServiceFeature.class.getAnnotation(InheritedAttributes.class));
            mom.suspendJMXRegistration();
        }
        catch (Throwable t) {
            try {
                mom.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Ignoring exception caught when closing unused ManagedObjectManager", e);
            }
            logger.log(Level.WARNING, "TBD - Ignoring exception - starting up without monitoring", t);
            return ManagedObjectManagerFactory.createNOOP();
        }
        return mom;
    }

    private ManagedObjectManager createRoot(ManagedObjectManager mom, String serviceName, String portName, int unique) {
        String rootName = serviceName.toString() + portName.toString() + (unique == 0 ? "" : "-" + String.valueOf(unique));
        try {
            mom.createRoot(this, rootName);
            logger.log(Level.WARNING, "Monitoring rootname successfully set to: " + rootName);
            return mom;
        }
        catch (Throwable t) {
            try {
                mom.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Ignoring exception caught when closing unused ManagedObjectManager", e);
            }
            if (t.getCause() instanceof InstanceAlreadyExistsException) {
                String basemsg = "duplicate rootname: " + rootName + " : ";
                if (unique > maxUniqueEndpointRootNameRetries) {
                    String msg = basemsg + "Giving up.";
                    logger.log(Level.WARNING, msg, t);
                    return ManagedObjectManagerFactory.createNOOP();
                }
                String msg = basemsg + "Will try to make unique";
                logger.log(Level.WARNING, msg, t);
                return this.createMOMLoop(serviceName, portName, ++unique);
            }
            return ManagedObjectManagerFactory.createNOOP();
        }
    }

    static {
        try {
            Integer i;
            String s = System.getProperty("com.sun.xml.ws.monitoring.endpoint");
            if (s != null && s.toLowerCase().equals("false")) {
                monitoring = false;
            }
            if ((s = System.getProperty("com.sun.xml.ws.monitoring")) != null && s.toLowerCase().equals("false")) {
                monitoring = false;
            }
            if ((i = Integer.getInteger("com.sun.xml.ws.monitoring.typelibDebug")) != null) {
                typelibDebug = i;
            }
            if ((s = System.getProperty("com.sun.xml.ws.monitoring.registrationDebug")) != null) {
                registrationDebug = s.toUpperCase();
            }
            if ((s = System.getProperty("com.sun.xml.ws.monitoring.runtimeDebug")) != null && s.toLowerCase().equals("true")) {
                runtimeDebug = true;
            }
            if ((i = Integer.getInteger("com.sun.xml.ws.monitoring.maxUniqueEndpointRootNameRetries")) != null) {
                maxUniqueEndpointRootNameRetries = i;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "TBD", e);
        }
    }
}

