/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.DefaultCallbackHandler;
import com.sun.xml.wss.jaxws.impl.TubeConfiguration;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jvnet.staxex.Base64Data;
import org.jvnet.staxex.XMLStreamReaderEx;

public class CertificateRetriever {
    protected TubeConfiguration pipeConfig = null;
    protected static final Logger log = Logger.getLogger("com.sun.xml.wss.provider.wsit", "com.sun.xml.wss.provider.wsit.logging.LogStrings");
    private String location = null;
    private String password = null;
    private String alias = null;
    private Certificate cs = null;
    private FileInputStream fis = null;

    public Certificate getServerKeyStore(WSEndpoint wse) throws IOException, XWSSecurityException {
        QName keyStoreQName = new QName("http://schemas.sun.com/2006/03/wss/server", "KeyStore");
        this.setLocationPasswordAndAlias(keyStoreQName, wse);
        if (this.password == null || this.location == null || this.alias == null) {
            return null;
        }
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("JKS");
            this.fis = new FileInputStream(this.location);
            keyStore.load(this.fis, this.password.toCharArray());
            this.cs = keyStore.getCertificate(this.alias);
        }
        catch (FileNotFoundException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new XWSSecurityException(ex);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new XWSSecurityException(ex);
        }
        catch (CertificateException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new XWSSecurityException(ex);
        }
        catch (KeyStoreException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new XWSSecurityException(ex);
        }
        finally {
            keyStore = null;
            this.fis.close();
        }
        return this.cs;
    }

    public byte[] digestBST(XMLStreamReader reader) throws XMLStreamException {
        byte[] bstValue = null;
        if (reader == null) {
            throw new RuntimeException("XML stream reader is null");
        }
        while (reader.getEventType() != 4) {
            if (reader.getEventType() == 2) break;
            reader.next();
        }
        if (reader.getEventType() == 4) {
            CharSequence data;
            if (reader instanceof XMLStreamReaderEx && (data = ((XMLStreamReaderEx)reader).getPCDATA()) instanceof Base64Data) {
                Base64Data binaryData = (Base64Data)data;
                bstValue = binaryData.getExact();
            }
            try {
                bstValue = Base64.decode(StreamUtil.getCV(reader));
            }
            catch (Base64DecodingException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
            catch (XMLStreamException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
        return bstValue;
    }

    public X509Certificate constructCertificate(byte[] bstValue) {
        try {
            X509Certificate cert = null;
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(bstValue));
            return cert;
        }
        catch (CertificateException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    public boolean validateCertificate(Certificate cert, Map props) {
        QName trustStoreQName = new QName("http://schemas.sun.com/2006/03/wss/client", "TrustStore");
        boolean valid = false;
        try {
            DefaultCallbackHandler dch;
            this.setLocationPasswordAndAlias(trustStoreQName, props);
            KeyStore trustStore = KeyStore.getInstance("JKS");
            if (this.location == null) {
                throw new KeyStoreException("trustStore location is null");
            }
            this.fis = new FileInputStream(this.location);
            if (this.password == null) {
                throw new KeyStoreException("trustStore password is null");
            }
            trustStore.load(this.fis, this.password.toCharArray());
            DefaultCallbackHandler defaultCallbackHandler = dch = new DefaultCallbackHandler(null, null);
            defaultCallbackHandler.getClass();
            DefaultCallbackHandler.X509CertificateValidatorImpl certValidator = defaultCallbackHandler.new DefaultCallbackHandler.X509CertificateValidatorImpl(trustStore, null, false);
            if (cert == null) {
                throw new RuntimeException("certificate is null");
            }
            valid = certValidator.validate((X509Certificate)cert);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (KeyStoreException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (CertificateException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (CertificateValidationCallback.CertificateValidationException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        return valid;
    }

    private void setParameters(PolicyMap pm, WSDLPort port, QName qName) {
        if (port == null) {
            return;
        }
        QName serviceName = port.getOwner().getName();
        QName portName = port.getName();
        PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(serviceName, portName);
        try {
            Policy ep = pm.getEndpointEffectivePolicy(endpointKey);
            if (ep == null) {
                WSDLBoundOperation operation;
                QName operationName;
                PolicyMapKey operationKey;
                Iterator<Object> i$ = port.getBinding().getBindingOperations().iterator();
                while (i$.hasNext() && (ep = pm.getOperationEffectivePolicy(operationKey = PolicyMap.createWsdlOperationScopeKey(serviceName, portName, operationName = new QName((operation = (WSDLBoundOperation)i$.next()).getBoundPortType().getName().getNamespaceURI(), operation.getName().getLocalPart())))) == null) {
                }
            }
            if (ep == null) {
                return;
            }
            for (AssertionSet assertionSet : ep) {
                for (PolicyAssertion pa : assertionSet) {
                    if (!PolicyUtil.isConfigPolicyAssertion(pa) || !pa.getName().equals(qName)) continue;
                    HashMap atts = (HashMap)pa.getAttributes();
                    Set ks = atts.keySet();
                    for (QName name : ks) {
                        if (name.getLocalPart().equals("storepass")) {
                            this.password = (String)atts.get(name);
                            continue;
                        }
                        if (name.getLocalPart().equals("location")) {
                            this.location = (String)atts.get(name);
                            StringBuffer sb = null;
                            sb = new StringBuffer(this.location);
                            if (!this.location.startsWith("$WSIT")) continue;
                            String path = System.getProperty("WSIT_HOME");
                            sb.replace(0, 10, path);
                            this.location = sb.toString();
                            continue;
                        }
                        if (!name.getLocalPart().equals("alias")) continue;
                        this.alias = (String)atts.get(name);
                    }
                }
            }
        }
        catch (PolicyException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private void setLocationPasswordAndAlias(QName trustStoreQName, Map props) {
        PolicyMap pm = (PolicyMap)props.get("POLICY");
        WSDLPort port = (WSDLPort)props.get("WSDL_MODEL");
        this.setParameters(pm, port, trustStoreQName);
    }

    private void setLocationPasswordAndAlias(QName qName, WSEndpoint wse) throws IOException {
        PolicyMap pm = wse.getPolicyMap();
        WSDLPort port = wse.getPort();
        this.setParameters(pm, port, qName);
    }
}

