/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm;

import com.sun.xml.ws.rx.rm.ReliableMessagingFeature;
import com.sun.xml.ws.rx.rm.RmVersion;

public final class ReliableMessagingFeatureBuilder {
    private boolean enabled = true;
    private RmVersion version = RmVersion.getDefault();
    private long inactivityTimeout = 600000L;
    private long destinationBufferQuota = 32L;
    private boolean orderedDelivery = false;
    private ReliableMessagingFeature.DeliveryAssurance deliveryAssurance = ReliableMessagingFeature.DeliveryAssurance.getDefault();
    private ReliableMessagingFeature.SecurityBinding securityBinding = ReliableMessagingFeature.SecurityBinding.getDefault();
    private long messageRetransmissionInterval = 2000L;
    private ReliableMessagingFeature.BackoffAlgorithm retransmissionBackoffAlgorithm = ReliableMessagingFeature.BackoffAlgorithm.getDefault();
    private long ackRequestInterval = 2000L;
    private long closeSequenceOperationTimeout = 3000L;
    private boolean persistenceEnabled = false;
    private long sequenceMaintenancePeriod = 60000L;

    public ReliableMessagingFeatureBuilder() {
    }

    public ReliableMessagingFeatureBuilder(RmVersion version) {
        this.version = version;
    }

    public ReliableMessagingFeature build() {
        return new ReliableMessagingFeature(this.enabled, this.version, this.inactivityTimeout, this.destinationBufferQuota, this.orderedDelivery, this.deliveryAssurance, this.securityBinding, this.messageRetransmissionInterval, this.retransmissionBackoffAlgorithm, this.ackRequestInterval, this.closeSequenceOperationTimeout, this.persistenceEnabled, this.sequenceMaintenancePeriod);
    }

    public ReliableMessagingFeatureBuilder ackRequestInterval(long ackRequestInterval) {
        this.ackRequestInterval = ackRequestInterval;
        return this;
    }

    public ReliableMessagingFeatureBuilder messageRetransmissionInterval(long messageRetransmissionInterval) {
        this.messageRetransmissionInterval = messageRetransmissionInterval;
        return this;
    }

    public ReliableMessagingFeatureBuilder destinationBufferQuota(long bufferQuota) {
        this.destinationBufferQuota = bufferQuota;
        return this;
    }

    public ReliableMessagingFeatureBuilder closeSequenceOperationTimeout(long closeSequenceOperationTimeout) {
        this.closeSequenceOperationTimeout = closeSequenceOperationTimeout;
        return this;
    }

    public ReliableMessagingFeatureBuilder deliveryAssurance(ReliableMessagingFeature.DeliveryAssurance deliveryAssurance) {
        this.deliveryAssurance = deliveryAssurance;
        return this;
    }

    public ReliableMessagingFeatureBuilder sequenceInactivityTimeout(long inactivityTimeout) {
        this.inactivityTimeout = inactivityTimeout;
        return this;
    }

    public ReliableMessagingFeatureBuilder enableOrderedDelivery() {
        this.orderedDelivery = true;
        return this;
    }

    public ReliableMessagingFeatureBuilder retransmissionBackoffAlgorithm(ReliableMessagingFeature.BackoffAlgorithm retransmissionBackoffAlgorithm) {
        this.retransmissionBackoffAlgorithm = retransmissionBackoffAlgorithm;
        return this;
    }

    public ReliableMessagingFeatureBuilder version(RmVersion version) {
        this.version = version;
        return this;
    }

    public ReliableMessagingFeatureBuilder securityBinding(ReliableMessagingFeature.SecurityBinding securityBinding) {
        this.securityBinding = securityBinding;
        return this;
    }

    public ReliableMessagingFeatureBuilder enablePersistence() {
        this.persistenceEnabled = true;
        return this;
    }

    public ReliableMessagingFeatureBuilder disablePersistence() {
        this.persistenceEnabled = false;
        return this;
    }

    public ReliableMessagingFeatureBuilder sequenceMaintenancePeriod(long newValue) {
        this.sequenceMaintenancePeriod = newValue;
        return this;
    }
}

