/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.server;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.ConfigReader;
import com.sun.xml.ws.api.config.management.EndpointStarter;
import com.sun.xml.ws.api.config.management.ManagedEndpoint;
import com.sun.xml.ws.api.config.management.NamedParameters;
import com.sun.xml.ws.commons.ScheduledTaskManager;
import com.sun.xml.ws.config.management.ManagementUtil;
import com.sun.xml.ws.config.management.persistence.JDBCConfigSaver;
import com.sun.xml.ws.config.management.policy.ManagedServiceAssertion;
import com.sun.xml.ws.config.management.server.ReDelegate;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import javax.sql.DataSource;
import javax.xml.ws.WebServiceException;

public class JDBCConfigReader
implements ConfigReader {
    private static final Logger LOGGER = Logger.getLogger(ConfigPoller.class);
    private final ScheduledTaskManager taskManager = new ScheduledTaskManager("JDBC config reader");
    private ConfigPoller poller = null;

    public void init(NamedParameters parameters) {
        this.poller = new ConfigPoller(parameters);
    }

    public void start() {
        this.taskManager.startTask(this.poller, 0L, 10000L);
    }

    public void stop() {
        this.taskManager.shutdown();
    }

    private static class ConfigPoller
    implements Runnable {
        private final ManagedEndpoint endpoint;
        private final EndpointStarter endpointStarter;
        private final NamedParameters configParameters;
        private volatile long version = 0L;

        public ConfigPoller(NamedParameters parameters) {
            this.endpoint = (ManagedEndpoint)parameters.get("ENDPOINT_INSTANCE");
            this.endpointStarter = (EndpointStarter)parameters.get("ENDPOINT_STARTER");
            this.configParameters = parameters;
            ManagedServiceAssertion assertion = ManagementUtil.getAssertion(this.endpoint);
            String start = assertion.getStart();
            if (start == null || !start.equals("notify")) {
                this.endpointStarter.startEndpoint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Connection connection = null;
            try {
                DataSource source = JDBCConfigSaver.getManagementDS();
                connection = source.getConnection();
                this.pollData(connection, this.endpoint.getId());
                connection.close();
            }
            catch (SQLException e) {
                LOGGER.logSevereException(e);
            }
            catch (WebServiceException e) {
                LOGGER.logSevereException(e);
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    LOGGER.logSevereException(e);
                }
            }
        }

        private void pollData(Connection connection, String endpointId) {
            Statement statement = null;
            try {
                String query = "SELECT version, config FROM METRO_CONFIG WHERE id = ? AND version > ?";
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Executing SQL command: SELECT version, config FROM METRO_CONFIG WHERE id = ? AND version > ?");
                }
                statement = connection.prepareStatement("SELECT version, config FROM METRO_CONFIG WHERE id = ? AND version > ?");
                statement.setString(1, endpointId);
                statement.setLong(2, this.version);
                ResultSet result = statement.executeQuery();
                if (result.next()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("SQL query found updated configuration data");
                    }
                    this.version = result.getLong("version");
                    Reader data = result.getCharacterStream("config");
                    this.reconfigure(data);
                } else if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finer("SQL query did not find any updated configuration data");
                }
            }
            catch (SQLException e) {
                throw LOGGER.logSevereException(new WebServiceException((Throwable)e));
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        throw LOGGER.logSevereException(new WebServiceException((Throwable)e));
                    }
                }
            }
        }

        private void reconfigure(Reader reader) {
            this.configParameters.put("CONFIGURATION_DATA", ManagementUtil.convert(reader));
            ReDelegate redelegate = new ReDelegate();
            redelegate.recreate(this.configParameters);
            this.endpointStarter.startEndpoint();
        }
    }
}

