/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.main;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.management.ObjectName;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.ManagedObjectManager;
import org.glassfish.gmbal.ManagedObjectManagerFactory;
import org.glassfish.gmbal.NameValue;
import org.glassfish.gmbal.generic.Pair;
import org.glassfish.gmbal.impl.AMXClient;

public class ProfileMain {
    private static ManagedObjectManager mom;
    private static final String[] itemNames;
    private static final Item[] items;
    private static final int NUM_STORES = 5000;
    private static final Random random;

    private static void initializeStores(MyRoot myroot) {
        int i = 0;
        for (String str : itemNames) {
            Item item = new Item(str, random.nextInt(100), random.nextInt(100));
            myroot.addItem(item);
            ProfileMain.items[i++] = item;
        }
        for (int ctr = 0; ctr < 5000; ++ctr) {
            Store store = new Store("Store_" + ctr);
            for (Item item : items) {
                if (random.nextInt(100) >= 20) continue;
                store.addItem(item, 3 + random.nextInt(11));
            }
            myroot.addStore(store);
        }
    }

    private static void checkAttributes(ManagedObjectManager mom, MyRoot myroot) {
        for (Store store : myroot.getStores()) {
            ObjectName oname = mom.getObjectName(store);
            AMXClient amx = new AMXClient(mom.getMBeanServer(), oname);
            Object res = amx.getAttribute("Name");
            if (res.equals(store.name())) continue;
            throw new IllegalStateException("bad store name");
        }
    }

    private static void registerMBeans(ManagedObjectManager mom, MyRoot myroot) {
        for (Store store : myroot.getStores()) {
            mom.registerAtRoot(store);
        }
    }

    public static void run(boolean isWarmup, int count) throws IOException {
        Timings timings = new Timings();
        MyRoot myroot = new MyRoot();
        ProfileMain.initializeStores(myroot);
        timings.add("Set up the data");
        mom = ManagedObjectManagerFactory.createStandalone("test");
        timings.add("Create ManagedObjectManager");
        mom.createRoot(myroot);
        timings.add("Create the root");
        ProfileMain.registerMBeans(mom, myroot);
        timings.add("Register 5000 MBeans");
        ProfileMain.checkAttributes(mom, myroot);
        timings.add("Fetch 1 attribute on 5000 MBeans");
        mom.close();
        timings.add("Close the ManagedObjectManager");
        String type = isWarmup ? "Warmup" : "Benchmark";
        timings.dump(type + ": Iteration " + count);
    }

    private static void msg(String arg) {
        System.out.println(arg);
    }

    public static void main(String[] args) throws IOException {
        ProfileMain.msg("Warming up");
        for (int ctr = 0; ctr < 10; ++ctr) {
            ProfileMain.run(true, ctr);
        }
        ProfileMain.msg("Timing");
        long start = System.currentTimeMillis();
        ProfileMain.run(false, 0);
        long duration = System.currentTimeMillis() - start;
        long numBeans = 5001L;
        ProfileMain.msg("It took " + duration + " milliseconds to test " + numBeans + " MBeans");
        ProfileMain.msg("That is " + numBeans * 1000L / duration + " MBean register/getAttribute/unregister calls per second");
    }

    static {
        itemNames = new String[]{"RedBall", "BlueBall", "GreenBall", "RubberDuck", "RubberChicken", "4_inch_telescope", "8_inch_telescope", "Pipette", "Flask", "500ml_beaker", "1000ml_beaker", "WallClock", "Radio", "32GB_USB_Stick", "500GB_SATA_Drive"};
        items = new Item[itemNames.length];
        random = new Random();
    }

    public static class Timings {
        private List<Pair<String, Long>> durations;
        private long start = System.currentTimeMillis();

        public Timings() {
            this.durations = new ArrayList<Pair<String, Long>>();
        }

        public void add(String msg) {
            long elapsed = System.currentTimeMillis() - this.start;
            Pair<String, Long> entry = new Pair<String, Long>(msg, elapsed);
            this.durations.add(entry);
            this.start = System.currentTimeMillis();
        }

        public void dump(String msg) {
            System.out.println(msg);
            for (Pair<String, Long> entry : this.durations) {
                System.out.printf("\t%10d:\t%s\n", entry.second(), entry.first());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ManagedObject
    public static class MyRoot {
        private List<Store> stores = new ArrayList<Store>();
        private List<Item> items = new ArrayList<Item>();

        public void addStore(Store store) {
            this.stores.add(store);
        }

        public void addItem(Item item) {
            this.items.add(item);
        }

        @NameValue
        String name() {
            return "Root";
        }

        @ManagedAttribute
        @Description(value="All of the stores")
        List<Store> getStores() {
            return this.stores;
        }

        @ManagedAttribute
        @Description(value="All possible items")
        List<Item> getItems() {
            return this.items;
        }

        @ManagedAttribute
        @Description(value="Map of which stores contain a particular item")
        Map<Item, Set<Store>> getItemLocations() {
            HashMap<Item, Set<Store>> result = new HashMap<Item, Set<Store>>();
            for (Store store : this.stores) {
                for (Map.Entry<Item, Integer> ic : store.inventory().entrySet()) {
                    if (ic.getValue() <= 0) continue;
                    HashSet<Store> containers = (HashSet<Store>)result.get(ic.getKey());
                    if (containers == null) {
                        containers = new HashSet<Store>();
                        result.put(ic.getKey(), containers);
                    }
                    containers.add(store);
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ManagedObject
    @Description(value="A store of items")
    public static class Store {
        private String name;
        Map<Item, Integer> contents = new HashMap<Item, Integer>();

        public Store(String name) {
            this.name = name;
        }

        public void addItem(Item item, int count) {
            Integer num = this.contents.get(item);
            if (num == null) {
                this.contents.put(item, count);
            } else {
                this.contents.put(item, num + count);
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Store other = (Store)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @ManagedAttribute
        @Description(value="The number of items in the store")
        Map<Item, Integer> inventory() {
            return null;
        }

        @NameValue
        @ManagedAttribute
        @Description(value="The name of the store")
        String name() {
            return this.name;
        }
    }

    @ManagedData
    public static class Item {
        @ManagedAttribute
        private String name;
        private double size;
        private double mass;

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            return other.name.equals(this.name);
        }

        public Item(String name, double size, double mass) {
            this.name = name;
            this.size = size;
            this.mass = mass;
        }

        @Description(value="The name of this entity")
        @NameValue
        String name() {
            return this.name;
        }

        @ManagedAttribute
        @Description(value="The size of this entity")
        double size() {
            return this.size;
        }

        @ManagedAttribute
        @Description(value="The mass of this entity")
        double mass() {
            return this.mass;
        }
    }
}

