/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.enc;

import com.sun.xml.security.core.xenc.CVAdapter;
import com.sun.xml.security.core.xenc.EncryptedDataType;
import com.sun.xml.security.core.xenc.ObjectFactory;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.security.opt.api.EncryptedData;
import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.ws.security.opt.impl.crypto.SSEData;
import com.sun.xml.ws.security.opt.impl.enc.CryptoProcessor;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.c14n.AttributeNS;
import com.sun.xml.wss.impl.c14n.StAXEXC14nCanonicalizerImpl;
import com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.crypto.Data;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBEncryptedData
implements EncryptedData,
SecurityHeaderElement,
SecurityElementWriter {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.crypto", "com.sun.xml.wss.logging.impl.opt.crypto.LogStrings");
    private EncryptedDataType edt = null;
    private Data data = null;
    private Key key = null;
    private SOAPVersion soapVersion = SOAPVersion.SOAP_11;
    private CryptoProcessor dep = null;

    public JAXBEncryptedData(EncryptedDataType edt, Data data, Key key, SOAPVersion soapVersion) {
        this.edt = edt;
        this.key = key;
        this.data = data;
        this.soapVersion = soapVersion;
    }

    public JAXBEncryptedData(EncryptedDataType edt, Data data, SOAPVersion soapVersion) {
        this.edt = edt;
        this.data = data;
        this.soapVersion = soapVersion;
    }

    public String getEncryptedLocalName() {
        if (this.data instanceof SSEData) {
            SecurityElement se = ((SSEData)this.data).getSecurityElement();
            return se.getLocalPart();
        }
        return "";
    }

    public String getEncryptedId() {
        if (this.data instanceof SSEData) {
            SecurityElement se = ((SSEData)this.data).getSecurityElement();
            return se.getId();
        }
        return "";
    }

    @Override
    public void encrypt() {
    }

    @Override
    public void decrypt() {
    }

    @Override
    public String getId() {
        return this.edt.getId();
    }

    @Override
    public void setId(String id) {
        if (this.edt.getId() == null || this.edt.getId().length() == 0) {
            this.edt.setId(id);
        }
    }

    @Override
    public String getNamespaceURI() {
        return "http://www.w3.org/2001/04/xmlenc#";
    }

    @Override
    public String getLocalPart() {
        return "EncryptedData";
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        try {
            OutputStream os;
            if (streamWriter instanceof Map && this.dep == null && (os = (OutputStream)((Map)((Object)streamWriter)).get("sjsxp-outputstream")) != null) {
                streamWriter.writeCharacters("");
                this.writeTo(os);
                return;
            }
            Marshaller writer = this.getMarshaller();
            if (this.dep == null) {
                this.dep = new CryptoProcessor(1, this.edt.getEncryptionMethod().getAlgorithm(), this.data, this.key);
                if (streamWriter instanceof StAXEXC14nCanonicalizerImpl) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        this.dep.encryptData(bos);
                    }
                    catch (IOException ie) {
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1920_ERROR_CALCULATING_CIPHERVALUE());
                        throw new XMLStreamException("Error occurred while calculating Cipher Value");
                    }
                    this.dep.setEncryptedDataCV(bos.toByteArray());
                }
            }
            CVAdapter adapter = new CVAdapter(this.dep);
            writer.setAdapter(CVAdapter.class, (XmlAdapter)adapter);
            ObjectFactory obj = new ObjectFactory();
            JAXBElement<EncryptedDataType> ed = obj.createEncryptedData(this.edt);
            writer.marshal(ed, streamWriter);
        }
        catch (XWSSecurityException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1919_ERROR_WRITING_ENCRYPTEDDATA(ex.getMessage()), ex);
        }
        catch (JAXBException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1919_ERROR_WRITING_ENCRYPTEDDATA(ex.getMessage()), ex);
        }
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        try {
            Marshaller marshaller = this.getMarshaller();
            for (Map.Entry entry : props.entrySet()) {
                marshaller.setProperty((String)entry.getKey(), entry.getValue());
            }
            this.writeTo(streamWriter);
        }
        catch (JAXBException jbe) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1919_ERROR_WRITING_ENCRYPTEDDATA(jbe.getMessage()), jbe);
            throw new XMLStreamException(jbe);
        }
    }

    @Override
    public void writeTo(OutputStream os) {
        try {
            Marshaller writer = this.getMarshaller();
            CryptoProcessor dep = new CryptoProcessor(1, this.edt.getEncryptionMethod().getAlgorithm(), this.data, this.key);
            CVAdapter adapter = new CVAdapter(dep);
            writer.setAdapter(CVAdapter.class, (XmlAdapter)adapter);
            ObjectFactory obj = new ObjectFactory();
            JAXBElement<EncryptedDataType> ed = obj.createEncryptedData(this.edt);
            writer.marshal(ed, os);
        }
        catch (XWSSecurityException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1919_ERROR_WRITING_ENCRYPTEDDATA(ex.getMessage()), ex);
        }
        catch (JAXBException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1919_ERROR_WRITING_ENCRYPTEDDATA(ex.getMessage()), ex);
        }
    }

    public void writeTo(SOAPMessage saaj) throws SOAPException {
        throw new UnsupportedOperationException();
    }

    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        throw new UnsupportedOperationException();
    }

    public byte[] canonicalize(String algorithm, List<AttributeNS> namespaceDecls) {
        throw new UnsupportedOperationException();
    }

    public boolean isCanonicalized() {
        return false;
    }

    private Marshaller getMarshaller() throws JAXBException {
        return JAXBUtil.createMarshaller(this.soapVersion);
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean refersToSecHdrWithId(String id) {
        SecurityElement se;
        Object data;
        List<Object> list;
        KeyInfo ki = (KeyInfo)this.edt.getKeyInfo();
        if (ki != null && (list = ki.getContent()).size() > 0 && (data = ((JAXBElement)list.get(0)).getValue()) instanceof SecurityHeaderElement && ((SecurityHeaderElement)data).refersToSecHdrWithId(id)) {
            return true;
        }
        if (this.data instanceof SSEData && (se = ((SSEData)this.data).getSecurityElement()) instanceof SecurityHeaderElement) {
            return ((SecurityHeaderElement)se).refersToSecHdrWithId(id);
        }
        return false;
    }
}

