/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.faults;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rx.RxConfiguration;
import com.sun.xml.ws.rx.RxException;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.RmVersion;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.SequenceFaultElement;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;

public abstract class AbstractRmSoapFault
extends RxException {
    private final transient Packet soapFaultResponse;

    public AbstractRmSoapFault(RxConfiguration configuration, Packet request, QName subcode, String reason) {
        super(reason);
        this.soapFaultResponse = AbstractRmSoapFault.createRmProcessingSoapFaultResponse(configuration, request, subcode, reason);
    }

    public AbstractRmSoapFault(Packet soapFaultResponse, String reason) {
        super(reason);
        this.soapFaultResponse = soapFaultResponse;
    }

    public Packet getSoapFaultResponse() {
        return this.soapFaultResponse;
    }

    protected static Packet createRmProcessingSoapFaultResponse(RxConfiguration configuration, Packet request, QName subcode, String reason) throws RxRuntimeException {
        try {
            SOAPFault soapFault = configuration.getSoapVersion().saajSoapFactory.createFault();
            if (reason != null) {
                soapFault.setFaultString(reason, Locale.ENGLISH);
            }
            soapFault.setFaultCode(configuration.getSoapVersion().faultCodeServer);
            switch (configuration.getSoapVersion()) {
                case SOAP_11: {
                    break;
                }
                case SOAP_12: {
                    soapFault.appendFaultSubcode(subcode);
                    break;
                }
                default: {
                    throw new RxRuntimeException("Unsupported SOAP version: '" + configuration.getSoapVersion().toString() + "'");
                }
            }
            Message soapFaultMessage = Messages.create(soapFault);
            if (configuration.getSoapVersion() == SOAPVersion.SOAP_11) {
                Header faultHeader = configuration.getRmVersion() == RmVersion.WSRM200502 ? Headers.create(RmVersion.WSRM200502.getJaxbContext(configuration.getAddressingVersion()), (Object)new com.sun.xml.ws.rx.rm.protocol.wsrm200502.SequenceFaultElement(subcode)) : Headers.create(RmVersion.WSRM200702.getJaxbContext(configuration.getAddressingVersion()), (Object)new SequenceFaultElement(subcode));
                soapFaultMessage.getHeaders().add(faultHeader);
            }
            return request.createServerResponse(soapFaultMessage, configuration.getAddressingVersion(), configuration.getSoapVersion(), AbstractRmSoapFault.getProperFaultActionForAddressingVersion(configuration));
        }
        catch (SOAPException ex) {
            throw new RxRuntimeException("Error creating a SOAP fault", ex);
        }
    }

    protected static Packet createCreateSequenceProcessingSoapFaultResponse(RxConfiguration configuration, Packet request, QName subcode, String reason) throws RxRuntimeException {
        try {
            SOAPFault soapFault = configuration.getSoapVersion().saajSoapFactory.createFault();
            if (reason != null) {
                soapFault.setFaultString(reason, Locale.ENGLISH);
            }
            switch (configuration.getSoapVersion()) {
                case SOAP_11: {
                    soapFault.setFaultCode(subcode);
                    break;
                }
                case SOAP_12: {
                    soapFault.setFaultCode(configuration.getSoapVersion().faultCodeServer);
                    soapFault.appendFaultSubcode(subcode);
                    break;
                }
                default: {
                    throw new RxRuntimeException("Unsupported SOAP version: '" + configuration.getSoapVersion().toString() + "'");
                }
            }
            Message soapFaultMessage = Messages.create(soapFault);
            return request.createServerResponse(soapFaultMessage, configuration.getAddressingVersion(), configuration.getSoapVersion(), AbstractRmSoapFault.getProperFaultActionForAddressingVersion(configuration));
        }
        catch (SOAPException ex) {
            throw new RxRuntimeException("Error creating a SOAP fault", ex);
        }
    }

    private static String getProperFaultActionForAddressingVersion(RxConfiguration configuration) {
        return configuration.getAddressingVersion() == AddressingVersion.MEMBER ? configuration.getAddressingVersion().getDefaultFaultAction() : configuration.getRmVersion().wsrmFaultAction;
    }
}

