/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.rx.RxConfiguration;
import com.sun.xml.ws.rx.mc.MakeConnectionSupportedFeature;
import com.sun.xml.ws.rx.mc.McVersion;
import com.sun.xml.ws.rx.rm.ReliableMessagingFeature;
import com.sun.xml.ws.rx.rm.RmVersion;
import org.glassfish.gmbal.ManagedObjectManager;

class RxConfigurationImpl
implements RxConfiguration {
    private final ReliableMessagingFeature rmFeature;
    private final boolean mcSupported;
    private final SOAPVersion soapVersion;
    private final AddressingVersion addressingVersion;
    private final boolean requestResponseDetected;
    private final ManagedObjectManager managedObjectManager;

    RxConfigurationImpl(ReliableMessagingFeature rmFeature, MakeConnectionSupportedFeature mcFeature, SOAPVersion soapVersion, AddressingVersion addressingVersion, boolean requestResponseDetected, ManagedObjectManager managedObjectManager) {
        this.rmFeature = rmFeature;
        this.mcSupported = mcFeature != null && mcFeature.isEnabled();
        this.soapVersion = soapVersion;
        this.addressingVersion = addressingVersion;
        this.requestResponseDetected = requestResponseDetected;
        this.managedObjectManager = managedObjectManager;
    }

    public boolean isReliableMessagingEnabled() {
        return this.rmFeature != null && this.rmFeature.isEnabled();
    }

    public boolean isMakeConnectionSupportEnabled() {
        return this.mcSupported;
    }

    public RmVersion getRmVersion() {
        return this.rmFeature == null ? null : this.rmFeature.getVersion();
    }

    public McVersion getMcVersion() {
        return this.mcSupported ? McVersion.WSMC200702 : null;
    }

    public SOAPVersion getSoapVersion() {
        return this.soapVersion;
    }

    public AddressingVersion getAddressingVersion() {
        return this.addressingVersion;
    }

    public boolean requestResponseOperationsDetected() {
        return this.requestResponseDetected;
    }

    public long getSequenceInactivityTimeout() {
        return this.rmFeature == null ? null : Long.valueOf(this.rmFeature.getSequenceInactivityTimeout());
    }

    public ReliableMessagingFeature.SecurityBinding getSecurityBinding() {
        return this.rmFeature == null ? null : this.rmFeature.getSecurityBinding();
    }

    public ReliableMessagingFeature.DeliveryAssurance getDeliveryAssurance() {
        return this.rmFeature == null ? null : this.rmFeature.getDeliveryAssurance();
    }

    public boolean isOrderedDeliveryEnabled() {
        return this.rmFeature == null ? null : Boolean.valueOf(this.rmFeature.isOrderedDeliveryEnabled());
    }

    public long getDestinationBufferQuota() {
        return this.rmFeature == null ? null : Long.valueOf(this.rmFeature.getDestinationBufferQuota());
    }

    public long getMessageRetransmissionInterval() {
        return this.rmFeature == null ? null : Long.valueOf(this.rmFeature.getMessageRetransmissionInterval());
    }

    public ReliableMessagingFeature.BackoffAlgorithm getRetransmissionBackoffAlgorithm() {
        return this.rmFeature == null ? null : this.rmFeature.getRetransmissionBackoffAlgorithm();
    }

    public long getAcknowledgementRequestInterval() {
        return this.rmFeature == null ? null : Long.valueOf(this.rmFeature.getAcknowledgementRequestInterval());
    }

    public long getCloseSequenceOperationTimeout() {
        return this.rmFeature == null ? null : Long.valueOf(this.rmFeature.getCloseSequenceOperationTimeout());
    }

    public ManagedObjectManager getManagedObjectManager() {
        return this.managedObjectManager;
    }
}

