/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.model;

import com.sun.xml.bind.v2.model.annotation.AnnotationReader;
import com.sun.xml.bind.v2.model.annotation.RuntimeInlineAnnotationReader;
import com.sun.xml.bind.v2.model.nav.Navigator;
import com.sun.xml.ws.model.AbstractWrapperBeanGenerator;
import com.sun.xml.ws.model.FieldSignature;
import com.sun.xml.ws.model.Injector;
import com.sun.xml.ws.org.objectweb.asm.AnnotationVisitor;
import com.sun.xml.ws.org.objectweb.asm.ClassWriter;
import com.sun.xml.ws.org.objectweb.asm.FieldVisitor;
import com.sun.xml.ws.org.objectweb.asm.MethodVisitor;
import com.sun.xml.ws.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperBeanGenerator {
    private static final Logger LOGGER = Logger.getLogger(WrapperBeanGenerator.class.getName());
    private static final FieldFactory FIELD_FACTORY = new FieldFactory();
    private static final AbstractWrapperBeanGenerator RUNTIME_GENERATOR = new RuntimeWrapperBeanGenerator(new RuntimeInlineAnnotationReader(), Navigator.REFLECTION, FIELD_FACTORY);
    private static final Set<String> skipProperties = new HashSet<String>();

    private static byte[] createBeanImage(String className, String rootName, String rootNS, String typeName, String typeNS, String[] propOrder, List<Field> fields) throws Exception {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 33, WrapperBeanGenerator.replaceDotWithSlash(className), null, "java/lang/Object", null);
        AnnotationVisitor root = cw.visitAnnotation("Ljavax/xml/bind/annotation/XmlRootElement;", true);
        root.visit("name", rootName);
        root.visit("namespace", rootNS);
        root.visitEnd();
        AnnotationVisitor type = cw.visitAnnotation("Ljavax/xml/bind/annotation/XmlType;", true);
        type.visit("name", typeName);
        type.visit("namespace", typeNS);
        if (propOrder.length > 1) {
            AnnotationVisitor propVisitor = type.visitArray("propOrder");
            for (String prop : propOrder) {
                propVisitor.visit("propOrder", prop);
            }
            propVisitor.visitEnd();
        }
        type.visitEnd();
        for (Field field : fields) {
            FieldVisitor fv = cw.visitField(1, field.fieldName, field.asmType.getDescriptor(), field.getSignature(), null);
            if (!field.noXmlElem) {
                // empty if block
            }
            for (Annotation ann : field.jaxbAnnotations) {
                if (ann instanceof XmlMimeType) {
                    AnnotationVisitor mime = fv.visitAnnotation("Ljavax/xml/bind/annotation/XmlMimeType;", true);
                    mime.visit("value", ((XmlMimeType)ann).value());
                    mime.visitEnd();
                    continue;
                }
                if (ann instanceof XmlJavaTypeAdapter) {
                    AnnotationVisitor ada = fv.visitAnnotation("Ljavax/xml/bind/annotation/adapters/XmlJavaTypeAdapter;", true);
                    ada.visit("value", WrapperBeanGenerator.getASMType(((XmlJavaTypeAdapter)ann).value()));
                    ada.visitEnd();
                    continue;
                }
                if (ann instanceof XmlAttachmentRef) {
                    AnnotationVisitor att = fv.visitAnnotation("Ljavax/xml/bind/annotation/XmlAttachmentRef;", true);
                    att.visitEnd();
                    continue;
                }
                if (ann instanceof XmlList) {
                    AnnotationVisitor list = fv.visitAnnotation("Ljavax/xml/bind/annotation/XmlList;", true);
                    list.visitEnd();
                    continue;
                }
                if (ann instanceof XmlElement) {
                    AnnotationVisitor elem = fv.visitAnnotation("Ljavax/xml/bind/annotation/XmlElement;", true);
                    XmlElement xmlElem = (XmlElement)ann;
                    elem.visit("name", xmlElem.name());
                    elem.visit("namespace", xmlElem.namespace());
                    if (xmlElem.nillable()) {
                        elem.visit("nillable", true);
                    }
                    if (xmlElem.required()) {
                        elem.visit("required", true);
                    }
                    elem.visitEnd();
                    continue;
                }
                throw new WebServiceException("Unknown JAXB annotation " + ann);
            }
            fv.visitEnd();
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append("@XmlRootElement(name=").append(rootName).append(", namespace=").append(rootNS).append(")");
            sb.append("\n");
            sb.append("@XmlType(name=").append(typeName).append(", namespace=").append(typeNS);
            if (propOrder.length > 1) {
                sb.append(", propOrder={");
                for (int i = 0; i < propOrder.length; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(propOrder[i]);
                }
                sb.append("}");
            }
            sb.append(")");
            sb.append("\n");
            sb.append("public class ").append(className).append(" {");
            for (Field field : fields) {
                sb.append("\n");
                if (!field.noXmlElem) {
                    // empty if block
                }
                for (Annotation ann : field.jaxbAnnotations) {
                    sb.append("\n    ");
                    if (ann instanceof XmlMimeType) {
                        sb.append("@XmlMimeType(value=").append(((XmlMimeType)ann).value()).append(")");
                        continue;
                    }
                    if (ann instanceof XmlJavaTypeAdapter) {
                        sb.append("@XmlJavaTypeAdapter(value=").append(WrapperBeanGenerator.getASMType(((XmlJavaTypeAdapter)ann).value())).append(")");
                        continue;
                    }
                    if (ann instanceof XmlAttachmentRef) {
                        sb.append("@XmlAttachmentRef");
                        continue;
                    }
                    if (ann instanceof XmlList) {
                        sb.append("@XmlList");
                        continue;
                    }
                    if (ann instanceof XmlElement) continue;
                    throw new WebServiceException("Unknown JAXB annotation " + ann);
                }
                sb.append("\n    ");
                sb.append("public ");
                if (field.getSignature() == null) {
                    sb.append(field.asmType.getDescriptor());
                } else {
                    sb.append(field.getSignature());
                }
                sb.append(" ");
                sb.append(field.fieldName);
            }
            sb.append("\n\n}");
            LOGGER.fine(sb.toString());
        }
        return cw.toByteArray();
    }

    private static String replaceDotWithSlash(String name) {
        return name.replace('.', '/');
    }

    static Class createRequestWrapperBean(String className, Method method, QName reqElemName, ClassLoader cl) {
        byte[] image;
        LOGGER.fine("Request Wrapper Class : " + className);
        ArrayList<Field> requestMembers = new ArrayList<Field>();
        ArrayList responseMembers = new ArrayList();
        RUNTIME_GENERATOR.collectWrapperBeanMembers(method, true, reqElemName.getNamespaceURI(), requestMembers, responseMembers);
        String[] propOrder = WrapperBeanGenerator.getPropOrder(requestMembers);
        try {
            image = WrapperBeanGenerator.createBeanImage(className, reqElemName.getLocalPart(), reqElemName.getNamespaceURI(), reqElemName.getLocalPart(), reqElemName.getNamespaceURI(), propOrder, requestMembers);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        return Injector.inject(cl, className, image);
    }

    static Class createResponseWrapperBean(String className, Method method, QName resElemName, ClassLoader cl) {
        byte[] image;
        LOGGER.fine("Response Wrapper Class : " + className);
        ArrayList requestMembers = new ArrayList();
        ArrayList<Field> responseMembers = new ArrayList<Field>();
        RUNTIME_GENERATOR.collectWrapperBeanMembers(method, true, resElemName.getNamespaceURI(), requestMembers, responseMembers);
        String[] propOrder = WrapperBeanGenerator.getPropOrder(responseMembers);
        try {
            image = WrapperBeanGenerator.createBeanImage(className, resElemName.getLocalPart(), resElemName.getNamespaceURI(), resElemName.getLocalPart(), resElemName.getNamespaceURI(), propOrder, responseMembers);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        return Injector.inject(cl, className, image);
    }

    private static String[] getPropOrder(List<Field> fields) {
        String[] propOrder = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            propOrder[i] = fields.get(i).fieldName;
        }
        return propOrder;
    }

    private static com.sun.xml.ws.org.objectweb.asm.Type getASMType(Type t) {
        TypeVariable tv;
        ParameterizedType pt;
        assert (t != null);
        if (t instanceof Class) {
            return com.sun.xml.ws.org.objectweb.asm.Type.getType((Class)t);
        }
        if (t instanceof ParameterizedType && (pt = (ParameterizedType)t).getRawType() instanceof Class) {
            return com.sun.xml.ws.org.objectweb.asm.Type.getType((Class)pt.getRawType());
        }
        if (t instanceof GenericArrayType) {
            // empty if block
        }
        if (t instanceof WildcardType) {
            // empty if block
        }
        if (t instanceof TypeVariable && (tv = (TypeVariable)t).getBounds()[0] instanceof Class) {
            return com.sun.xml.ws.org.objectweb.asm.Type.getType((Class)tv.getBounds()[0]);
        }
        assert (false);
        throw new IllegalArgumentException("Not creating ASM Type for type = " + t);
    }

    static Class createExceptionBean(String className, Class exception, String typeNS, String elemName, String elemNS, ClassLoader cl) {
        byte[] image;
        List<Field> fields = WrapperBeanGenerator.collectExceptionProperties(exception);
        String[] propOrder = WrapperBeanGenerator.getPropOrder(fields);
        try {
            image = WrapperBeanGenerator.createBeanImage(className, elemName, elemNS, exception.getSimpleName(), typeNS, propOrder, fields);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        return Injector.inject(cl, className, image);
    }

    private static List<Field> collectExceptionProperties(Class exception) {
        Method[] methods;
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Method method : methods = exception.getMethods()) {
            Field field;
            String fieldName;
            String name;
            int mod = method.getModifiers();
            if (!Modifier.isPublic(mod) || Modifier.isFinal(mod) && Modifier.isStatic(mod) || Modifier.isTransient(mod) || !(name = method.getName()).startsWith("get") && !name.startsWith("is") || skipProperties.contains(name) || name.equals("get") || name.equals("is")) continue;
            Type[] paramTypes = method.getGenericParameterTypes();
            Type returnType = method.getGenericReturnType();
            com.sun.xml.ws.org.objectweb.asm.Type asmType = com.sun.xml.ws.org.objectweb.asm.Type.getReturnType(method);
            if (paramTypes.length != 0) continue;
            if (name.startsWith("get")) {
                fieldName = StringUtils.decapitalize(name.substring(3));
                field = new Field(fieldName, returnType, asmType, true, Collections.<Annotation>emptyList());
                fields.add(field);
                continue;
            }
            fieldName = StringUtils.decapitalize(name.substring(2));
            field = new Field(fieldName, returnType, asmType, true, Collections.<Annotation>emptyList());
            fields.add(field);
        }
        Collections.sort(fields);
        return fields;
    }

    static {
        skipProperties.add("getCause");
        skipProperties.add("getLocalizedMessage");
        skipProperties.add("getClass");
        skipProperties.add("getStackTrace");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Field
    implements Comparable<Field> {
        private final Type reflectType;
        private final com.sun.xml.ws.org.objectweb.asm.Type asmType;
        private final String fieldName;
        private final List<Annotation> jaxbAnnotations;
        private final boolean noXmlElem;

        Field(String paramName, Type paramType, com.sun.xml.ws.org.objectweb.asm.Type asmType, String elementName, String elementNS, List<Annotation> jaxbAnnotations) {
            this(paramName, paramType, asmType, false, elementName, elementNS, jaxbAnnotations);
        }

        Field(String paramName, Type paramType, com.sun.xml.ws.org.objectweb.asm.Type asmType, boolean noXmlElem, List<Annotation> jaxbAnnotations) {
            this(paramName, paramType, asmType, noXmlElem, null, null, jaxbAnnotations);
        }

        Field(String paramName, Type paramType, com.sun.xml.ws.org.objectweb.asm.Type asmType, boolean noXmlElem, String elementName, String elementNS, List<Annotation> jaxbAnnotations) {
            this.reflectType = paramType;
            this.asmType = asmType;
            this.fieldName = paramName;
            this.jaxbAnnotations = jaxbAnnotations;
            this.noXmlElem = noXmlElem;
        }

        String getSignature() {
            if (this.reflectType instanceof Class) {
                return null;
            }
            if (this.reflectType instanceof TypeVariable) {
                return null;
            }
            return FieldSignature.vms(this.reflectType);
        }

        @Override
        public int compareTo(Field o) {
            return this.fieldName.compareTo(o.fieldName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FieldFactory
    implements AbstractWrapperBeanGenerator.BeanMemberFactory<Type, Field> {
        private FieldFactory() {
        }

        @Override
        public Field createWrapperBeanMember(Type paramType, String paramName, QName elementName, List<Annotation> jaxb) {
            return new Field(paramName, paramType, WrapperBeanGenerator.getASMType(paramType), elementName.getLocalPart(), elementName.getNamespaceURI(), jaxb);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RuntimeWrapperBeanGenerator
    extends AbstractWrapperBeanGenerator<Type, Method, Field> {
        protected RuntimeWrapperBeanGenerator(AnnotationReader<Type, ?, ?, Method> annReader, Navigator<Type, ?, ?, Method> nav, AbstractWrapperBeanGenerator.BeanMemberFactory<Type, Field> beanMemberFactory) {
            super(annReader, nav, beanMemberFactory);
        }

        @Override
        protected Type getSafeType(Type type) {
            return type;
        }

        @Override
        protected Type getHolderValueType(Type paramType) {
            ParameterizedType p;
            if (paramType instanceof ParameterizedType && (p = (ParameterizedType)paramType).getRawType().equals(Holder.class)) {
                return p.getActualTypeArguments()[0];
            }
            return null;
        }

        @Override
        protected boolean isVoidType(Type type) {
            return type == Void.TYPE;
        }
    }
}

