/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.assembler.TubeAppender;
import com.sun.xml.ws.assembler.WsitClientTubeAssemblyContext;
import com.sun.xml.ws.assembler.WsitServerTubeAssemblyContext;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.rx.mc.api.MakeConnectionSupportedFeature;
import com.sun.xml.ws.rx.mc.policy.spi_impl.McFeatureConfigurator;
import com.sun.xml.ws.rx.mc.runtime.McClientTube;
import com.sun.xml.ws.rx.mc.runtime.McConfiguration;
import com.sun.xml.ws.rx.mc.runtime.McConfigurationFactory;
import com.sun.xml.ws.rx.mc.runtime.McServerTube;
import com.sun.xml.ws.rx.rm.api.ReliableMessagingFeature;
import com.sun.xml.ws.rx.rm.policy.spi_impl.RmFeatureConfigurator;
import java.util.Collection;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;

public class McTubeAppender
implements TubeAppender {
    public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
        McConfiguration configuration = McTubeAppender.createConfiguration(context.getWsdlPort(), context.getBinding(), context.getPolicyMap());
        if (configuration.isMakeConnectionSupportEnabled()) {
            return new McClientTube(configuration, context.getTubelineHead());
        }
        return context.getTubelineHead();
    }

    public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
        McConfiguration configuration = McTubeAppender.createConfiguration(context.getWsdlPort(), context.getEndpoint().getBinding(), context.getPolicyMap());
        if (configuration.isMakeConnectionSupportEnabled()) {
            return new McServerTube(configuration, context.getTubelineHead());
        }
        return context.getTubelineHead();
    }

    private static McConfiguration createConfiguration(WSDLPort port, WSBinding binding, PolicyMap policyMap) {
        ReliableMessagingFeature rmf = null;
        MakeConnectionSupportedFeature mcf = null;
        try {
            WebServiceFeature feature;
            PolicyMapKey key = port == null ? null : PolicyMap.createWsdlEndpointScopeKey(port.getOwner().getName(), port.getName());
            Collection<WebServiceFeature> features = new RmFeatureConfigurator().getFeatures(key, policyMap);
            if (features != null && !features.isEmpty() && (feature = features.iterator().next()) instanceof ReliableMessagingFeature) {
                rmf = (ReliableMessagingFeature)feature;
            }
            if ((features = new McFeatureConfigurator().getFeatures(key, policyMap)) != null && !features.isEmpty() && (feature = features.iterator().next()) instanceof MakeConnectionSupportedFeature) {
                mcf = (MakeConnectionSupportedFeature)feature;
            }
            return McConfigurationFactory.INSTANCE.createInstance(rmf, mcf, port, binding);
        }
        catch (PolicyException e) {
            throw new WebServiceException((Throwable)e);
        }
    }
}

