/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.common;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.JavaMethod;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapExtender;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.SimpleAssertion;
import com.sun.xml.ws.policy.jaxws.spi.PolicyMapUpdateProvider;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.tx.common.Constants;
import com.sun.xml.ws.tx.common.LocalizationMessages;
import com.sun.xml.ws.tx.common.TransactionAnnotationProcessor;
import com.sun.xml.ws.tx.common.TxLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class TxMapUpdateProvider
implements PolicyMapUpdateProvider {
    private static final TxLogger logger = TxLogger.getATLogger(TxMapUpdateProvider.class);
    private static boolean nonJavaEEContainer = false;
    private static final WsatPolicyAssertion AT_ASSERTION_OPTIONAL = new WsatPolicyAssertion(Constants.AT_ASSERTION, true);
    private static final WsatPolicyAssertion AT_ASSERTION_REQUIRED = new WsatPolicyAssertion(Constants.AT_ASSERTION, false);
    private static final WsatPolicyAssertion AT_ALWAYS_CAPABILITY_PA = new WsatPolicyAssertion(Constants.AT_ALWAYS_CAPABILITY, false);

    public void update(PolicyMapExtender policyMapMutator, PolicyMap policyMap, SEIModel model, WSBinding wsBinding) throws PolicyException {
        String METHOD_NAME = "update";
        if (nonJavaEEContainer) {
            return;
        }
        if (model != null) {
            Collection<? extends JavaMethod> methods = model.getJavaMethods();
            Class<?> CMTEJB = null;
            TransactionAnnotationProcessor.TransactionAttributeType classDefaultTxnAttr = null;
            for (JavaMethod javaMethod : methods) {
                if (CMTEJB == null) {
                    boolean isCMTEJB = false;
                    Class<?> theClass = javaMethod.getSEIMethod().getDeclaringClass();
                    try {
                        isCMTEJB = TransactionAnnotationProcessor.isContainerManagedEJB(theClass);
                    }
                    catch (NoClassDefFoundError e) {
                        nonJavaEEContainer = true;
                        logger.fine("update", LocalizationMessages.NON_EE_CONTAINER_2005("NoClassDefFoundError: " + e.getLocalizedMessage()));
                        return;
                    }
                    if (isCMTEJB) {
                        CMTEJB = theClass;
                        classDefaultTxnAttr = TransactionAnnotationProcessor.getTransactionAttributeDefault(theClass);
                    } else {
                        return;
                    }
                }
                TransactionAnnotationProcessor.TransactionAttributeType txnAttr = TransactionAnnotationProcessor.getEffectiveTransactionAttribute(javaMethod.getSEIMethod(), classDefaultTxnAttr);
                String policyId = model.getBoundPortTypeName().getLocalPart() + "_" + javaMethod.getOperationName() + "_WSAT_Policy";
                Policy policy = this.mapTransactionAttribute2WSATPolicy(policyId, txnAttr);
                if (policy == null) continue;
                PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey(model.getServiceQName(), model.getPortName(), new QName(model.getTargetNamespace(), javaMethod.getOperationName()));
                PolicySubject generatedWsatPolicySubject = new PolicySubject((Object)javaMethod, policy);
                if (logger.isLogging(Level.FINE)) {
                    logger.fine("update", LocalizationMessages.ADD_AT_POLICY_ASSERTION_2007(model.getPortName().toString(), javaMethod.getOperationName(), policy.toString(), txnAttr.toString(), CMTEJB.getName(), javaMethod.getMethod().getName()));
                } else {
                    logger.info("update", LocalizationMessages.ADD_AT_POLICY_ASSERTION_2007(model.getPortName().toString(), javaMethod.getOperationName(), policy.getId(), txnAttr.toString(), CMTEJB.getName(), javaMethod.getMethod().getName()));
                }
                policyMapMutator.putOperationSubject(operationKey, generatedWsatPolicySubject);
            }
        }
    }

    private Policy mapTransactionAttribute2WSATPolicy(String id, TransactionAnnotationProcessor.TransactionAttributeType txnAttr) {
        switch (txnAttr) {
            case NOT_SUPPORTED: 
            case NEVER: {
                return null;
            }
            case MANDATORY: {
                return TxMapUpdateProvider.createATPolicy(id, AT_ASSERTION_REQUIRED);
            }
            case SUPPORTS: {
                return TxMapUpdateProvider.createATPolicy(id, AT_ASSERTION_OPTIONAL);
            }
            case REQUIRES_NEW: {
                return TxMapUpdateProvider.createATPolicy(id, AT_ALWAYS_CAPABILITY_PA);
            }
            case REQUIRED: {
                return TxMapUpdateProvider.createATPolicy(id, AT_ASSERTION_OPTIONAL, AT_ALWAYS_CAPABILITY_PA);
            }
        }
        return null;
    }

    private static Policy createATPolicy(String id, WsatPolicyAssertion atpa) {
        return TxMapUpdateProvider.createATPolicy(id, atpa, null);
    }

    private static Policy createATPolicy(String id, WsatPolicyAssertion pa1, WsatPolicyAssertion pa2) {
        ArrayList<AssertionSet> assertionSets = new ArrayList<AssertionSet>(1);
        int numAssertions = pa2 == null ? 1 : 2;
        ArrayList<WsatPolicyAssertion> assertions = new ArrayList<WsatPolicyAssertion>(numAssertions);
        assertions.add(pa1);
        if (pa2 != null) {
            assertions.add(pa2);
        }
        assertionSets.add(AssertionSet.createAssertionSet(assertions));
        return Policy.createPolicy(null, id, assertionSets);
    }

    static class WsatPolicyAssertion
    extends SimpleAssertion {
        private static AssertionData createAssertionData(QName assertionQName, boolean isOptional) {
            AssertionData result = AssertionData.createAssertionData(assertionQName);
            result.setOptionalAttribute(isOptional);
            if (isOptional) {
                result.setAttribute(Constants.WSP2002_OPTIONAL, "true");
            }
            return result;
        }

        WsatPolicyAssertion(QName wsatPolicyAssertionName, boolean isOptional) {
            super(WsatPolicyAssertion.createAssertionData(wsatPolicyAssertionName, isOptional), null);
        }
    }
}

