/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.XMLStreamReaderToContentHandler;
import com.sun.xml.bind.api.Bridge;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.encoding.TagInfoset;
import com.sun.xml.ws.message.AbstractMessageImpl;
import com.sun.xml.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.ws.security.opt.impl.util.VerifiedMessageXMLStreamReader;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.util.xml.DummyLocation;
import com.sun.xml.ws.util.xml.StAXSource;
import com.sun.xml.ws.util.xml.XMLStreamReaderToXMLStreamWriter;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.logging.impl.opt.LogStringsMessages;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VerifiedStreamMessage
extends AbstractMessageImpl {
    @NotNull
    private XMLStreamReader reader;
    private MutableXMLStreamBuffer buffer = null;
    @Nullable
    private HeaderList headers;
    private final String payloadLocalName;
    private final String payloadNamespaceURI;
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt", "com.sun.xml.wss.logging.impl.opt.LogStrings");
    private Map<String, String> bodyEnvNs;
    @NotNull
    private TagInfoset envelopeTag;
    @NotNull
    private TagInfoset headerTag;
    @NotNull
    private TagInfoset bodyTag;
    private Throwable consumedAt;
    private static final TagInfoset[] DEFAULT_TAGS = new TagInfoset[6];

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VerifiedStreamMessage(@Nullable HeaderList headers, @NotNull AttachmentSet attachmentSet, @NotNull XMLStreamReader reader, @NotNull SOAPVersion soapVersion, Map<String, String> bodyEnvNs) {
        super(soapVersion);
        this.headers = headers;
        this.attachmentSet = attachmentSet;
        this.reader = reader;
        this.bodyEnvNs = bodyEnvNs;
        if (reader.getEventType() == 7) {
            XMLStreamReaderUtil.nextElementContent(reader);
        }
        if (reader.getEventType() == 2) {
            String body = reader.getLocalName();
            String nsUri = reader.getNamespaceURI();
            assert (body != null);
            assert (nsUri != null);
            if (!body.equals("Body") || !nsUri.equals(soapVersion.nsUri)) throw new WebServiceException("Malformed stream: {" + nsUri + "}" + body);
            this.payloadLocalName = null;
            this.payloadNamespaceURI = null;
        } else {
            this.payloadLocalName = reader.getLocalName();
            this.payloadNamespaceURI = reader.getNamespaceURI();
        }
        int base = soapVersion.ordinal() * 3;
        this.envelopeTag = DEFAULT_TAGS[base];
        this.headerTag = DEFAULT_TAGS[base + 1];
        this.bodyTag = DEFAULT_TAGS[base + 2];
    }

    public VerifiedStreamMessage(@NotNull TagInfoset envelopeTag, @Nullable TagInfoset headerTag, @NotNull AttachmentSet attachmentSet, @Nullable HeaderList headers, @NotNull TagInfoset bodyTag, @NotNull XMLStreamReader reader, @NotNull SOAPVersion soapVersion, Map<String, String> bodyEnvNs) {
        this(headers, attachmentSet, reader, soapVersion, bodyEnvNs);
        assert (envelopeTag != null && bodyTag != null);
        this.envelopeTag = envelopeTag;
        this.headerTag = headerTag != null ? headerTag : new TagInfoset(envelopeTag.nsUri, "Header", envelopeTag.prefix, EMPTY_ATTS, new String[0]);
        this.bodyTag = bodyTag;
    }

    @Override
    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    @Override
    public HeaderList getHeaders() {
        if (this.headers == null) {
            this.headers = new HeaderList();
        }
        return this.headers;
    }

    @Override
    @NotNull
    public AttachmentSet getAttachments() {
        return this.attachmentSet;
    }

    @Override
    public String getPayloadLocalPart() {
        return this.payloadLocalName;
    }

    @Override
    public String getPayloadNamespaceURI() {
        return this.payloadNamespaceURI;
    }

    @Override
    public boolean hasPayload() {
        return this.payloadLocalName != null;
    }

    @Override
    public Source readPayloadAsSource() {
        this.cacheMessage();
        if (this.hasPayload()) {
            assert (this.unconsumed());
            return new StAXSource(this.reader, true);
        }
        return null;
    }

    public Object readPayloadAsJAXB(final Unmarshaller unmarshaller) throws JAXBException {
        try {
            this.cacheMessage();
            if (!this.hasPayload()) {
                return null;
            }
            assert (this.unconsumed());
            Object ret = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    if (VerifiedStreamMessage.this.hasAttachments()) {
                        unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)new AttachmentUnmarshallerImpl(VerifiedStreamMessage.this.getAttachments()));
                    }
                    try {
                        VerifiedStreamMessage.this.reader;
                        if (8 == VerifiedStreamMessage.this.reader.getEventType() && VerifiedStreamMessage.this.buffer != null) {
                            try {
                                VerifiedStreamMessage.this.reader = VerifiedStreamMessage.this.buffer.readAsXMLStreamReader();
                                VerifiedStreamMessage.this.reader = new VerifiedMessageXMLStreamReader(VerifiedStreamMessage.this.reader, VerifiedStreamMessage.this.bodyEnvNs);
                                VerifiedStreamMessage.this.reader.next();
                            }
                            catch (XMLStreamException ex) {
                                logger.log(Level.SEVERE, LogStringsMessages.WSS_1612_ERROR_READING_BUFFER(), ex);
                                throw new XWSSecurityRuntimeException(ex);
                            }
                        }
                        Object object = unmarshaller.unmarshal(VerifiedStreamMessage.this.reader);
                        return object;
                    }
                    finally {
                        unmarshaller.setAttachmentUnmarshaller(null);
                        XMLStreamReaderUtil.close(VerifiedStreamMessage.this.reader);
                        XMLStreamReaderFactory.recycle(VerifiedStreamMessage.this.reader);
                    }
                }
            });
            return ret;
        }
        catch (PrivilegedActionException ex) {
            throw new XWSSecurityRuntimeException(ex);
        }
    }

    @Override
    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        this.cacheMessage();
        if (!this.hasPayload()) {
            return null;
        }
        assert (this.unconsumed());
        T r = bridge.unmarshal(this.reader, (AttachmentUnmarshaller)(this.hasAttachments() ? new AttachmentUnmarshallerImpl(this.getAttachments()) : null));
        XMLStreamReaderUtil.close(this.reader);
        XMLStreamReaderFactory.recycle(this.reader);
        return r;
    }

    @Override
    public void consume() {
        assert (this.unconsumed());
        XMLStreamReaderFactory.recycle(this.reader);
    }

    @Override
    public XMLStreamReader readPayload() {
        this.cacheMessage();
        assert (this.unconsumed());
        return this.reader;
    }

    @Override
    public void writePayloadTo(XMLStreamWriter writer) throws XMLStreamException {
        if (this.payloadLocalName == null) {
            return;
        }
        assert (this.unconsumed());
        XMLStreamReaderToXMLStreamWriter conv = new XMLStreamReaderToXMLStreamWriter();
        while (this.reader.getEventType() != 8) {
            String name = this.reader.getLocalName();
            String nsUri = this.reader.getNamespaceURI();
            if (!(this.reader.getEventType() != 2 || name.equals("Body") && nsUri.equals(this.soapVersion.nsUri))) {
                XMLStreamReaderUtil.nextElementContent(this.reader);
                if (this.reader.getEventType() == 8) break;
                name = this.reader.getLocalName();
                nsUri = this.reader.getNamespaceURI();
            }
            if (name.equals("Body") && nsUri.equals(this.soapVersion.nsUri) || this.reader.getEventType() == 8) break;
            conv.bridge(this.reader, writer);
        }
        this.reader.close();
        XMLStreamReaderFactory.recycle(this.reader);
    }

    @Override
    public void writeTo(XMLStreamWriter sw) throws XMLStreamException {
        this.writeEnvelope(sw);
    }

    private void writeEnvelope(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument();
        this.envelopeTag.writeStart(writer);
        HeaderList hl = this.getHeaders();
        if (hl.size() > 0) {
            this.headerTag.writeStart(writer);
            for (Header h : hl) {
                h.writeTo(writer);
            }
            writer.writeEndElement();
        }
        this.bodyTag.writeStart(writer);
        if (this.hasPayload()) {
            this.writePayloadTo(writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    @Override
    public void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean fragment) throws SAXException {
        assert (this.unconsumed());
        try {
            if (this.payloadLocalName == null) {
                return;
            }
            XMLStreamReaderToContentHandler conv = new XMLStreamReaderToContentHandler(this.reader, contentHandler, true, fragment);
            while (this.reader.getEventType() != 8) {
                String name = this.reader.getLocalName();
                String nsUri = this.reader.getNamespaceURI();
                if (!(this.reader.getEventType() != 2 || name.equals("Body") && nsUri.equals(this.soapVersion.nsUri))) {
                    XMLStreamReaderUtil.nextElementContent(this.reader);
                    if (this.reader.getEventType() == 8) break;
                    name = this.reader.getLocalName();
                    nsUri = this.reader.getNamespaceURI();
                }
                if (name.equals("Body") && nsUri.equals(this.soapVersion.nsUri) || this.reader.getEventType() == 8) break;
                conv.bridge();
            }
            this.reader.close();
            XMLStreamReaderFactory.recycle(this.reader);
        }
        catch (XMLStreamException e) {
            Location loc = e.getLocation();
            if (loc == null) {
                loc = DummyLocation.INSTANCE;
            }
            SAXParseException x = new SAXParseException(e.getMessage(), loc.getPublicId(), loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber(), e);
            errorHandler.error(x);
        }
    }

    @Override
    public Message copy() {
        try {
            XMLStreamReader clone;
            if (this.hasPayload()) {
                assert (this.unconsumed());
                this.consumedAt = null;
                MutableXMLStreamBuffer xsb = new MutableXMLStreamBuffer();
                StreamReaderBufferCreator c = new StreamReaderBufferCreator(xsb);
                while (this.reader.getEventType() != 8) {
                    String name = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    if (name.equals("Body") && nsUri.equals(this.soapVersion.nsUri) || this.reader.getEventType() == 8) break;
                    c.create(this.reader);
                }
                XMLStreamReaderFactory.recycle(this.reader);
                this.reader = xsb.readAsXMLStreamReader();
                this.reader = new VerifiedMessageXMLStreamReader(this.reader, this.bodyEnvNs);
                clone = xsb.readAsXMLStreamReader();
                VerifiedMessageXMLStreamReader clonedReader = new VerifiedMessageXMLStreamReader(clone, this.bodyEnvNs);
                this.proceedToRootElement(this.reader);
                this.proceedToRootElement(clonedReader);
            } else {
                clone = this.reader;
                XMLStreamReader clonedReader = this.reader;
            }
            return new VerifiedStreamMessage(this.envelopeTag, this.headerTag, this.attachmentSet, HeaderList.copy(this.headers), this.bodyTag, clone, this.soapVersion, this.bodyEnvNs);
        }
        catch (XMLStreamException e) {
            throw new WebServiceException("Failed to copy a message", (Throwable)e);
        }
    }

    @Override
    public SOAPMessage readAsSOAPMessage() throws SOAPException {
        this.cacheMessage();
        return super.readAsSOAPMessage();
    }

    private void proceedToRootElement(XMLStreamReader xsr) throws XMLStreamException {
        assert (xsr.getEventType() == 7);
        xsr.nextTag();
        assert (xsr.getEventType() == 1);
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        contentHandler.setDocumentLocator(NULL_LOCATOR);
        contentHandler.startDocument();
        this.envelopeTag.writeStart(contentHandler);
        this.headerTag.writeStart(contentHandler);
        if (this.hasHeaders()) {
            HeaderList headers = this.getHeaders();
            int len = headers.size();
            for (int i = 0; i < len; ++i) {
                headers.get(i).writeTo(contentHandler, errorHandler);
            }
        }
        this.headerTag.writeEnd(contentHandler);
        this.bodyTag.writeStart(contentHandler);
        this.writePayloadTo(contentHandler, errorHandler, true);
        this.bodyTag.writeEnd(contentHandler);
        this.envelopeTag.writeEnd(contentHandler);
    }

    private boolean unconsumed() {
        if (this.payloadLocalName == null) {
            return true;
        }
        if (this.reader.getEventType() != 1) {
            AssertionError error = new AssertionError((Object)"StreamMessage has been already consumed. See the nested exception for where it's consumed");
            ((Throwable)((Object)error)).initCause(this.consumedAt);
            throw error;
        }
        this.consumedAt = new Exception().fillInStackTrace();
        return true;
    }

    private static void create(SOAPVersion v) {
        int base = v.ordinal() * 3;
        VerifiedStreamMessage.DEFAULT_TAGS[base] = new TagInfoset(v.nsUri, "Envelope", "S", EMPTY_ATTS, "S", v.nsUri);
        VerifiedStreamMessage.DEFAULT_TAGS[base + 1] = new TagInfoset(v.nsUri, "Header", "S", EMPTY_ATTS, new String[0]);
        VerifiedStreamMessage.DEFAULT_TAGS[base + 2] = new TagInfoset(v.nsUri, "Body", "S", EMPTY_ATTS, new String[0]);
    }

    private void cacheMessage() {
        if (this.buffer == null) {
            try {
                this.buffer = new MutableXMLStreamBuffer();
                this.buffer.createFromXMLStreamReader(this.reader);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1611_PROBLEM_CACHING(), ex);
                throw new XWSSecurityRuntimeException(ex);
            }
            try {
                this.reader = this.buffer.readAsXMLStreamReader();
                this.reader = new VerifiedMessageXMLStreamReader(this.reader, this.bodyEnvNs);
                this.reader.next();
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1612_ERROR_READING_BUFFER(), ex);
                throw new XWSSecurityRuntimeException(ex);
            }
        }
    }

    static {
        VerifiedStreamMessage.create(SOAPVersion.SOAP_11);
        VerifiedStreamMessage.create(SOAPVersion.SOAP_12);
    }
}

